/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus;

import java.util.*;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;
import jp.gr.java_conf.jaba2.util.AppParameterInfo;

/**
 * AppDOMParameter
 *
 * @since   Aug. 28, 2000
 * @version Sep.  1, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class AppDOMBusParameter implements IDOMBusParameter {
    private AppParameterInfo info_;

    public AppDOMBusParameter(
	String contextName,
	String[] args,
	String resource,
	File file,
	Locale locale
    ) throws IOException {
	info_ = new AppParameterInfo(
	    contextName,
	    args,
	    resource,
	    file,
	    locale
	);
    }

    public ResourceBundle getResourceBundle() {
	return (info_.getResourceBundle());
    }

    public int getArgumentCount() {
	return (info_.getArgumentCount());
    }

    public URL getArgumentAsURLByFilenameURI(int index)
	throws MalformedURLException {

	return (info_.getArgumentAsURLFromFileOrURL(index));
    }

    public Object getParameter(String key) {
	return (info_.getParameter(key));
    }

    public String getParameterAsString(String key) {
	return (info_.getParameterAsString(key));
    }

    public String[] getParameterAsStringList(String key) {
	return (info_.getParameterAsStringList(key));
    }

    public String[] getParameterAsStringList(String key, String delim) {
	return (info_.getParameterAsStringList(key, delim));
    }

    public URL getParameterAsURLByFilenameURI(String key)
	throws MalformedURLException {

	return (info_.getParameterAsURLFromFileOrURL(key));
    }
}
