/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus;

import java.util.*;
import java.io.File;
import java.io.IOException;

/**
 * DOMBusContext
 *
 * @since   Mar. 27, 2000
 * @version Aug. 29, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DOMBusContext implements IDOMBusContext {
    private String name_;
    private String resourceName_;
    private String userPropertyFile_;
    private List components_ = new ArrayList();
    private Map roles_ = new HashMap();
    private Map properties_ = new HashMap();
    private IDOMBusParameter params_;

    public final void setup(String[] args) {
	try {
	    if (name_ == null) {
		name_ = "jp.gr.java_conf.jaba2.dombus.DOMBus";
	    }
	    if (resourceName_ == null) {
		resourceName_ = "jp.gr.java_conf.jaba2.dombus.DOMBusDefaults";
	    }
	    if (userPropertyFile_ == null) {
		userPropertyFile_ = "DOMBus.properties";
	    }
	    params_ = new AppDOMBusParameter(
		name_,
		args,
		resourceName_,
		new File(userPropertyFile_),
		Locale.getDefault()
	    );
	} catch (IOException e) {
	    throw (new DOMBusException(e));
	}
    }

    public final IDOMBusParameter getParameter() {
	return (params_);
    }

    public final void setName(String name) {
	name_ = name;
    }

    public final String getName() {
	return (name_);
    }

    public final void setResourceName(String name) {
	resourceName_ = name;
    }

    public final String getResourceName() {
	return (resourceName_);
    }

    public final void setUserPropertyFile(String name) {
	userPropertyFile_ = name;
    }

    public final String getUserPropertyFile() {
	return (userPropertyFile_);
    }

    public final void addComponent(IDOMBusComponent component) {
	components_.add(component);
    }

    public final void setComponent(String role, IDOMBusComponent component) {
	roles_.put(role, component);
	components_.add(component);
    }

    public final IDOMBusComponent getComponent(String role) {
	return ((IDOMBusComponent)roles_.get(role));
    }

    public final void setProperty(String name, Object value) {
	properties_.put(name, value);
    }

    public final Object getProperty(String name) {
	return (properties_.get(name));
    }
}
