package jp.gr.java_conf.jaba2.dombus.configRelaxer;

import org.w3c.dom.*;

/**
 * <b>CComponent</b> is generated by Relaxer based on ConfigFile.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="component">
 *   <sequence>
 *     <ref label="class"/>
 *   </sequence>
 * </elementRule>
 * 
 * <tag name="component"/>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="component"&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="class"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="component"/&gt;
 * </pre>
 *
 * @version ConfigFile.rlx (Tue Aug 29 11:45:15 JST 2000)
 * @author  Relaxer 0.10.2b (by ASAMI@Yokohama)
 */
public class CComponent implements java.io.Serializable {
    private CClass classValue;

    /**
     * Creates a <code>CComponent</code>.
     *
     */
    public CComponent() {
    }

    /**
     * Creates a <code>CComponent</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CComponent(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CComponent</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CComponent(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CComponent</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CComponent(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>CComponent</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CComponent</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CComponent</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IConfigFileFactory factory = ConfigFileFactory.getFactory();
        RStack stack = new RStack(element);
        setClassValue(factory.createCClass(stack));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("component");
        int size;
        classValue.makeElement(element);
        parent.appendChild(element);
    }

    /**
     * Gets the CClass property <b>classValue</b>.
     *
     * @return CClass
     */
    public final CClass getClassValue() {
        return (classValue);
    }

    /**
     * Sets the CClass property <b>classValue</b>.
     *
     * @param classValue
     */
    public final void setClassValue(CClass classValue) {
        this.classValue = classValue;
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CComponent</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        String tagName = element.getTagName();
        if (!"component".equals(tagName)) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (!CClass.isMatchHungry(target)) {
            return (false);
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CComponent</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CComponent</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
