package jp.gr.java_conf.jaba2.dombus.configRelaxer;

import org.w3c.dom.*;

/**
 * <b>CGuard</b> is generated by Relaxer based on ConfigFile.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="guard">
 *   <ref label="guardPredicate" occurs="*"/>
 * </elementRule>
 * 
 * <tag name="guard"/>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="guard"&gt;
 *   &lt;ref label="guardPredicate" occurs="*"/&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="guard"/&gt;
 * </pre>
 *
 * @version ConfigFile.rlx (Tue Aug 29 11:45:15 JST 2000)
 * @author  Relaxer 0.10.2b (by ASAMI@Yokohama)
 */
public class CGuard implements java.io.Serializable {
    // List<ICGuardContent>
    private java.util.List content = new java.util.ArrayList();

    /**
     * Creates a <code>CGuard</code>.
     *
     */
    public CGuard() {
    }

    /**
     * Creates a <code>CGuard</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CGuard(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CGuard</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CGuard(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CGuard</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CGuard(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>CGuard</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CGuard</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CGuard</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IConfigFileFactory factory = ConfigFileFactory.getFactory();
        RStack stack = new RStack(element);
        content.clear();
        while (!stack.isEmptyElement()) {
            if (COrGuardPredicate.isMatch(stack)) {
                addContent(factory.createCOrGuardPredicate(stack));
            } else if (CAndGuardPredicate.isMatch(stack)) {
                addContent(factory.createCAndGuardPredicate(stack));
            } else if (CEventGuardPredicate.isMatch(stack)) {
                addContent(factory.createCEventGuardPredicate(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("guard");
        int size;
        size = content.size();
        for (int i = 0;i < size;i++) {
            ICGuardContent value = (ICGuardContent)this.content.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Gets the ICGuardContent property <b>content</b>.
     *
     * @return ICGuardContent[]
     */
    public final ICGuardContent[] getContent() {
        ICGuardContent[] array = new ICGuardContent[content.size()];
        return ((ICGuardContent[])content.toArray(array));
    }

    /**
     * Sets the ICGuardContent property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(ICGuardContent[] content) {
        this.content.clear();
        this.content.addAll(java.util.Arrays.asList(content));
    }

    /**
     * Adds the ICGuardContent property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(ICGuardContent content) {
        this.content.add(content);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CGuard</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        String tagName = element.getTagName();
        if (!"guard".equals(tagName)) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (COrGuardPredicate.isMatchHungry(target)) {
            } else if (CAndGuardPredicate.isMatchHungry(target)) {
            } else if (CEventGuardPredicate.isMatchHungry(target)) {
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CGuard</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CGuard</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
