/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.j2fw.generator.packager;

import java.util.*;
import java.io.*;
import java.util.jar.*;
import java.util.zip.ZipEntry;
import jp.gr.java_conf.jaba2.io.UIO;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.j2fw.generator.*;

/**
 * JarPackager
 *
 * @since   May. 10, 1999
 * @version Feb. 10, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class JarPackager implements IPackager {
    public void pack(
	GeneratorArtifact[] artifacts,
	GeneratorResult result,
	String id,
	Object arg,
	File dest
    ) throws IOException {
	String jarfile = (String)arg;
	if (!jarfile.endsWith(".jar")) {
	    jarfile = jarfile + ".jar";
	}
	String manifestContent = (String)result.getProperty("manifest");
	Manifest manifest;
	if (manifestContent != null) {
	    InputStream in = new StringBufferInputStream(manifestContent);
	    manifest = new Manifest(in);
	    in.close();
	} else {
	    manifest = new Manifest();
	}
	JarOutputStream jarout = new JarOutputStream(
	    new BufferedOutputStream(
		new FileOutputStream(new File(dest, jarfile))
	    ),
	    manifest
	);
	for (int i = 0;i < artifacts.length;i++) {
	    GeneratorArtifact artifact = artifacts[i];
	    ZipEntry entry = new ZipEntry(artifact.getName());
	    byte[] content = artifact.getBytes();
/*	    
	    if ("link".equals(artifact.encoding)) {
		if (UURL.isURL(artifact.content)) {
		    // do nothing if content is url link
		    continue;
		}
		File file = new File(artifact.content);
		if (file.isAbsolute()) {
		    // do nothing if content is absolute path
		    continue;
		}
		content = UIO.file2Bytes(artifact.content);
	    } else {
		content = artifact.content.getBytes(artifact.encoding);
	    }
*/
	    entry.setSize(content.length);
	    jarout.putNextEntry(entry);
	    jarout.write(content, 0, content.length);
	}
	jarout.close();
    }
}
