/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.text;

import java.util.*;
import java.io.*;
import java.text.*;

/**
 * UCSString
 *
 * @since   Oct. 13, 1999
 * @version Oct. 13, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class UCSString implements Serializable, Comparable {
    protected String string_;
    protected Locale locale_;
    protected int length_ = -1;
    protected int[] chars_;
    protected CollationKey key_ = null;

    public UCSString(String string, Locale locale) {
	string_ = string.intern(); // really unicode normalization
	locale_ = locale;
    }

    // Comparable
    public int compareTo(Object o) {
	UCSString target = (UCSString)o;
	CollationKey lhs = getCollationKey();
	CollationKey rhs = target.getCollationKey();
	return (lhs.compareTo(rhs));
    }

    // Object
    public boolean equals(Object o) {
	if (o == this) {
	    return (true);
	}
	if (!(o instanceof UCSString)) {
	    return (false);
	}
	return (compareTo(o) == 0);
    }

    public String getString() {
	return (string_);
    }

    public CollationKey getCollationKey() {
	if (key_ == null) {
	    key_ = Collator.getInstance(locale_).getCollationKey(string_);
	}
	return (key_);
    }

    public int length() {
	_ensure();
	return (length_);
    }

    public int charAt(int index) {
	_ensure();
	return (chars_[index]);
    }

    public int[] getChars() {
	_ensure();
	return ((int[])chars_.clone());
    }

    protected void _ensure() {
	if (length_ >= 0) {
	    return;
	}
	BreakIterator boundary
	    = BreakIterator.getCharacterInstance(locale_);
	boundary.setText(string_);
	// count length
	boundary.first();
	int count = 0;
	while (boundary.next() != BreakIterator.DONE) {
	    count++;
	}
	length_ = count;
	// distill charcters
	chars_ = new int[count];
	int start = boundary.first();
	for (int i = 0;i < count;i++) {
	    int end = boundary.next();
	    if (end == BreakIterator.DONE) {
		throw (new InternalError());
	    }
	    String cs = string_.substring(start, end);
	    switch (cs.length()) {
		
	    case 0:
		throw (new InternalError());
	    case 1:
		char c = cs.charAt(0);
		chars_[i] = 0x0000ffff & (int)c;
		break;
	    case 2:		// XXX : temporary, not UCS way
		char c0 = cs.charAt(0);
		char c1 = cs.charAt(1);
		chars_[i] = (int)c1 << 16 | (int)c0;
		break;
	    default:
		throw (new UnsupportedOperationException());
	    }
	}
    }
}
