/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.datatype;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.UElement;
import jp.gr.java_conf.jaba2.datatype.IXMLDatatype;

/**
 * Datatype
 *
 * @since   Feb. 23, 2000
 * @version Aug. 31, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class Datatype implements IXMLDatatype, Cloneable {
    private boolean isList_ = false;
    private List facets_ = new ArrayList();

    public void addFacets(Element element) {
	Element[] facets = UElement.getElements(element);
	for (int i = 0;i < facets.length;i++) {
	    String localName = facets[i].getLocalName();
	    if ("length".equals(localName) ||
		"minLength".equals(localName) ||
		"maxLength".equals(localName) ||
		"pattern".equals(localName) ||
		"enumeration".equals(localName) ||
		"whiteSpace".equals(localName) ||
		"maxInclusive".equals(localName) ||
		"maxExclusive".equals(localName) ||
		"minInclusive".equals(localName) ||
		"minExclusive".equals(localName) ||
		"totalDigits".equals(localName) ||
		"fractionDigits".equals(localName)) {

		facets_.add(facets[i]);
	    }
	}
    }

    public Element[] getFacets() {
	if (facets_.size() == 0) {
	    return (null);
	} else {
	    Element[] result = new Element[facets_.size()];
	    return ((Element[])facets_.toArray(result));
	}
    }

    public abstract String getName();

    public String makeCDATA(Object object) {
	return (object.toString());
    }

    public abstract Object makeObject(String cdata);

    public final boolean isList() {
	return (isList_);
    }

    public final void setList(boolean isList) {
	isList_ = isList;
    }

    public Object clone() {
	try {
	    return (super.clone());
	} catch (CloneNotSupportedException e) {
	    throw (new InternalError());
	}
    }
}
