/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.cooked;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.raw.*;

/**
 * CChoice
 *
 * @since   Dec. 22, 1999
 * @version Jun. 21, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class CChoice extends CNode implements ICParticle, ICContentModel {
    protected List particles_ = new ArrayList(); // List<ICParticle>
    private COccurs occurs_;

    public CChoice() {
	occurs_ = new COccurs("");
    }

    public CChoice(String occurs) {
	occurs_ = new COccurs(occurs);
    }

    public CChoice(RChoice rchoice, CModule module) {
	super(rchoice);
	occurs_ = new COccurs(rchoice.getOccurs());
	RNode[] contents = rchoice.getContents();
	for (int i = 0;i < contents.length;i++) {
	    RNode content = contents[i];
	    if (content instanceof RRef) {
		particles_.add(new CRefWithLabel((RRef)content, module));
	    } else if (content instanceof RImportedLabelRef) {
		particles_.add(
		    new CRefImportedLabel(
			(RImportedLabelRef)content,
			module
		    )
		);
	    } else if (content instanceof RElement) {
		particles_.add(new CElement((RElement)content, module));
	    } else if (content instanceof RSequence) {
		particles_.add(new CSequence((RSequence)content, module));
	    } else if (content instanceof RChoice) {
		particles_.add(new CChoice((RChoice)content, module));
	    } else if (content instanceof RNone) {
		particles_.add(new CNone());
	    } else if (content instanceof REmpty) {
		// do nothing
	    } else if (content instanceof RDatatypeRef) {
		throw (new InternalError());
	    } else if (content instanceof RAttribute) {
		throw (new InternalError());
	    } else if (content instanceof REnumeration) {
		throw (new InternalError());
	    } else if (content instanceof RLiteral) {
		throw (new InternalError());
	    } else {
		throw (new InternalError());
	    }
	}
    }

    public final void addParticle(ICParticle particle) {
	particles_.add(particle);
    }

    public final ICParticle[] getParticles() {
	ICParticle[] particles = new ICParticle[particles_.size()];
	return ((ICParticle[])particles_.toArray(particles));
    }

    public final COccurs getOccurs() {
	return (occurs_);
    }
}
