/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * EExternalRefNode
 *
 * @since   Nov. 27, 2000
 * @version Dec. 15, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class EExternalContentRefNode extends ENode implements IEOccurs {
    private String namespace_;
    private String label_;
    private int occurs_;
    private EContentNode cNode_;

    public EExternalContentRefNode(EExternalContentRefNode ref) {
	this(ref.getNamespace(), ref.getLabel(), ref.getOccurs());
	cNode_ = ref.cNode_;
    }

    public EExternalContentRefNode(
	String namespace,
	String label,
	int occurs
    ) {
	super("externalContentRef");
	namespace_ = namespace;
	label_ = label;
	occurs_ = occurs;
	setAttribute("namespace", namespace);
	setAttribute("label", label);
	setAttribute("occurs", UERule.getOccursSymbol(occurs));
    }

    public final String getNamespace() {
	return (namespace_);
    }

    public final String getLabel() {
	return (label_);
    }

    public final int getOccurs() {
	return (occurs_);
    }

    public final void setOccurs(int occurs) {
	occurs_ = occurs;
    }

    public final void setContentNode(EContentNode cNode) {
	cNode_ = cNode;
    }

    public final EContentNode getContentNode() {
	return (cNode_);
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }

    public synchronized void lockWrite() throws InterruptedException {
	super.lockWrite();
	cNode_.lockWrite();
    }

    public synchronized void unlockWrite() throws InterruptedException {
	cNode_.unlockWrite();
	super.unlockWrite();
    }

    public synchronized boolean isLockWrite() {
	return (cNode_.isLockWrite());
    }

    public synchronized void lockRead() throws InterruptedException {
	super.lockRead();
	cNode_.lockRead();
    }

    public synchronized void unlockRead() throws InterruptedException {
	cNode_.unlockRead();
	super.unlockRead();
    }

    public synchronized boolean isLockRead() {
	return (cNode_.isLockRead());
    }
}
