/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relaxng;

import java.util.*;
import java.io.IOException;
import java.net.URL;
import org.w3c.dom.Document;
import jp.gr.java_conf.jaba2.xml.*;
import jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;
import jp.gr.java_conf.jaba2.xml.relax.expanded.*;

/**
 * RNGModule
 *
 * @since   Jun. 15, 2001
 * @version Jun. 19, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class RNGModule {
    private String namespaceURI_;
    private CModule cModule_;

    public RNGModule(String namespaceURI) {
	namespaceURI_ = namespaceURI;
	cModule_ = new CModule(namespaceURI);
    }

    public final CModule getCModule() {
	return (cModule_);
    }

    public final void setFileURI(String uri) {
	cModule_.setFileURI(uri);
    }

    public final void setBaseURI(String uri) {
	cModule_.setBaseURI(uri);
    }

    public final void addExportLabel(String label) {
	cModule_.addExportLabel(label);
    }
}
