package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>RNGrammar</b> is generated by Relaxer based on relaxNg.rxm.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="grammar">
 *   <tag name="grammar"/>
 *   <sequence>
 *     <ref label="start"/>
 *     <ref label="define" occurs="*"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="grammar"&gt;
 *   &lt;tag name="grammar"/&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="start"/&gt;
 *     &lt;ref label="define" occurs="*"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version relaxNg.rxm (Tue Jan 22 17:40:38 JST 2002)
 * @author  Relaxer 0.16.1b (http://www.relaxer.org)
 */
public class RNGrammar implements java.io.Serializable, IRNSContainer, IRNode {
    private RNSContext rNSContext_ = new RNSContext(this, "http://relaxng.org/ns/structure/1.0");
    private RNStart start_;
    // List<RNDefine>
    private java.util.List define_ = new java.util.ArrayList();
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>RNGrammar</code>.
     *
     */
    public RNGrammar() {
    }

    /**
     * Creates a <code>RNGrammar</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public RNGrammar(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>RNGrammar</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public RNGrammar(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>RNGrammar</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public RNGrammar(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>RNGrammar</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNGrammar(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>RNGrammar</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNGrammar(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>RNGrammar</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNGrammar(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>RNGrammar</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNGrammar(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>RNGrammar</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNGrammar(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>RNGrammar</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNGrammar(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>RNGrammar</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>RNGrammar</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>RNGrammar</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        setStart(new RNStart(stack));
        define_.clear();
        while (!stack.isEmptyElement()) {
            if (RNDefine.isMatch(stack)) {
                addDefine(new RNDefine(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "grammar");
        rNSContext_.setupNamespace(element);
        int size;
        this.start_.makeElement(element);
        size = this.define_.size();
        for (int i = 0;i < size;i++) {
            RNDefine value = (RNDefine)this.define_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>RNGrammar</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>RNGrammar</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNGrammar</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNGrammar</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNGrammar</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNGrammar</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>rNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext getRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>rNSContext</b>.
     *
     * @param rNSContext
     */
    public final void setRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the RNStart property <b>start</b>.
     *
     * @return RNStart
     */
    public final RNStart getStart() {
        return (start_);
    }

    /**
     * Sets the RNStart property <b>start</b>.
     *
     * @param start
     */
    public final void setStart(RNStart start) {
        this.start_ = start;
        if (start != null) {
            start.setParentRNode(this);
        }
    }

    /**
     * Gets the RNDefine property <b>define</b>.
     *
     * @return RNDefine[]
     */
    public final RNDefine[] getDefine() {
        RNDefine[] array = new RNDefine[define_.size()];
        return ((RNDefine[])define_.toArray(array));
    }

    /**
     * Sets the RNDefine property <b>define</b>.
     *
     * @param define
     */
    public final void setDefine(RNDefine[] define) {
        this.define_.clear();
        this.define_.addAll(java.util.Arrays.asList(define));
        for (int i = 0;i < define.length;i++) {
            define[i].setParentRNode(this);
        }
    }

    /**
     * Sets the RNDefine property <b>define</b>.
     *
     * @param define
     */
    public final void setDefine(RNDefine define) {
        this.define_.clear();
        this.define_.add(define);
        if (define != null) {
            define.setParentRNode(this);
        }
    }

    /**
     * Adds the RNDefine property <b>define</b>.
     *
     * @param define
     */
    public final void addDefine(RNDefine define) {
        this.define_.add(define);
        if (define != null) {
            define.setParentRNode(this);
        }
    }

    /**
     * Gets number of the RNDefine property <b>define</b>.
     *
     * @return int
     */
    public final int getDefineCount() {
        return (define_.size());
    }

    /**
     * Gets the RNDefine property <b>define</b> by index.
     *
     * @param index
     * @return RNDefine
     */
    public final RNDefine getDefine(int index) {
        return ((RNDefine)define_.get(index));
    }

    /**
     * Sets the RNDefine property <b>define</b> by index.
     *
     * @param index
     * @param define
     */
    public final void setDefine(int index, RNDefine define) {
        this.define_.set(index, define);
    }

    /**
     * Gets the element to use object construction.
     *
     * @return Element
     */
    public Element getXMLElement() {
        return (xmlElement);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.append("<");
        URelaxer.makeQName(prefix, "grammar", buffer);
        rNSContext_.makeNSMappings(buffer);
        buffer.append(">");
        start_.makeTextElement(buffer);
        size = this.define_.size();
        for (int i = 0;i < size;i++) {
            RNDefine value = (RNDefine)this.define_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "grammar", buffer);
        buffer.append(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.print("<");
        URelaxer.makeQName(prefix, "grammar", buffer);
        rNSContext_.makeNSMappings(buffer);
        buffer.print(">");
        start_.makeTextElement(buffer);
        size = this.define_.size();
        for (int i = 0;i < size;i++) {
            RNDefine value = (RNDefine)this.define_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "grammar", buffer);
        buffer.print(">");
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.add(start_);
        classNodes.addAll(define_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>RNGrammar</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://relaxng.org/ns/structure/1.0", "grammar")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (!RNStart.isMatchHungry(target)) {
            return (false);
        }
        while (!target.isEmptyElement()) {
            if (!RNDefine.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNGrammar</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNGrammar</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
