/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998,1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc.normalizer;

import java.util.*;
import java.text.*;
import jp.gr.java_conf.jaba2.SmartDoc.*;

/**
 * LineNumberNormalizer
 *
 * @since   Aug. 11, 1999
 * @version Aug. 13, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class LineNumberNormalizer extends AbstractNormalizer {
    protected Content[] _normalize(
	Content[] contents,
	Content parent,
	DocContext context
    ) {
	List lines = new ArrayList();
	List chunks = new ArrayList();
	for (int i = 0;i < contents.length;i++) {
	    Content content = contents[i];
	    if (content instanceof CharBlock) {
		String text = content.getText();
		StringBuffer buffer = new StringBuffer();
		int size = text.length();
		for (int j = 0;j < size;j++) {
		    char c = text.charAt(j);
		    if (c == '\n') {
			buffer.append(c);
			chunks.add(new CharBlock(new String(buffer)));
			lines.add(chunks);
			chunks = new ArrayList();
			buffer = new StringBuffer();
		    } else {
			buffer.append(c);
		    }
		}
		if (buffer.length() > 0) {
		    chunks.add(new String(buffer));
		}
	    } else {
		chunks.add(content);
	    }
	}
	if (chunks.size() > 0) {
	    lines.add(chunks);
	}
	int nLines = lines.size();
	int width = _displayWidth(nLines);
	StringBuffer buffer = new StringBuffer();
	for (int i = 0;i < width;i++) {
	    buffer.append("#");
	}
	buffer.append(": ");
	String format = new String(buffer);
	NumberFormat formater = new DecimalFormat(format);
	List result = new ArrayList();
	for (int i = 0;i < nLines;i++) {
	    result.add(new CharBlock(formater.format(i + 1)));
	    chunks = (List)lines.get(i);
	    int nChunks = chunks.size();
	    for (int j = 0;j < nChunks;j++) {
		result.add(chunks.get(j));
	    }
	}
	return (UDoc.list2Contents(result));
    }

    protected int _displayWidth(int number) {
	String text = Integer.toString(number);	// XXX
	return (text.length());	// XXX
    }
}
