/*
 * SmartTable
 *  Copyright (C) 1999,2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartTable;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.util.UList;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.xml.*;

/**
 * TagColumnHandler
 *
 * @since   Jul. 28, 1999
 * @version Jan. 17, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class TagColumnHandler implements IColumnHandler {
    protected String path_;
    protected String type_;	// no or any
    protected int columnNo_ = -1; // N/A
    protected IConverter converter_;

    public TagColumnHandler(Element element, int x) {
	path_ = UXML.element2Data(element);
	String columnNoAttr = element.getAttribute("columnNo");
	if (UString.isNull(columnNoAttr)) {
	    type_ = "no";
	    columnNo_ = x;
	} else if (columnNoAttr.equals("any")) {
	    type_ = "any";
	} else {
	    try {
		columnNo_ = Integer.parseInt(columnNoAttr) - 1;
		type_ = "no";
	    } catch (NumberFormatException e) {
		type_ = null;
	    }
	}
	String converter = element.getAttribute("converter");
	if (UString.isNull(converter)) {
	    converter = "text";
	}
	SmartTableModel model = SmartTableContext.getContext().getModel();
	converter_ = model.getConverter(converter);
    }

    /**
     * @deprecated
     */
    public String getTagName() {
	return (path_);		// XXX
    }

    /**
     * @deprecated
     */
    public String getType() {
	return (type_);
    }

    public String getColumnName() {
	return (path_);		// XXX
    }

    public int getColumnNumber() {
	return (columnNo_);
    }

    public void find(Element element, List list) {
	Element data = UXML.findElement(element, path_);
	String text = converter_.nodes2String(data).trim();
	if ("any".equals(type_)) {
	    USmartTable.addList(list, text);
	} else {
	    UList.put(list, columnNo_, text);
	}
    }

    /**
     * @deprecated
     */
    public boolean match(Element element) {
	return (path_.equals(element.getTagName()));
    }

    public boolean match(int x) {
	if ("any".equals(type_)) {
	    return (true);
	}
	return (x == columnNo_);
    }

/*
    public Element makeElement(Document doc) {
	return (doc.createElement(path_));
    }
*/

    public Element makeElement(Document doc, String text) {
	Element element = doc.createElement(path_);
	Node[] nodes = converter_.string2Nodes(doc, text);
	for (int i = 0;i < nodes.length;i++) {
	    element.appendChild(nodes[i]);
	}
	return (element);
    }

    public Node[] makeData(Document doc, String text) {
	return (converter_.string2Nodes(doc, text));
    }
}
