/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import jp.gr.java_conf.jaba2.awt.model.*;

/**
 * DragPane
 *
 * @since   Mar.  4, 1999
 * @version Mar. 26, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class DragPane extends JComponent {
    protected DragModel model_;
    protected Point current_;

    public DragPane(DragModel model) {
	model_ = model;
	current_ = null;
	MouseHandler handler = new MouseHandler();
	addMouseListener(handler);
	addMouseMotionListener(handler);
    }

    public void paint(Graphics g) {
	if (current_ != null) {
	   model_.paint(g, current_);
	}
    }

    class MouseHandler extends MouseAdapter
        implements MouseMotionListener {

	public void mousePressed(MouseEvent evt) {
	    Point point = evt.getPoint();
	    if (model_.isStartDragging(point)) {
		current_ = point;
	    } else {
		current_ = null;
	    }
	    repaint();
	}

	public void mouseReleased(MouseEvent evt) {
	    if (current_ != null) {
		model_.stopDragging(evt.getPoint());
		current_ = null;
		repaint();
	    }
	}

	public void mouseDragged(MouseEvent evt) {
	    if (current_ != null) {
		current_ = evt.getPoint();
		model_.dragged(evt.getPoint());
		repaint();
	    }
	}

	public void mouseMoved(MouseEvent evt) {
	    if (model_.moved(evt.getPoint())) {
		repaint();
	    }
	}
    }

    // test driver
    public static void main(String[] args) {
	DragPane pane = new DragPane(new TestDragModel());
	new JTestFrame("DragPane test", pane);
    }
}
