package jp.gr.java_conf.jaba2.awt;

import java.awt.Component;
import javax.swing.JFrame;

/**
 * The <code>JTestFrame</code> is a test driver for AWT widgets.
 *
 * @since   Apr.  5, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class JTestFrame extends JFrame {
    /**
     * Creates a <code>JTestFrame</code> which shows a spcific AWT widget
     * automatically.
     *
     * @param comp  AWT widget
     */
    public JTestFrame(Component comp) {
	_init("JTestFrame", comp);
    }

    /**
     * Creates a <code>JTestFrame</code> which shows a spcific AWT widget
     * automatically.
     *
     * @param title  frame title
     * @param comp  AWT widget
     */
    public JTestFrame(String title, Component comp) {
	_init(title, comp);
    }

    private void _init(String title, Component comp) {
	setTitle(title);
	addWindowListener(new ExitWhenWindowClosing());
	getContentPane().add(comp);
	pack();
	show();
    }
}
