/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1998  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt;

import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.border.BevelBorder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.io.File;
import jp.gr.java_conf.jaba2.util.PropertyList;
import jp.gr.java_conf.jaba2.util.property.PropertyValue;
import jp.gr.java_conf.jaba2.util.property.PropertyValueEditor;
import jp.gr.java_conf.jaba2.util.property.Enum;
import jp.gr.java_conf.jaba2.util.property.LinkString;
import jp.gr.java_conf.jaba2.util.property.TextResource;
import jp.gr.java_conf.jaba2.util.property.FileHolder;
import jp.gr.java_conf.jaba2.awt.property.PropertyValueViewer;

/**
 * PropertySheet
 *
 * @since   Apr. 18, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class PropertySheet extends JComponent {
    protected PropertyList properties_;
    protected HashSet modified_ = new HashSet(); // List<String>

    public PropertySheet(PropertyList properties) {
	properties_ = properties;
	setLayout(new PropertySheetLayout());
/*
	setLayout(new TableLayout(
	    TableLayout.HBASE_LEFT | TableLayout.VBASE_TOP
	));
*/
	String[] keys = properties_.getKeys();
	for (int i = 0;i < keys.length;i++) {
	    Object value = properties_.get(keys[i]);
	    Class type = properties_.getType(keys[i]);
	    boolean constant = properties_.isConstant(keys[i]);
	    String label = properties_.getAttrString(keys[i], "label");
	    String style = properties_.getAttrString(keys[i], "style");
	    _addProperty(keys[i], value, type, constant, label, style);
	}
    }

    public PropertyList getPropertyList() {
	return (properties_);	// XXX : need clone?
    }

    protected void _addProperty(
	final String key,
	Object value,
	Class type,
	boolean constant,
	String label,
	String style
    ) {
	String valueText = value != null ? value.toString() : "";
	if (style == null) {
	    style = "line";
	}
	add(new JLabel(label), style);
	add(new JLabel(":"));
	if (value instanceof PropertyValue) {
	    final PropertyValue pv = (PropertyValue)value;
	    if (constant) {
		Component viewer = pv.getViewer();
		add(viewer);
		if (pv.hasWideViewer()) {
		    JButton button = new JButton("View");
		    button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
			    ShowDialog dialog = new ShowDialog(
				PropertySheet.this,
				"Viewer",
				pv.getWideViewer()
			    );
			    dialog.show();
			}
		    });
		    add(button);
		}
	    } else {
		Component editor = pv.getEditor();
		if (editor == null) {
		    Component viewer = pv.getViewer();
		    if (viewer instanceof PropertyValueViewer) {
			properties_.addPropertyChangeListener(
			    key,
			    (PropertyValueViewer)viewer
			);
		    }
		    add(viewer);
		} else {
		    add(editor);
		}
		if (pv.hasEditorDialog()) {
		    JButton button = new JButton("Edit");
		    button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
			    Dialog dialog
				= pv.getEditorDialog(PropertySheet.this);
			    dialog.show();
			    properties_.put(
				key,
				((PropertyValueEditor)dialog).getValue()
			    );
			}
		    });
		    add(button);
		} else if (!pv.hasWideEditor()) {
		    if (pv.hasWideViewer()) {
			JButton button = new JButton("View");
			button.addActionListener(new ActionListener() {
			    public void actionPerformed(ActionEvent evt) {
				ShowDialog dialog = new ShowDialog(
				    PropertySheet.this,
				    "Viewer",
				    pv.getWideViewer()
				);
				dialog.show();
			    }
			});
			add(button);
		    }
		} else {
		    JButton button = new JButton("Edit");
		    final Component pve = pv.getWideEditor();
		    if (pve instanceof PropertyValueEditor) {
			button.addActionListener(new ActionListener() {
			    public void actionPerformed(ActionEvent evt) {
				InputDialog dialog = new InputDialog(
				    PropertySheet.this,
				    "Editor",
				    pve
				);
				dialog.addActionListener(new ActionListener() {
				    public void actionPerformed(
					ActionEvent evt) {

					if (evt.getActionCommand().
					    equals("ok")) {

					    Object result
						= ((PropertyValueEditor)pve).
						getValue();
					    properties_.put(key, result);
					}
				    }
				});
				dialog.show();
			    }
			});
		    } else {
			button.addActionListener(new ActionListener() {
			    public void actionPerformed(ActionEvent evt) {
				ShowDialog dialog = new ShowDialog(
				    PropertySheet.this,
				    "Editor",
				    pve
				);
				dialog.show();
			    }
			});
		    }
		    add(button);
		}
	    }
	} else if (type == String.class) {
	    if (constant) {
		add(new JLabel(valueText));
	    } else {
		final JTextField view = new J2TextField(valueText);
		view.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent evt) {
			properties_.put(key, view.getText());
			modified_.add(key);
		    }
		});
		add(view);
	    }
	} else if (type == Color.class) {
	    final Color color = (Color)value;
	    final JLabel view = new JLabel();
	    view.setBorder(new BevelBorder(BevelBorder.LOWERED));
	    view.setOpaque(true);
	    view.setBackground(color);
	    add(view);
	    JButton button = new JButton("Edit");
	    button.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent evt) {
		    Color choose = JColorChooser.showDialog(
			PropertySheet.this,
			"Color Chooser",
			color
		    );
		    if (choose != null) {
			view.setBackground(choose);
			view.repaint();
			properties_.put(key, color);
			modified_.add(key);
		    }
		}
	    });
	    add(button, "last");
	} else if (type == Integer.class) {
	    if (constant) {
		add(new JLabel(valueText));
	    } else {
		final JTextField view = new J2TextField(valueText);
		view.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent evt) {
			properties_.put(key, new Integer(view.getText()));
			modified_.add(key);
		    }
		});
		add(view);
	    }
	} else if (type == Font.class) {
	    add(new JLabel(valueText));
	    JButton button = new JButton("Edit");
	    button.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent evt) {
//		    properties_.put(key, color);
//		    modified_.add(key);
		}
	    });
	    add(button);
	} else if (type == File.class) {
	    add(new JLabel(valueText));
	    JButton button = new JButton("Edit");
	    button.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent evt) {
//		    properties_.put(key, color);
//		    modified_.add(key);
		}
	    });
	    add(button);
/*
	} else if (type == Enum.class) {
	    if (constant) {
		add(((Enum)value).getViewer(), "last");
	    } else {
		add(((Enum)value).getEditor(), "last");
	    }
	} else if (type == LinkString.class) {
	    if (constant) {
		add(((LinkString)value).getViewer(), "last");
	    } else {
		add(((LinkString)value).getEditor(), "last");
	    }
*/
	} else {
	    if (value == null) {
System.out.println(key + ";" + value + ":" + type);
	    } else {
		add(new JLabel(valueText));
	    }
	}
    }

    // test driver
    public static void main(String[] args) throws Exception {
	jp.gr.java_conf.jaba2.util.Debug.setClass("PropertySheetLayout");
	PropertyList properties = new PropertyList();
	Enum enum = new Enum(new String[] {"one", "two", "three"});
	properties.put("text", "String", String.class, false);
	properties.setLabel("text", "Text");
	properties.put("background", Color.green, Color.class, false);
	properties.setLabel("background", "Background");
	properties.put("font", Font.decode("times"), Font.class, false); // XXX
	properties.setLabel("font", "Font");
	properties.put("list", enum, Enum.class, false);
	properties.setLabel("list", "List");
	LinkString link = new LinkString("text", properties);
	properties.put("link", link, LinkString.class, false);
	properties.setLabel("link", "LinkString");
	TextResource text = new TextResource("Sample");
	properties.put("tr", text, TextResource.class, false);
	properties.setLabel("tr", "TextResource");
	FileHolder file = new FileHolder();
	properties.put("file", file, FileHolder.class, false);
	properties.setLabel("file", "File");
	PropertySheet sheet = new PropertySheet(properties);
	new JTestFrame("PropertySheet test", sheet);
    }
}
