/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import jp.gr.java_conf.jaba2.awt.model.*;

/**
 * RubberBandPane
 *
 * @since   Mar.  4, 1999
 * @version Mar. 26, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class RubberBandPane extends JComponent {
    protected RubberBandModel model_;
    protected Point base_;
    protected Point current_;

    public RubberBandPane(RubberBandModel model) {
	model_ = model;
	base_ = current_ = null;
	MouseHandler handler = new MouseHandler();
	addMouseListener(handler);
	addMouseMotionListener(handler);
    }

    public void paint(Graphics g) {
	if (base_ != null && current_ != null) {
	    model_.paint(g, base_, current_);
	}
    }

    class MouseHandler extends MouseAdapter
        implements MouseMotionListener {

	public void mousePressed(MouseEvent evt) {
	    Point point = evt.getPoint();
	    if (model_.isStartDragging(point)) {
		base_ = point;
		current_ = null;
	    } else {
		base_ = null;
		current_ = null;
	    }
	    repaint();
	}

	public void mouseReleased(MouseEvent evt) {
	    if (base_ != null) {
		model_.stopDragging(base_, evt.getPoint());
		base_ = null;
		current_ = null;
		repaint();
	    }
	}

	public void mouseDragged(MouseEvent evt) {
	    if (base_ != null) {
		current_ = evt.getPoint();
		model_.dragged(evt.getPoint());
		repaint();
	    }
	}

	public void mouseMoved(MouseEvent evt) {
	    if (model_.moved(evt.getPoint())) {
		repaint();
	    }
	}
    }

    // test driver
    public static void main(String[] args) {
	RubberBandPane pane = new RubberBandPane(new LineRubberBandModel());
	new JTestFrame("RubberBandPane test", pane);
    }
}
