package jp.gr.java_conf.jaba2.dombus.configRelaxer;

import org.w3c.dom.*;

/**
 * <b>CConfig</b> is generated by Relaxer based on ConfigFile.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="config">
 *   <sequence>
 *     <element name="name" type="string"/>
 *     <element name="version" type="string"/>
 *     <element name="build" occurs="?" type="string"/>
 *     <element name="author" type="string"/>
 *     <element name="provider" type="string"/>
 *     <element name="year" type="string"/>
 *     <element name="usage" type="string"/>
 *     <element name="help" type="string"/>
 *     <ref label="contextSet" occurs="?"/>
 *     <ref label="componentSet"/>
 *   </sequence>
 * </elementRule>
 * 
 * <tag name="config"/>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="config"&gt;
 *   &lt;sequence&gt;
 *     &lt;element name="name" type="string"/&gt;
 *     &lt;element name="version" type="string"/&gt;
 *     &lt;element name="build" occurs="?" type="string"/&gt;
 *     &lt;element name="author" type="string"/&gt;
 *     &lt;element name="provider" type="string"/&gt;
 *     &lt;element name="year" type="string"/&gt;
 *     &lt;element name="usage" type="string"/&gt;
 *     &lt;element name="help" type="string"/&gt;
 *     &lt;ref label="contextSet" occurs="?"/&gt;
 *     &lt;ref label="componentSet"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="config"/&gt;
 * </pre>
 *
 * @version ConfigFile.rlx (Tue Aug 29 11:45:13 JST 2000)
 * @author  Relaxer 0.10.2b (by ASAMI@Yokohama)
 */
public class CConfig implements java.io.Serializable {
    private String name;
    private String version;
    private String build;
    private String author;
    private String provider;
    private String year;
    private String usage;
    private String help;
    private CContextSet contextSet;
    private CComponentSet componentSet;

    /**
     * Creates a <code>CConfig</code>.
     *
     */
    public CConfig() {
    }

    /**
     * Creates a <code>CConfig</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CConfig(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CConfig</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CConfig(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CConfig</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CConfig(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>CConfig</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CConfig</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CConfig</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IConfigFileFactory factory = ConfigFileFactory.getFactory();
        RStack stack = new RStack(element);
        name = URelaxer.getElementPropertyAsString(stack.popElement());
        version = URelaxer.getElementPropertyAsString(stack.popElement());
        build = URelaxer.getElementPropertyAsStringByStack(stack, "build");
        author = URelaxer.getElementPropertyAsString(stack.popElement());
        provider = URelaxer.getElementPropertyAsString(stack.popElement());
        year = URelaxer.getElementPropertyAsString(stack.popElement());
        usage = URelaxer.getElementPropertyAsString(stack.popElement());
        help = URelaxer.getElementPropertyAsString(stack.popElement());
        if (CContextSet.isMatch(stack)) {
            setContextSet(factory.createCContextSet(stack));
        }
        setComponentSet(factory.createCComponentSet(stack));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("config");
        int size;
        URelaxer.setElementPropertyByString(element, "name", name);
        URelaxer.setElementPropertyByString(element, "version", version);
        if (build != null) {
            URelaxer.setElementPropertyByString(element, "build", build);
        }
        URelaxer.setElementPropertyByString(element, "author", author);
        URelaxer.setElementPropertyByString(element, "provider", provider);
        URelaxer.setElementPropertyByString(element, "year", year);
        URelaxer.setElementPropertyByString(element, "usage", usage);
        URelaxer.setElementPropertyByString(element, "help", help);
        if (contextSet != null) {
            contextSet.makeElement(element);
        }
        componentSet.makeElement(element);
        parent.appendChild(element);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name = name;
    }

    /**
     * Gets the String property <b>version</b>.
     *
     * @return String
     */
    public final String getVersion() {
        return (version);
    }

    /**
     * Sets the String property <b>version</b>.
     *
     * @param version
     */
    public final void setVersion(String version) {
        this.version = version;
    }

    /**
     * Gets the String property <b>build</b>.
     *
     * @return String
     */
    public final String getBuild() {
        return (build);
    }

    /**
     * Sets the String property <b>build</b>.
     *
     * @param build
     */
    public final void setBuild(String build) {
        this.build = build;
    }

    /**
     * Gets the String property <b>author</b>.
     *
     * @return String
     */
    public final String getAuthor() {
        return (author);
    }

    /**
     * Sets the String property <b>author</b>.
     *
     * @param author
     */
    public final void setAuthor(String author) {
        this.author = author;
    }

    /**
     * Gets the String property <b>provider</b>.
     *
     * @return String
     */
    public final String getProvider() {
        return (provider);
    }

    /**
     * Sets the String property <b>provider</b>.
     *
     * @param provider
     */
    public final void setProvider(String provider) {
        this.provider = provider;
    }

    /**
     * Gets the String property <b>year</b>.
     *
     * @return String
     */
    public final String getYear() {
        return (year);
    }

    /**
     * Sets the String property <b>year</b>.
     *
     * @param year
     */
    public final void setYear(String year) {
        this.year = year;
    }

    /**
     * Gets the String property <b>usage</b>.
     *
     * @return String
     */
    public final String getUsage() {
        return (usage);
    }

    /**
     * Sets the String property <b>usage</b>.
     *
     * @param usage
     */
    public final void setUsage(String usage) {
        this.usage = usage;
    }

    /**
     * Gets the String property <b>help</b>.
     *
     * @return String
     */
    public final String getHelp() {
        return (help);
    }

    /**
     * Sets the String property <b>help</b>.
     *
     * @param help
     */
    public final void setHelp(String help) {
        this.help = help;
    }

    /**
     * Gets the CContextSet property <b>contextSet</b>.
     *
     * @return CContextSet
     */
    public final CContextSet getContextSet() {
        return (contextSet);
    }

    /**
     * Sets the CContextSet property <b>contextSet</b>.
     *
     * @param contextSet
     */
    public final void setContextSet(CContextSet contextSet) {
        this.contextSet = contextSet;
    }

    /**
     * Gets the CComponentSet property <b>componentSet</b>.
     *
     * @return CComponentSet
     */
    public final CComponentSet getComponentSet() {
        return (componentSet);
    }

    /**
     * Sets the CComponentSet property <b>componentSet</b>.
     *
     * @param componentSet
     */
    public final void setComponentSet(CComponentSet componentSet) {
        this.componentSet = componentSet;
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CConfig</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        String tagName = element.getTagName();
        if (!"config".equals(tagName)) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!"name".equals(child.getTagName())) {
            return (false);
        }
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!"version".equals(child.getTagName())) {
            return (false);
        }
        child = target.peekElement();
        if (child != null) {
            if ("build".equals(child.getTagName())) {
                target.popElement();
            }
        }
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!"author".equals(child.getTagName())) {
            return (false);
        }
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!"provider".equals(child.getTagName())) {
            return (false);
        }
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!"year".equals(child.getTagName())) {
            return (false);
        }
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!"usage".equals(child.getTagName())) {
            return (false);
        }
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!"help".equals(child.getTagName())) {
            return (false);
        }
        if (CContextSet.isMatchHungry(target)) {
        }
        if (!CComponentSet.isMatchHungry(target)) {
            return (false);
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CConfig</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CConfig</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
