/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.io;

import java.io.*;
import java.net.*;

/**
 * JDBCStreamHandler
 *
 * @since   Sep. 17, 1999
 * @version Sep. 17, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class JDBCStreamHandler extends URLStreamHandler {
    protected URLConnection openConnection(URL u) throws IOException {
	throw (new IOException("UnsupportedOperation"));
    }

    protected void parseURL(URL u, String spec, int start, int limit) {
	String protocol;
	String file;
	String ref;
	int afterProtocol = spec.indexOf(":");
	protocol = spec.substring(0, afterProtocol);
	int afterFile = spec.indexOf("#");
	if (afterFile == -1) {
	    file =  spec.substring(afterProtocol + 1);
	    ref = null;
	} else {
	    file = spec.substring(afterProtocol + 1, afterFile);
	    ref = spec.substring(afterFile + 1);
	}
	setURL(u, protocol, null, -1, file, ref);
    }

    protected String toExternalForm(URL u) {
	StringBuffer buffer = new StringBuffer();
	buffer.append(u.getProtocol());
	buffer.append(":");
	buffer.append(u.getFile());
	String ref = u.getRef();
	if (ref != null) {
	    buffer.append("#");
	    buffer.append(ref);
	}
	return (new String(buffer));
    }
}
