/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.jmodel.lang;

import java.util.*;
import jp.gr.java_conf.jaba2.util.ArrayMap;

/**
 * LJPackage
 *
 * @since   Jan. 17, 2000
 * @version Mar.  3, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class LJPackage {
    private String name_;
    private Map interfaces_ = new ArrayMap();
    private Map classes_ = new ArrayMap();

    public LJPackage() {
	name_ = "";
    }

    public LJPackage(String name) {
	name_ = name;
    }

    public void addInterface(LJInterface ljinterface) {
	ljinterface.setupPackage(this);
	interfaces_.put(ljinterface.getName(), ljinterface);
    }

    public void addClass(LJClass ljclass) {
	ljclass.setupPackage(this);
	classes_.put(ljclass.getName(), ljclass);
    }

    public String getName() {
	return (name_);
    }

    public LJInterface getInterface(String name) {
	return ((LJInterface)interfaces_.get(name));
    }

    public LJClass getClass(String name) {
	return ((LJClass)classes_.get(name));
    }
}
