/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.parcel;

import java.io.OutputStream;
import java.io.IOException;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;
import jp.gr.java_conf.jaba2.util.D2Array;

/**
 * TableGadget
 *
 * @since   Aug. 24, 2000
 * @version Aug. 31, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class TableGadget extends AbstractGadget {
    private D2Array table_;

    public TableGadget(D2Array array) {
	table_ = array;
    }

    public final void setBinary(byte[] binary) {
	throw (new InternalError()); // XXX : HTML table
    }

    public final byte[] getBinary() {
	throw (new InternalError());
    }

    public void write(OutputStream out) throws IOException {
	throw (new InternalError());
    }

    public byte[] getBytes() throws IOException {
	throw (new InternalError());
    }

    public boolean isText() {
	return (true);
    }

    public String getText() throws IOException {
	throw (new UnsupportedOperationException());
    }

    public boolean isDocument() {
	return (true);
    }

    public Document getDocument() throws IOException, SAXException {
	throw (new UnsupportedOperationException());
    }

    public void setD2Array(D2Array array) {
	table_ = array;
    }

    public D2Array getD2Array() {
	return (table_);
    }
}
