/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.tmodel;

import java.util.*;
import java.sql.*;

/**
 * TTypeFLOAT
 *
 * @since   Feb. 18, 2000
 * @version Aug. 31, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class TTypeFLOAT implements ITType {
    private int totalDigits_ = -1;
    private int fractionDigits_ = -1;

    public TTypeFLOAT() {
    }

    public TTypeFLOAT(int total) {
	totalDigits_ = total;
    }

    public TTypeFLOAT(int total, int fraction) {
	totalDigits_ = total;
	fractionDigits_ = fraction;
    }

    public String getName() {
	return ("FLOAT");
    }

    public String getDDLName() {
	if (totalDigits_ == -1 && fractionDigits_ == -1) {
	    return ("FLOAT");
	} else {
	    if (fractionDigits_ == -1) {
		return ("FLOAT(" + totalDigits_ + ")");
	    } else {
		return ("FLOAT(" + totalDigits_ + "," +
			fractionDigits_ + ")");
	    }
	}
    }

    public int getSQLType() {
	return (Types.FLOAT);
    }

    public Class getJavaType() {
	return (Float.class);
    }

    public Object string2Object(String string) {
	return (Float.valueOf(string));	// XXX : double
    }

    public String object2String(Object object) {
	return (object.toString());
    }
}
