/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs;

import java.util.*;

/**
 * AbstractVFSRoot
 *
 * @since   Jan. 15, 2000
 * @version Jan. 26, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public abstract class AbstractVFSRoot implements IVFSRoot {
    private IVFSRealm realm_;
    private List containers_ = new ArrayList();
    private List objects_ = new ArrayList();

    protected void _shallowSetup(IFilter filter) {
	// do nothing
    }

    protected void _deepSetup(IFilter filter) {
	int size = containers_.size();
	for (int i = 0;i < size;i++) {
	    IVFSContainer container
		= (IVFSContainer)containers_.get(i);
	    container.setup(filter);
	}
	size = objects_.size();
	for (int i = 0;i < size;i++) {
	    IVFSObject object
		= (IVFSObject)objects_.get(i);
	    object.setup(filter);
	}
    }

    public void setRealm(IVFSRealm realm) {
	realm_ = realm;
    }

    public final void addContainer(IVFSContainer container) {
	containers_.add(container);
	container.setRealm(realm_);
    }

    public final void addObject(IVFSObject object) {
	objects_.add(object);
	object.setRealm(realm_);
    }

    public final IVFSContainer[] getContainerChildren() {
	IVFSContainer[] children
	    = new IVFSContainer[containers_.size()];
	return ((IVFSContainer[])containers_.toArray(children));
    }

    public final IVFSObject[] getObjectChildren() {
	IVFSObject[] children
	    = new IVFSObject[objects_.size()];
	return ((IVFSObject[])objects_.toArray(children));
    }

    public final IVFSNode getNode(String name) {
	int size = containers_.size();
	for (int i = 0;i < size;i++) {
	    IVFSContainer container = (IVFSContainer)containers_.get(i);
	    if (name.equals(container.getName())) {
		return (container);
	    }
	}
	size = objects_.size();
	for (int i = 0;i < size;i++) {
	    IVFSObject object = (IVFSObject)objects_.get(i);
	    if (name.equals(object.getName())) {
		return (object);
	    }
	}
	return (null);
    }
}
