/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs.file;

import java.io.*;
import jp.gr.java_conf.jaba2.io.UFile;
import jp.gr.java_conf.jaba2.vfs.*;

/**
 * FileRealm
 *
 * @since   Dec. 18, 1998
 * @version May.  4, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class FileRealm extends AbstractVFSRealm {
    private File root_;
    private File timestamp_;
    private String timestampName_ = ".VFSTimestamp";

    public FileRealm(File root) {
	root_ = root;
	File timestamp = new File(root_, timestampName_);
	if (timestamp.exists()) {
	    timestamp_ = timestamp;
	} else {
	    timestamp_ = null;
	}
    }

    public void shallowSetup(IFilter filter) throws IOException {
	_shallowSetup(new FileRoot(root_), filter);
    }

    public void deepSetup(IFilter filter) throws IOException {
	_deepSetup(new FileRoot(root_), filter);
    }

    public long getLastTimestamp() throws IOException {
	if (timestamp_ != null) {
	    return (timestamp_.lastModified());
	} else {
	    return (super.getLastTimestamp());
	}
    }

    public void updateTimestamp() throws IOException {
	if (timestamp_ == null) {
	    timestamp_ = new File(root_, timestampName_);
	    UFile.createParentDirectory(timestamp_);
	    timestamp_.createNewFile();
	} else {
	    timestamp_.setLastModified(System.currentTimeMillis());
	}
    }

    public void createObject(String pathname, InputStream in)
	throws IOException {

	File file = new File(root_, pathname);
	UFile.createFile(file, in);
    }

    public void createContainer(String pathname, InputStream in)
	throws IOException {

	File dir = new File(root_, pathname);
	dir.mkdirs();
    }
}
