/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml;

import java.io.*;
import jp.gr.java_conf.jaba2.util.*;
import jp.gr.java_conf.jaba2.xml.processor.XercesProcessor;

/**
 * ProcessorFactory
 *
 * @since   Jul. 28, 1999
 * @version Nov. 29, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class ProcessorFactory extends ExtensibleFactory {
    protected static ProcessorFactory factory__;
    private static IProcessor processor__ = null;

    public static void setProcessor(IProcessor processor) {
	processor__ = processor;
    }

    public static IProcessor getProcessor() {
	if (processor__ != null) {
	    return (processor__);
	} else {
	    return (new XercesProcessor());
	}
    }

    public static IProcessor getProcessor(String name) {
	if (factory__ == null) {
	    factory__ = new ProcessorFactory();
	}
	return (factory__._getProcessor(name));
    }

    public static ProcessorFactory getFactory() {
	return (factory__);
    }

    protected ProcessorFactory() {
	try {
	    _setup(getClass().getResource(
		"/jp/gr/java_conf/jaba2/xml/Processor.xml"
	    ));
	} catch (IOException e) {
	    throw (new InternalError());
	}
    }

    protected IProcessor _getProcessor() {
	return (new XercesProcessor());
    }

    protected IProcessor _getProcessor(String name) {
	return ((IProcessor)getTargetObject(name));
    }
}
