/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package jp.gr.java_conf.jaba2.xml;

import org.w3c.dom.*;

/**
 * UTransform
 *
 * @since   Jul. 17, 2000
 * @version Jul. 21, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public final class UTransform {
    public static Element mark2Tree(
	Element source,
	Element target,
	String[] marks
    ) {
	Mark2TreeVisitor visitor = new Mark2TreeVisitor(target, marks);
	UXML.traverseDepthFirst(source, visitor);
	return (target);
    }

    public static Document mark2Tree(
	Document source,
	Document target,
	String[] marks
    ) {
	Element root = source.getDocumentElement();
	Element result = mark2Tree(
	    root,
	    target.createElement(root.getTagName()),
	    marks
	);
	target.appendChild(result);
	return (target);
    }

    public static Document mark2Tree(
	Document source,
	String[] marks
    ) {
	IProcessor processor = ProcessorFactory.getProcessor();
	Document target = processor.newDocument();
	return (mark2Tree(source, target, marks));
    }
}
