/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.datatype;

import java.util.*;
import org.w3c.dom.*;

/**
 * DatatypeFactory
 *
 * @since   Feb. 24, 2000
 * @version Aug. 30, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DatatypeFactory {
    public static Datatype getDatatype(String name) {
	if ("string".equals(name)) {
	    return (new DString());
	} else if ("normalizedString".equals(name)) {
	    return (new DNormalizedString());
	} else if ("token".equals(name)) {
	    return (new DToken());
	} else if ("boolean".equals(name)) {
	    return (new DBoolean());
	} else if ("byte".equals(name)) {
	    return (new DByte());
	} else if ("short".equals(name)) {
	    return (new DShort());
	} else if ("int".equals(name)) {
	    return (new DInt());
	} else if ("long".equals(name)) {
	    return (new DLong());
	} else if ("unsignedByte".equals(name)) {
	    return (new DUnsignedByte());
	} else if ("unsignedShort".equals(name)) {
	    return (new DUnsignedShort());
	} else if ("unsignedInt".equals(name)) {
	    return (new DUnsignedInt());
	} else if ("unsignedLong".equals(name)) {
	    return (new DUnsignedLong());
	} else if ("float".equals(name)) {
	    return (new DFloat());
	} else if ("double".equals(name)) {
	    return (new DDouble());
	} else if ("number".equals(name)) {
	    return (new DNumber());
	} else if ("decimal".equals(name)) { // CR
	    return (new DDecimal());
	} else if ("timeInstant".equals(name)) { // CR
	    return (new DTimeInstant());
	} else if ("timeDuration".equals(name)) { // CR
	    return (new DTimeDuration());
	} else if ("recurringDuration".equals(name)) { // CR
	    return (new DRecurringDuration());
	} else if ("recurringDate".equals(name)) { // CR
	    return (new DRecurringDate());
	} else if ("recurringDay".equals(name)) { // CR
	    return (new DRecurringDay());
	} else if ("binary".equals(name)) { // CR
	    return (new DBinary());
	} else if ("uriReference".equals(name)) { // CR
	    return (new DUriReference());
	} else if ("base64Binary".equals(name)) {
	    return (new DBase64Binary());
	} else if ("hexBinary".equals(name)) {
	    return (new DHexBinary());
	} else if ("anyURI".equals(name)) {
	    return (new DAnyURI());
	} else if ("language".equals(name)) {
	    return (new DLanguage());
	} else if ("Name".equals(name)) {
	    return (new DName());
	} else if ("QName".equals(name)) {
	    return (new DQName());
	} else if ("NCName".equals(name)) {
	    return (new DNCName());
	} else if ("integer".equals(name)) {
	    return (new DInteger());
	} else if ("nonNegativeInteger".equals(name)) {
	    return (new DNonNegativeInteger());
	} else if ("positiveInteger".equals(name)) {
	    return (new DPositiveInteger());
	} else if ("nonPositiveInteger".equals(name)) {
	    return (new DNonPositiveInteger());
	} else if ("negativeInteger".equals(name)) {
	    return (new DNegativeInteger());
	} else if ("date".equals(name)) {
	    return (new DDate());
	} else if ("time".equals(name)) {
	    return (new DTime());
	} else if ("dateTime".equals(name)) {
	    return (new DDateTime());
	} else if ("gYearMonth".equals(name)) {
	    return (new DGYearMonth());
	} else if ("gYear".equals(name)) {
	    return (new DGYear());
	} else if ("gMonthDay".equals(name)) {
	    return (new DGMonthDay());
	} else if ("gDay".equals(name)) {
	    return (new DGDay());
	} else if ("gMonth".equals(name)) {
	    return (new DGMonth());
	} else if ("duration".equals(name)) {
	    return (new DDuration());
	} else if ("timePeriod".equals(name)) {	// CR
	    return (new DTimePeriod());
	} else if ("month".equals(name)) { // CR
	    return (new DMonth());
	} else if ("year".equals(name)) { // CR
	    return (new DYear());
	} else if ("century".equals(name)) { // CR
	    return (new DCentury());
	} else if ("recurringDate".equals(name)) { // CR
	    return (new DRecurringDate());
	} else if ("recurringDay".equals(name)) { // CR
	    return (new DRecurringDay());
	} else if ("CDATA".equals(name)) {
	    return (new DCDATA());
	} else if ("NMTOKEN".equals(name)) {
	    return (new DNMTOKEN());
	} else if ("NMTOKENS".equals(name)) {
	    return (new DNMTOKENS());
	} else if ("ID".equals(name)) {
	    return (new DID());
	} else if ("IDREF".equals(name)) {
	    return (new DIDREF());
	} else if ("IDREFS".equals(name)) {
	    return (new DIDREFS());
	} else if ("ENTITY".equals(name)) {
	    return (new DENTITY());
	} else if ("ENTITIES".equals(name)) {
	    return (new DENTITIES());
	} else if ("NOTATION".equals(name)) {
	    return (new DNOTATION());
	} else if ("none".equals(name)) {
	    return (new DNone());
	} else if ("emptyString".equals(name)) {
	    return (new DEmptyString());
	}
	return (null);
    }

    public static Datatype getDatatype(String name, Element element) {
	Datatype datatype = getDatatype(name);
	if (datatype != null) {
	    datatype.addFacets(element);
	}
	return (datatype);
    }
}
