/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.tablelayout;

import java.util.StringTokenizer;
import uk.co.westhawk.tablelayout.TableOpts;

public class TableLocRec
implements Cloneable {
    private static final String version_id = "@(#)$Id: TableLocRec.java,v 3.1 2001/03/22 13:15:34 birgit Exp $ Copyright West Consulting bv";
    public int col;
    public int row;
    public int col_span;
    public int row_span;
    public int orig_width;
    public int orig_height;
    public int same_width;
    public int same_height;
    public TableOpts options;
    static final String CHAR_BLANC = " ";

    public TableLocRec() {
        this.col = 0;
        this.row = 0;
        this.col_span = 1;
        this.row_span = 1;
        this.orig_width = 0;
        this.orig_height = 0;
        this.same_width = 0;
        this.same_height = 0;
        this.options = new TableOpts();
    }

    public TableLocRec(String layout) {
        this.orig_width = 0;
        this.orig_height = 0;
        this.same_width = 0;
        this.same_height = 0;
        StringTokenizer st = new StringTokenizer(layout, CHAR_BLANC, false);
        String next = st.nextToken();
        this.col = Integer.valueOf(next);
        next = st.nextToken();
        this.row = Integer.valueOf(next);
        try {
            next = st.nextToken();
        }
        catch (Exception e) {
            this.col_span = 1;
            this.row_span = 1;
            this.options = new TableOpts();
            return;
        }
        try {
            this.col_span = Integer.valueOf(next);
            if (this.col_span < 1) {
                this.col_span = 1;
            }
        }
        catch (NumberFormatException e) {
            this.col_span = 1;
            this.row_span = 1;
            this.options = new TableOpts(next);
            return;
        }
        try {
            next = st.nextToken();
        }
        catch (Exception e) {
            this.row_span = 1;
            this.options = new TableOpts();
            return;
        }
        try {
            this.row_span = Integer.valueOf(next);
            if (this.row_span < 1) {
                this.row_span = 1;
            }
        }
        catch (NumberFormatException e) {
            this.row_span = 1;
            this.options = new TableOpts(next);
            return;
        }
        try {
            next = st.nextToken();
            this.options = new TableOpts(next);
        }
        catch (Exception e) {
            this.options = new TableOpts();
        }
    }

    public Object clone() {
        TableLocRec elem = new TableLocRec();
        elem.options = this.options;
        elem.col = this.col;
        elem.row = this.row;
        elem.col_span = this.col_span;
        elem.row_span = this.row_span;
        elem.orig_width = this.orig_width;
        elem.orig_height = this.orig_height;
        elem.same_width = this.same_width;
        elem.same_height = this.same_height;
        return elem;
    }

    public String toString() {
        return "TableLocRec [\n\tcol " + this.col + " row " + this.row + " col_span " + this.col_span + " row_span " + this.row_span + "\n\torig_width " + this.orig_width + " orig_height " + this.orig_height + " same_width " + this.same_width + " same_height " + this.same_height + "\n\toptions " + this.options.toString() + "]";
    }

    public static int compareColSpan(TableLocRec loc1, TableLocRec loc2) {
        if (loc1.col_span == loc2.col_span) {
            return loc1.col - loc2.col;
        }
        return loc1.col_span - loc2.col_span;
    }

    public static int compareRowSpan(TableLocRec loc1, TableLocRec loc2) {
        if (loc1.row_span == loc2.row_span) {
            return loc1.row - loc2.row;
        }
        return loc1.row_span - loc2.row_span;
    }

    public int preferredWidth() {
        if (this.same_width != 0) {
            return this.same_width;
        }
        return this.orig_width;
    }

    public int preferredHeight() {
        if (this.same_height != 0) {
            return this.same_height;
        }
        return this.orig_height;
    }
}

