/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.util.Enumeration;
import uk.co.westhawk.snmp.event.RawPduEvent;
import uk.co.westhawk.snmp.event.RawPduListener;
import uk.co.westhawk.snmp.event.RequestPduListener;
import uk.co.westhawk.snmp.event.RequestPduReceivedSupport;
import uk.co.westhawk.snmp.event.TrapListener;
import uk.co.westhawk.snmp.event.TrapReceivedSupport;
import uk.co.westhawk.snmp.net.ContextSocketFace;
import uk.co.westhawk.snmp.net.StreamPortItem;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.EncodingException;
import uk.co.westhawk.snmp.stack.ListeningContextPool;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.Transmitter;
import uk.co.westhawk.snmp.util.SnmpUtilities;

public abstract class AbstractSnmpContext
implements SnmpContextBasisFace,
Runnable,
RawPduListener {
    private static final String version_id = "@(#)$Id: AbstractSnmpContext.java,v 3.30 2006/06/19 10:45:09 birgit Exp $ Copyright Westhawk Ltd";
    private ContextSocketFace soc;
    private Transmitter[] transmitters;
    private Pdu[] pdus = new Pdu[20];
    private Thread me;
    private String basename;
    private boolean stopRequested;
    protected String typeSocket;
    protected String hostname;
    protected String bindAddr;
    protected int hostPort;
    protected int maxRecvSize;
    protected boolean isDestroyed;
    protected boolean anyPduExpectingResponse = false;
    protected RequestPduReceivedSupport pduSupport;
    protected TrapReceivedSupport trapSupport;

    protected abstract void processIncomingResponse(ByteArrayInputStream var1) throws DecodingException, IOException;

    public abstract byte[] encodePacket(byte var1, int var2, int var3, int var4, Enumeration var5, Object var6) throws IOException, EncodingException;

    public abstract Pdu processIncomingPdu(byte[] var1) throws DecodingException, IOException;

    public abstract int getVersion();

    protected AbstractSnmpContext(String host, int port) throws IOException {
        this(host, port, null, "Standard");
    }

    protected AbstractSnmpContext(String host, int port, String typeSocketA) throws IOException {
        this(host, port, null, typeSocketA);
    }

    protected AbstractSnmpContext(String host, int port, String bindAddress, String typeSocketA) throws IOException {
        this.hostname = host;
        this.hostPort = port;
        this.bindAddr = bindAddress;
        this.typeSocket = typeSocketA;
        this.transmitters = new Transmitter[20];
        this.basename = host + "_" + port + "_" + bindAddress;
        this.trapSupport = new TrapReceivedSupport(this);
        this.pduSupport = new RequestPduReceivedSupport(this);
        this.isDestroyed = false;
        this.stopRequested = false;
        this.maxRecvSize = 1300;
        this.soc = AbstractSnmpContext.getSocket(typeSocketA);
        this.soc.create(host, port, this.bindAddr);
        if (AsnObject.debug > 12) {
            System.out.println(this.getClass().getName() + ": soc.getLocalSocketAddress() = " + this.soc.getLocalSocketAddress());
            System.out.println(this.getClass().getName() + ": soc.getRemoteSocketAddress() = " + this.soc.getRemoteSocketAddress());
        }
    }

    static ContextSocketFace getSocket(String type) throws IOException {
        ContextSocketFace sf = null;
        String className = "uk.co.westhawk.snmp.net.StandardSocket";
        if (type.equals("TCP")) {
            className = "uk.co.westhawk.snmp.net.TCPSocket";
        } else if (type.equals("Netscape")) {
            className = "uk.co.westhawk.snmp.net.NetscapeSocket";
        } else if (type.equals("KVM")) {
            className = "uk.co.westhawk.snmp.net.KvmSocket";
        }
        try {
            Class<?> cl = Class.forName(className);
            Object obj = cl.newInstance();
            sf = (ContextSocketFace)obj;
        }
        catch (ClassNotFoundException exc) {
            String str = "ClassNotFound problem " + exc.getMessage();
            throw new IOException(str);
        }
        catch (InstantiationException exc) {
            String str = "Instantiation problem " + exc.getMessage();
            throw new IOException(str);
        }
        catch (IllegalAccessException exc) {
            String str = "IllegalAccess problem " + exc.getMessage();
            throw new IOException(str);
        }
        catch (ClassCastException exc) {
            String str = "ClassCast problem " + exc.getMessage();
            throw new IOException(str);
        }
        if (sf == null) {
            String str = "Cannot create socket ";
            throw new IOException(str);
        }
        if (AsnObject.debug > 12) {
            System.out.println("AbstractSnmpContext.getSocket(): New socket " + sf.getClass().getName());
        }
        return sf;
    }

    public String getHost() {
        return this.hostname;
    }

    public String getHostAddress() {
        return this.getSendToHostAddress();
    }

    public String getSendToHostAddress() {
        String res = this.soc.getSendToHostAddress();
        return res;
    }

    public String getReceivedFromHostAddress() {
        String res = this.soc.getReceivedFromHostAddress();
        return res;
    }

    public int getPort() {
        return this.hostPort;
    }

    public String getBindAddress() {
        return this.bindAddr;
    }

    public String getTypeSocket() {
        return this.typeSocket;
    }

    public int getMaxRecvSize() {
        return this.maxRecvSize;
    }

    public void setMaxRecvSize(int no) {
        this.maxRecvSize = no;
    }

    public String getDebugString() {
        char[] cret = new char[21];
        int i = 0;
        while (i < 20) {
            cret[i] = this.transmitters[i] != null ? (this.pdus[i] != null ? (int)(65 + this.pdus[i].getReqId() % 26) : 61) : 45;
            ++i;
        }
        int res = 48;
        if (this.me != null) {
            res = (char)(res + 1);
            if (this.me.isAlive()) {
                res = (char)(res + 1);
            }
        }
        cret[20] = res;
        return new String(cret);
    }

    public synchronized void destroy() {
        if (!this.isDestroyed) {
            this.stopRequested = true;
            if (AsnObject.debug > 12) {
                System.out.println(this.getClass().getName() + ".destroy(): Closing socket ");
            }
            this.soc.close();
            this.isDestroyed = true;
            if (this.me == null) {
                this.freeTransmitters();
            }
        }
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public synchronized void stop() {
        this.stopRequested = true;
    }

    public void run() {
        while (!this.stopRequested) {
            AbstractSnmpContext abstractSnmpContext = this;
            abstractSnmpContext.me.yield();
            try {
                if (this.stopRequested) break;
                StreamPortItem item = this.soc.receive(this.maxRecvSize);
                ByteArrayInputStream in = item.getStream();
                if (AsnObject.debug > 10) {
                    int nb = in.available();
                    byte[] bu = new byte[nb];
                    in.read(bu);
                    in.reset();
                    SnmpUtilities.dumpBytes(this.getClass().getName() + ".run(): Received from " + item.getHostAddress() + ", from port " + item.getHostPort() + ": ", bu);
                }
                this.processIncomingResponse(in);
            }
            catch (IOException exc) {
                if (exc instanceof InterruptedIOException) {
                    if (AsnObject.debug <= 15) continue;
                    System.out.println(this.getClass().getName() + ".run(): Idle recv " + exc.getMessage());
                    continue;
                }
                if (exc instanceof SocketException) {
                    if (AsnObject.debug <= 15) continue;
                    System.out.println(this.getClass().getName() + ".run(): SocketException " + exc.getMessage());
                    continue;
                }
                if (AsnObject.debug <= 0) continue;
                System.out.println(this.getClass().getName() + ".run(): " + exc.getClass().getName() + " " + exc.getMessage());
                exc.printStackTrace();
            }
            catch (DecodingException exc) {
                if (AsnObject.debug <= 1) continue;
                System.out.println(this.getClass().getName() + ".run(): DecodingException: " + exc.getMessage());
            }
            catch (Exception exc) {
                if (AsnObject.debug <= 1) continue;
                System.out.println(this.getClass().getName() + ".run(): Exception: " + exc.getMessage());
                exc.printStackTrace();
            }
            catch (Error err) {
                if (AsnObject.debug <= 1) continue;
                System.out.println(this.getClass().getName() + ".run(): Error: " + err.getMessage());
                err.printStackTrace();
            }
        }
        this.freeTransmitters();
        this.trapSupport.empty();
        this.pduSupport.empty();
        ListeningContextPool lcontext = new ListeningContextPool(162, this.bindAddr, this.typeSocket);
        lcontext.removeRawPduListenerFromPool(this);
        this.me = null;
        this.soc = null;
    }

    public synchronized void sendPacket(byte[] p) {
        block3: {
            if (this.isDestroyed) break block3;
            this.activate();
            try {
                if (AsnObject.debug > 10) {
                    SnmpUtilities.dumpBytes("Sending to " + this.soc.getSendToHostAddress() + ": ", p);
                }
                this.soc.send(p);
            }
            catch (IOException exc) {
                if (AsnObject.debug <= 0) break block3;
                System.out.println(this.getClass().getName() + ".sendPacket(): " + exc.getClass().getName() + " " + exc.getMessage());
            }
        }
    }

    Pdu getPdu(Integer ReqId) {
        return this.getPdu((int)ReqId);
    }

    Pdu getPdu(int rid) {
        Pdu ret = null;
        int i = 0;
        while (i < 20) {
            if (this.pdus[i] != null && this.pdus[i].getReqId() == rid) {
                ret = this.pdus[i];
                break;
            }
            ++i;
        }
        return ret;
    }

    public synchronized boolean removePdu(int rid) {
        boolean ret = false;
        int i = 0;
        while (i < 20) {
            if (this.pdus[i] != null && this.pdus[i].getReqId() == rid) {
                this.pdus[i] = null;
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    public synchronized boolean addPdu(Pdu p) throws IOException, PduException {
        boolean done = false;
        if (this.isDestroyed) {
            throw new EncodingException("Context can no longer be used, since it is already destroyed");
        }
        if (!this.anyPduExpectingResponse) {
            this.anyPduExpectingResponse = p.isExpectingResponse();
        }
        int i = 0;
        while (i < 20) {
            if (this.pdus[i] == null) {
                this.pdus[i] = p;
                this.pdus[i].setTrans(this.getTrans(i));
                done = true;
                break;
            }
            ++i;
        }
        return done;
    }

    public void addTrapListener(TrapListener l) throws IOException {
        this.addTrapListener(l, 162);
    }

    public void removeTrapListener(TrapListener l) throws IOException {
        this.removeTrapListener(l, 162);
    }

    public void addTrapListener(TrapListener l, int port) throws IOException {
        ListeningContextPool lcontext = new ListeningContextPool(port, this.bindAddr, this.typeSocket);
        this.addTrapListener(l, lcontext);
    }

    public void removeTrapListener(TrapListener l, int port) throws IOException {
        ListeningContextPool lcontext = new ListeningContextPool(port, this.bindAddr, this.typeSocket);
        this.removeTrapListener(l, lcontext);
    }

    public void addTrapListener(TrapListener l, ListeningContextPool lcontext) throws IOException {
        this.trapSupport.addTrapListener(l);
        lcontext.addRawPduListener(this);
    }

    public void removeTrapListener(TrapListener l, ListeningContextPool lcontext) throws IOException {
        this.trapSupport.removeTrapListener(l);
        if (this.trapSupport.getListenerCount() == 0 && this.pduSupport.getListenerCount() == 0) {
            lcontext.removeRawPduListener(this);
        }
    }

    public void addRequestPduListener(RequestPduListener l) throws IOException {
        this.addRequestPduListener(l, 161);
    }

    public void removeRequestPduListener(RequestPduListener l) throws IOException {
        this.removeRequestPduListener(l, 161);
    }

    public void addRequestPduListener(RequestPduListener l, int port) throws IOException {
        ListeningContextPool lcontext = new ListeningContextPool(port, this.bindAddr, this.typeSocket);
        this.addRequestPduListener(l, lcontext);
    }

    public void removeRequestPduListener(RequestPduListener l, int port) throws IOException {
        ListeningContextPool lcontext = new ListeningContextPool(port, this.bindAddr, this.typeSocket);
        this.removeRequestPduListener(l, lcontext);
    }

    public void addRequestPduListener(RequestPduListener l, ListeningContextPool lcontext) throws IOException {
        this.pduSupport.addRequestPduListener(l);
        lcontext.addRawPduListener(this);
    }

    public void removeRequestPduListener(RequestPduListener l, ListeningContextPool lcontext) throws IOException {
        this.pduSupport.removeRequestPduListener(l);
        if (this.trapSupport.getListenerCount() == 0 && this.pduSupport.getListenerCount() == 0) {
            lcontext.removeRawPduListener(this);
        }
    }

    public void rawPduReceived(RawPduEvent evt) {
        block11: {
            String hostAddress = evt.getHostAddress();
            int version = evt.getVersion();
            if (version == this.getVersion()) {
                if (hostAddress != null && hostAddress.equals(this.getSendToHostAddress())) {
                    byte[] message = evt.getMessage();
                    Pdu pdu = null;
                    try {
                        pdu = this.processIncomingPdu(message);
                        if (pdu == null) break block11;
                        evt.consume();
                        int port = evt.getHostPort();
                        if (pdu.getMsgType() == -92 || pdu.getMsgType() == -89) {
                            this.trapSupport.fireTrapReceived(pdu, port);
                            break block11;
                        }
                        this.pduSupport.fireRequestPduReceived(pdu, port);
                    }
                    catch (DecodingException exc) {
                        if (AsnObject.debug > 2) {
                            System.out.println(this.getClass().getName() + ".rawPduReceived(): DecodingException: " + exc.getMessage());
                        }
                        break block11;
                    }
                    catch (IOException exc) {
                        if (AsnObject.debug > 0) {
                            System.out.println(this.getClass().getName() + ".rawPduReceived(): IOException " + exc.getMessage());
                        }
                        break block11;
                    }
                }
                if (AsnObject.debug > 5) {
                    System.out.println(this.getClass().getName() + ".rawPduReceived(): " + "Pdu host (" + hostAddress + "), does not correspond with context host (" + this.getSendToHostAddress() + ")");
                }
            } else if (AsnObject.debug > 5) {
                String theirs = SnmpUtilities.getSnmpVersionString(version);
                String ours = SnmpUtilities.getSnmpVersionString(this.getVersion());
                System.out.println(this.getClass().getName() + ".rawPduReceived(): " + "Pdu version " + theirs + ", does not correspond with context version " + ours);
            }
        }
    }

    Transmitter getTrans(int i) {
        if (this.transmitters[i] == null) {
            this.transmitters[i] = new Transmitter(this.basename + "_v" + this.getVersion() + "_Trans" + i);
        }
        return this.transmitters[i];
    }

    protected void activate() {
        if (this.me == null && this.anyPduExpectingResponse) {
            this.me = new Thread((Runnable)this, this.basename + "_v" + this.getVersion() + "_Receive");
            this.me.setPriority(10);
            this.me.start();
        }
    }

    protected void freeTransmitters() {
        int i = 0;
        while (i < 20) {
            if (this.transmitters[i] != null) {
                this.transmitters[i].destroy();
                this.transmitters[i] = null;
            }
            if (this.pdus[i] != null) {
                this.pdus[i] = null;
            }
            ++i;
        }
    }

    public abstract Object clone() throws CloneNotSupportedException;

    public abstract String getHashKey();
}

