/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnOctetsPrintableFace;
import uk.co.westhawk.snmp.stack.DefaultAsnOctetsPrintable;
import uk.co.westhawk.snmp.util.SnmpUtilities;

public class AsnOctets
extends AsnObject {
    private static final String version_id = "@(#)$Id: AsnOctets.java,v 3.39 2006/03/23 14:54:10 birgit Exp $ Copyright Westhawk Ltd";
    public static String HEX_PREFIX = "0x";
    public static SimpleDateFormat CALFORMAT = new SimpleDateFormat("yyyy-M-d,HH:mm:ss.SS,z");
    public static AsnOctetsPrintableFace printableObject = new DefaultAsnOctetsPrintable();
    byte[] value;
    private int hash = 0;

    public AsnOctets(byte[] s) throws IllegalArgumentException {
        this(s, 4);
    }

    public AsnOctets(byte[] s, byte t) throws IllegalArgumentException {
        this.value = s;
        this.type = t;
        if (this.value == null) {
            throw new IllegalArgumentException("Value is null");
        }
    }

    public AsnOctets(char[] s) {
        this.value = new byte[s.length];
        this.type = (byte)4;
        int idx = 0;
        while (idx < s.length) {
            this.value[idx] = (byte)s[idx];
            ++idx;
        }
    }

    public AsnOctets(String s) {
        this(s.toCharArray());
    }

    public AsnOctets(InetAddress iad) throws IllegalArgumentException {
        this(iad.getAddress(), 4);
        if (iad instanceof Inet4Address) {
            this.type = (byte)64;
        }
    }

    public AsnOctets(Inet4Address iad, byte t) throws IllegalArgumentException {
        this(iad.getAddress(), t);
    }

    public AsnOctets(Calendar cal) {
        this.value = new byte[11];
        this.type = (byte)4;
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        int msec = cal.get(14);
        int msecGMT = cal.get(15);
        this.value[0] = (byte)(year / 256 % 256);
        this.value[1] = (byte)(year % 256);
        this.value[2] = (byte)(month & 0xFF);
        this.value[3] = (byte)(day & 0xFF);
        this.value[4] = (byte)(hour & 0xFF);
        this.value[5] = (byte)(min & 0xFF);
        this.value[6] = (byte)(sec & 0xFF);
        this.value[7] = (byte)(msec / 100 & 0xFF);
        int dir = 0;
        if (msecGMT < 0) {
            dir = 45;
            msecGMT *= -1;
        } else {
            dir = 43;
        }
        this.value[8] = (byte)dir;
        if (msecGMT == 0) {
            this.value[9] = 0;
            this.value[10] = 0;
        } else {
            int minGMT = (int)((double)msecGMT / 1000.0 / 60.0);
            if (minGMT == 0) {
                this.value[9] = 0;
                this.value[10] = 0;
            } else {
                int hourGMT = (int)((double)minGMT / 60.0);
                this.value[9] = (byte)(hourGMT & 0xFF);
                this.value[10] = (byte)((minGMT -= hourGMT * 60) & 0xFF);
            }
        }
    }

    public AsnOctets(InputStream in, int len) throws IOException {
        this.value = new byte[len];
        if (len != 0) {
            if (len == in.read(this.value, 0, len)) {
                String string = "";
            } else {
                throw new IOException("AsnOctets(): Not enough data");
            }
        }
    }

    public static void setHexPrefix(String newPrefix) {
        HEX_PREFIX = newPrefix;
    }

    public static void setPrintable(AsnOctetsPrintableFace obj) {
        if (obj != null) {
            printableObject = obj;
        }
    }

    public String getValue() {
        return this.toString();
    }

    public byte[] getBytes() {
        int len = this.value.length;
        byte[] bytea = new byte[len];
        System.arraycopy(this.value, 0, bytea, 0, len);
        return bytea;
    }

    public String toString() {
        return this.toString(printableObject);
    }

    public String toString(AsnOctetsPrintableFace face) {
        boolean isPrintable;
        String str = "";
        str = this.type == 64 ? this.toIpAddress() : (this.type == 68 ? HEX_PREFIX + this.toHex() : ((isPrintable = face.isPrintable(this.value)) ? face.toInternationalDisplayString(this.value) : HEX_PREFIX + this.toHex()));
        return str;
    }

    int size() {
        return this.value.length;
    }

    void write(OutputStream out, int pos) throws IOException {
        this.AsnBuildHeader(out, this.type, this.value.length);
        if (AsnObject.debug > 10) {
            System.out.println("\tAsnOctets(): value = " + this.toString() + ", pos = " + pos);
        }
        int idx = 0;
        while (idx < this.value.length) {
            out.write(this.value[idx]);
            ++idx;
        }
    }

    public String toIpAddress() {
        StringBuffer sb = new StringBuffer(39);
        int length = this.value.length;
        if (length > 0) {
            if (length > 4) {
                int i = 0;
                while (i < length / 2) {
                    sb.append(Integer.toHexString(this.value[i << 1] << 8 & 0xFF00 | this.value[(i << 1) + 1] & 0xFF));
                    if (i < length / 2 - 1) {
                        sb.append(":");
                    }
                    ++i;
                }
            } else {
                long val;
                int i = 0;
                while (i < length - 1) {
                    val = this.getPositiveValue(i);
                    sb.append(String.valueOf(val)).append(".");
                    ++i;
                }
                val = this.getPositiveValue(length - 1);
                sb.append(String.valueOf(val));
            }
        }
        return sb.toString();
    }

    public InetAddress getIpAddress() throws RuntimeException {
        InetAddress iad = null;
        try {
            iad = InetAddress.getByAddress(this.value);
        }
        catch (UnknownHostException exc) {
            throw new RuntimeException(exc);
        }
        return iad;
    }

    private long getPositiveValue(int index) {
        long val = this.value[index];
        if (val < 0L) {
            val += 256L;
        }
        return val;
    }

    public String toHex() {
        StringBuffer buffer = new StringBuffer("");
        int length = this.value.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                buffer.append(SnmpUtilities.toHex(this.value[i])).append(":");
                ++i;
            }
            buffer.append(SnmpUtilities.toHex(this.value[length - 1]));
        }
        return buffer.toString();
    }

    public String toDisplayString() {
        String str = "";
        int length = this.value.length;
        if (length > 0) {
            try {
                str = new String(this.value, "US-ASCII");
            }
            catch (UnsupportedEncodingException exc) {
                str = new String(this.value);
            }
            str = str.trim();
        }
        return str;
    }

    public String toInternationalDisplayString() {
        return this.toInternationalDisplayString(printableObject);
    }

    public String toInternationalDisplayString(AsnOctetsPrintableFace face) {
        return face.toInternationalDisplayString(this.value);
    }

    public String toCalendar() throws RuntimeException {
        Calendar cal = this.getCalendar();
        Date date = cal.getTime();
        return CALFORMAT.format(date);
    }

    public Calendar getCalendar() throws RuntimeException {
        Calendar cal = Calendar.getInstance();
        if (this.value.length == 8 || this.value.length == 11) {
            int year = (int)(this.getPositiveValue(0) * 256L + this.getPositiveValue(1));
            int month = this.value[2] - 1;
            byte day = this.value[3];
            byte hour = this.value[4];
            byte min = this.value[5];
            byte sec = this.value[6];
            int msec = this.value[7] * 100;
            cal.set(year, month, day, hour, min, sec);
            cal.set(14, msec);
            if (this.value.length == 11) {
                char dir = (char)this.value[8];
                byte hourUTC = this.value[9];
                byte minUTC = this.value[10];
                int secUTC = hourUTC * 60 * 60;
                int msecGMT = secUTC * 1000;
                if (dir == '-') {
                    msecGMT *= -1;
                }
                cal.set(15, msecGMT);
            }
        } else {
            throw new RuntimeException("AsnOctets is not DateAndTime");
        }
        return cal;
    }

    public long[] toSubOid(boolean length_implied) {
        long[] sub_oid;
        int index = 0;
        int length = this.value.length;
        if (length_implied) {
            sub_oid = new long[length];
        } else {
            sub_oid = new long[length + 1];
            sub_oid[0] = length;
            ++index;
        }
        int i = 0;
        while (i < length) {
            sub_oid[index] = this.getPositiveValue(i);
            ++index;
            ++i;
        }
        return sub_oid;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof AsnOctets) {
            AsnOctets anotherOctet = (AsnOctets)anObject;
            int n = this.value.length;
            if (n == anotherOctet.value.length) {
                byte[] v1 = this.value;
                byte[] v2 = anotherOctet.value;
                int i = 0;
                int j = 0;
                while (n-- != 0) {
                    if (v1[i++] == v2[j++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int off = 0;
            byte[] val = this.value;
            int len = this.value.length;
            int i = 0;
            while (i < len) {
                h = 31 * h + val[off++];
                ++i;
            }
            this.hash = h;
        }
        return h;
    }
}

