/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import uk.co.westhawk.snmp.stack.AsnNull;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.EncodingException;

class AsnSequence
extends AsnObject {
    private static final String version_id = "@(#)$Id: AsnSequence.java,v 3.14 2006/01/17 17:43:54 birgit Exp $ Copyright Westhawk Ltd";
    private Vector children;

    AsnSequence() {
        this(48);
    }

    AsnSequence(byte oddtype) {
        this.type = oddtype;
        this.children = new Vector(1, 1);
    }

    AsnSequence(InputStream in, int len, int pos) throws IOException {
        this();
        if (AsnObject.debug > 10) {
            System.out.println("AsnSequence(): Length = " + len + ", Pos = " + pos);
        }
        AsnObject a = null;
        while ((a = this.AsnReadHeader(in, pos)) != null) {
            pos += a.headerLength + a.contentsLength;
            this.add(a);
        }
    }

    public String toString() {
        return "";
    }

    AsnObject add(AsnObject child) {
        if (child.isCorrect) {
            this.children.addElement(child);
        }
        return child;
    }

    AsnObject replaceChild(AsnObject oldChild, AsnObject newChild) {
        AsnObject ret = oldChild;
        int at = this.children.indexOf(oldChild);
        if (at > 0) {
            this.children.setElementAt(newChild, at);
            ret = newChild;
        }
        return ret;
    }

    int size() throws EncodingException {
        Enumeration childList = this.children.elements();
        int sz = 0;
        while (childList.hasMoreElements()) {
            int cnt = ((AsnObject)childList.nextElement()).size();
            cnt += 1 + this.getLengthBytes(cnt);
            sz += cnt;
        }
        return sz;
    }

    void write(OutputStream out) throws IOException, EncodingException {
        this.write(out, 0);
    }

    void write(OutputStream out, int pos) throws IOException, EncodingException {
        int length = this.size();
        this.startPos = pos;
        this.AsnBuildHeader(out, this.type, length);
        if (AsnObject.debug > 10) {
            System.out.println("\tAsnSequence.write(): begin, startPos = " + this.startPos);
        }
        pos += this.headerLength;
        Enumeration childList = this.children.elements();
        while (childList.hasMoreElements()) {
            AsnObject child = (AsnObject)childList.nextElement();
            child.write(out, pos);
            child.startPos = pos;
            pos += child.headerLength + child.contentsLength;
        }
        if (AsnObject.debug > 10) {
            System.out.println("\tAsnSequence.write(): end");
        }
    }

    AsnObject findPdu() {
        AsnObject res = null;
        Enumeration childList = this.children.elements();
        while (childList.hasMoreElements()) {
            AsnObject child = (AsnObject)childList.nextElement();
            res = child.findPdu();
            if (res != null) break;
        }
        if (!this.isCorrect && res != null) {
            res.isCorrect = false;
        }
        return res;
    }

    AsnObject findTrapPduv1() {
        AsnObject res = null;
        Enumeration childList = this.children.elements();
        while (childList.hasMoreElements()) {
            AsnObject child = (AsnObject)childList.nextElement();
            res = child.findTrapPduv1();
            if (res != null) break;
        }
        if (!this.isCorrect && res != null) {
            res.isCorrect = false;
        }
        return res;
    }

    AsnObject getObj(int offset) {
        AsnObject res = new AsnNull();
        try {
            res = (AsnObject)this.children.elementAt(offset);
        }
        catch (ArrayIndexOutOfBoundsException exc) {}
        return res;
    }

    int getObjCount() {
        return this.children.size();
    }
}

