/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Vector;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContext;

public abstract class SNMPBean {
    private static final String version_id = "@(#)$Id: SNMPBean.java,v 1.12 2006/01/26 12:38:30 birgit Exp $ Copyright Westhawk Ltd";
    protected SnmpContext context = null;
    protected String host = "localhost";
    protected String bindAddr = null;
    protected int port = 161;
    protected String community = "public";
    protected String socketType = "Standard";
    protected String message = "";
    protected Vector propertyChangeListener = new Vector();

    public abstract void action() throws PduException, IOException;

    public SNMPBean() {
    }

    public SNMPBean(String h, int p) {
        this(h, p, null, "Standard");
    }

    public SNMPBean(String h, int p, String b, String t) {
        this();
        this.setHost(h);
        this.setPort(p);
        this.setBindAddress(b);
        this.setSocketType(t);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String h) {
        if (h != null && h.length() > 0 && !this.host.equals(h)) {
            this.host = h;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int p) {
        if (p > 0 && this.port != p) {
            this.port = p;
        }
    }

    public void setPort(String p) {
        try {
            int pNo = Integer.valueOf(p.trim());
            this.setPort(pNo);
        }
        catch (NumberFormatException exp) {}
    }

    public String getCommunityName() {
        return this.community;
    }

    public void setCommunityName(String c) {
        if (c != null & !this.community.equals(c)) {
            this.community = c;
            if (this.context != null) {
                this.context.setCommunity(this.community);
            }
        }
    }

    public String getBindAddress() {
        return this.bindAddr;
    }

    public void setBindAddress(String b) {
        this.bindAddr = b;
    }

    public String getSocketType() {
        return this.socketType;
    }

    public void setSocketType(String t) {
        this.socketType = t;
    }

    protected boolean isHostPortReachable() {
        boolean res = true;
        if (this.host != null && this.host.length() > 0 && this.port > 0) {
            try {
                if (this.context != null) {
                    this.context.destroy();
                    this.context = null;
                }
                this.context = new SnmpContext(this.host, this.port, this.bindAddr, this.socketType);
                this.context.setCommunity(this.community);
                this.setMessage("Connection to host " + this.host + " is made succesfully");
            }
            catch (IOException exc) {
                res = false;
                this.setMessage("IOException: " + exc.getMessage());
            }
            catch (RuntimeException exc) {
                res = false;
                this.setMessage("RuntimeException: " + exc.getMessage());
            }
        } else {
            res = false;
        }
        return res;
    }

    public String getMessage() {
        return this.message;
    }

    protected void setMessage(String st) {
        this.message = st;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListener.addElement(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListener.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChange(String property, Object old_v, Object new_v) {
        Vector listeners;
        SNMPBean sNMPBean = this;
        synchronized (sNMPBean) {
            listeners = (Vector)this.propertyChangeListener.clone();
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, property, old_v, new_v);
        int sz = listeners.size();
        int i = 0;
        while (i < sz) {
            PropertyChangeListener l = (PropertyChangeListener)listeners.elementAt(i);
            l.propertyChange(event);
            ++i;
        }
    }
}

