/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.event;

import java.util.Vector;
import uk.co.westhawk.snmp.event.TrapEvent;
import uk.co.westhawk.snmp.event.TrapListener;
import uk.co.westhawk.snmp.stack.Pdu;

public class TrapReceivedSupport {
    public static final String version_id = "@(#)$Id: TrapReceivedSupport.java,v 1.6 2006/01/17 17:43:53 birgit Exp $ Copyright Westhawk Ltd";
    private Object source;
    private transient Vector trapListeners;

    public TrapReceivedSupport(Object src) {
        this.source = src;
    }

    public synchronized void empty() {
        if (this.trapListeners != null) {
            this.trapListeners.removeAllElements();
        }
    }

    public synchronized int getListenerCount() {
        int c = 0;
        if (this.trapListeners != null) {
            c = this.trapListeners.size();
        }
        return c;
    }

    public synchronized void addTrapListener(TrapListener listener) {
        if (this.trapListeners == null) {
            this.trapListeners = new Vector(5);
        }
        if (!this.trapListeners.contains(listener)) {
            this.trapListeners.addElement(listener);
        }
    }

    public synchronized void removeTrapListener(TrapListener listener) {
        if (this.trapListeners != null) {
            this.trapListeners.removeElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTrapReceived(Pdu pdu, int hostPort) {
        Vector copyOfListeners = null;
        if (this.trapListeners != null) {
            Vector vector = this.trapListeners;
            synchronized (vector) {
                copyOfListeners = (Vector)this.trapListeners.clone();
            }
        }
        if (copyOfListeners != null) {
            int sz = copyOfListeners.size();
            int i = sz - 1;
            while (i >= 0) {
                TrapListener listener = (TrapListener)copyOfListeners.elementAt(i);
                TrapEvent evt = new TrapEvent(this.source, pdu, hostPort);
                listener.trapReceived(evt);
                --i;
            }
        }
    }
}

