/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import uk.co.westhawk.snmp.event.RawPduListener;
import uk.co.westhawk.snmp.event.RawPduReceivedSupport;
import uk.co.westhawk.snmp.net.ContextSocketFace;
import uk.co.westhawk.snmp.net.StreamPortItem;
import uk.co.westhawk.snmp.stack.AbstractSnmpContext;
import uk.co.westhawk.snmp.stack.AsnDecoderBase;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.ListeningContextFace;
import uk.co.westhawk.snmp.util.SnmpUtilities;

public class ListeningContext
implements ListeningContextFace,
Runnable {
    private static final String version_id = "@(#)$Id: ListeningContext.java,v 3.6 2006/02/09 14:30:19 birgit Exp $ Copyright Westhawk Ltd";
    private static final String SOC_LOCK = "";
    private static int counter;
    private ContextSocketFace soc;
    private Thread me;
    private String basename;
    private boolean stopRequested;
    protected int maxRecvSize;
    protected String typeSocket;
    protected int hostPort;
    protected String bindAddr;
    private transient RawPduReceivedSupport pduSupport;
    private transient RawPduReceivedSupport unhandledSupport;

    public ListeningContext(int port) {
        this(port, null, "Standard");
    }

    public ListeningContext(int port, String bindAddress) {
        this(port, bindAddress, "Standard");
    }

    public ListeningContext(int port, String bindAddress, String typeSocketA) {
        this.hostPort = port;
        this.bindAddr = bindAddress;
        this.typeSocket = typeSocketA;
        this.basename = SOC_LOCK + this.hostPort + "_" + this.bindAddr;
        this.pduSupport = new RawPduReceivedSupport(this);
        this.unhandledSupport = new RawPduReceivedSupport(this);
        this.maxRecvSize = 1300;
    }

    public int getPort() {
        return this.hostPort;
    }

    public String getBindAddress() {
        return this.bindAddr;
    }

    public String getTypeSocket() {
        return this.typeSocket;
    }

    public int getMaxRecvSize() {
        return this.maxRecvSize;
    }

    public void setMaxRecvSize(int no) {
        this.maxRecvSize = no;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        String string = SOC_LOCK;
        synchronized (SOC_LOCK) {
            this.stopRequested = true;
            if (this.soc != null) {
                if (AsnObject.debug > 12) {
                    System.out.println(this.getClass().getName() + ".destroy(): Closing socket ");
                }
                this.soc.close();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void run() {
        while (!this.stopRequested) {
            ListeningContext listeningContext = this;
            listeningContext.me.yield();
            try {
                if (this.stopRequested) break;
                StreamPortItem item = this.soc.receive(this.maxRecvSize);
                ByteArrayInputStream in = item.getStream();
                String hostAddress = item.getHostAddress();
                int port = item.getHostPort();
                int nb = in.available();
                byte[] bu = new byte[nb];
                in.read(bu);
                in.close();
                if (AsnObject.debug > 10) {
                    SnmpUtilities.dumpBytes(this.getClass().getName() + ".run(): Received from " + hostAddress + ", from port " + port + ": ", bu);
                }
                KickProcessIncomingMessage thread = new KickProcessIncomingMessage(hostAddress, port, bu);
                thread.start();
            }
            catch (IOException exc) {
                if (exc instanceof InterruptedIOException) {
                    if (AsnObject.debug <= 15) continue;
                    System.out.println(this.getClass().getName() + ".run(): Idle recv " + exc.getMessage());
                    continue;
                }
                if (AsnObject.debug <= 0) continue;
                System.out.println(this.getClass().getName() + ".run(): IOException: " + exc.getMessage());
            }
            catch (Exception exc) {
                if (AsnObject.debug <= 0) continue;
                System.out.println(this.getClass().getName() + ".run(): Exception: " + exc.getMessage());
                exc.printStackTrace();
            }
            catch (Error err) {
                if (AsnObject.debug <= 0) continue;
                System.out.println(this.getClass().getName() + ".run(): Error: " + err.getMessage());
                err.printStackTrace();
            }
        }
        this.me = null;
        this.soc = null;
        this.pduSupport.empty();
        this.unhandledSupport.empty();
    }

    public void addRawPduListener(RawPduListener listener) throws IOException {
        this.pduSupport.addRawPduListener(listener);
        this.startListening();
    }

    public void removeRawPduListener(RawPduListener listener) {
        this.pduSupport.removeRawPduListener(listener);
        int nr = this.pduSupport.getListenerCount();
        if (nr == 0) {
            this.destroy();
        }
    }

    public void addUnhandledRawPduListener(RawPduListener listener) throws IOException {
        this.unhandledSupport.addRawPduListener(listener);
        this.startListening();
    }

    public void removeUnhandledRawPduListener(RawPduListener listener) {
        this.unhandledSupport.removeRawPduListener(listener);
        int nr = this.unhandledSupport.getListenerCount();
        if (nr == 0) {
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startListening() throws IOException {
        String string = SOC_LOCK;
        synchronized (SOC_LOCK) {
            if (this.soc == null) {
                this.soc = AbstractSnmpContext.getSocket(this.typeSocket);
                this.soc.create(this.hostPort, this.bindAddr);
                if (AsnObject.debug > 12) {
                    System.out.println(this.getClass().getName() + ".startListening()" + ": soc.getLocalSocketAddress() = " + this.soc.getLocalSocketAddress());
                    System.out.println(this.getClass().getName() + ".startListening()" + ": soc.getRemoteSocketAddress() = " + this.soc.getRemoteSocketAddress());
                }
            }
            if (this.me == null) {
                this.stopRequested = false;
                this.me = new Thread((Runnable)this, this.basename + "_Listen");
                this.me.setPriority(5);
                this.me.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("ListeningContext[");
        buffer.append("port=").append(this.hostPort);
        buffer.append(", bindAddress=").append(this.bindAddr);
        buffer.append(", socketType=").append(this.typeSocket);
        buffer.append(", #rawPduListeners=").append(this.pduSupport.getListenerCount());
        buffer.append(", #rawPduUnhandledListeners=").append(this.unhandledSupport.getListenerCount());
        buffer.append("]");
        return buffer.toString();
    }

    protected void processIncomingMessage(String hostAddress, int port, byte[] bu) throws DecodingException, IOException {
        AsnDecoderBase rpdu = new AsnDecoderBase();
        ByteArrayInputStream in = new ByteArrayInputStream(bu);
        AsnSequence asnTopSeq = rpdu.getAsnSequence(in);
        int version = rpdu.getSNMPVersion(asnTopSeq);
        boolean isConsumed = this.pduSupport.fireRawPduReceived(version, hostAddress, port, bu);
        if (!isConsumed) {
            this.unhandledSupport.fireRawPduReceived(version, hostAddress, port, bu);
        }
    }

    class KickProcessIncomingMessage
    extends Thread {
        private String hostAddress;
        private int port;
        private byte[] bu;

        KickProcessIncomingMessage(String newHostAddress, int newPort, byte[] newBu) {
            this.hostAddress = newHostAddress;
            this.port = newPort;
            this.bu = newBu;
            this.setPriority(1);
            this.setName(newHostAddress + "_" + newPort + "_KickProcessIncomingMessage_" + counter);
            counter++;
        }

        public void run() {
            block4: {
                try {
                    ListeningContext.this.processIncomingMessage(this.hostAddress, this.port, this.bu);
                }
                catch (IOException exc) {
                    if (AsnObject.debug > 0) {
                        System.out.println(this.getClass().getName() + ".run(): IOException: " + exc.getMessage());
                    }
                }
                catch (DecodingException exc) {
                    if (AsnObject.debug <= 1) break block4;
                    System.out.println(this.getClass().getName() + ".run(): DecodingException: " + exc.getMessage());
                }
            }
        }
    }
}

