// NAME
//      $RCSfile: InetCidrRouteTablePdu.java,v $
// DESCRIPTION
//      [given below in javadoc format]
// DELTA
//      $Revision: 1.2 $
// CREATED
//      $Date: 2006/03/23 14:40:58 $
// COPYRIGHT
//      Westhawk Ltd
// TO DO
//

package uk.co.westhawk.examplev1;

import uk.co.westhawk.snmp.stack.*;
import uk.co.westhawk.snmp.pdu.*;
import java.util.*;


/**
 * The class InetCidrRouteTablePdu.
 *
 * This file is auto generated by the StubBrowser utility, using Mibble.
 * See the uk/co/westhawk/stub/ directory.
 *
 * Make sure that you replace the package name and classname placeholders. 
 * Also, move this file to the correct package directory.
 * If these things are not done, this class will not compile correctly!!
 *
 * @version $Revision: 1.2 $ $Date: 2006/03/23 14:40:58 $
 */
public class InetCidrRouteTablePdu extends GetNextPdu
{
    private static final String version_id =
        "@(#)$Id: InetCidrRouteTablePdu.java,v 1.2 2006/03/23 14:40:58 birgit Exp $ Copyright Westhawk Ltd";

    public final static String inetCidrRouteIfIndex_OID = "1.3.6.1.2.1.4.24.7.1.7";
    public final static String inetCidrRouteType_OID = "1.3.6.1.2.1.4.24.7.1.8";
    public final static String inetCidrRouteProto_OID = "1.3.6.1.2.1.4.24.7.1.9";
    public final static String inetCidrRouteAge_OID = "1.3.6.1.2.1.4.24.7.1.10";
    public final static String inetCidrRouteNextHopAS_OID = "1.3.6.1.2.1.4.24.7.1.11";
    public final static String inetCidrRouteMetric1_OID = "1.3.6.1.2.1.4.24.7.1.12";
    public final static String inetCidrRouteMetric2_OID = "1.3.6.1.2.1.4.24.7.1.13";
    public final static String inetCidrRouteMetric3_OID = "1.3.6.1.2.1.4.24.7.1.14";
    public final static String inetCidrRouteMetric4_OID = "1.3.6.1.2.1.4.24.7.1.15";
    public final static String inetCidrRouteMetric5_OID = "1.3.6.1.2.1.4.24.7.1.16";
    public final static String inetCidrRouteStatus_OID = "1.3.6.1.2.1.4.24.7.1.17";

    public final static int NO_SCAL = 0;
    public final static int NO_COL = 11;
    public final static int NO_OID = NO_SCAL + NO_COL;


    public final static String scal_oids[] =
    {
    };

    public final static String col_oids[] =
    {
        inetCidrRouteIfIndex_OID,
        inetCidrRouteType_OID,
        inetCidrRouteProto_OID,
        inetCidrRouteAge_OID,
        inetCidrRouteNextHopAS_OID,
        inetCidrRouteMetric1_OID,
        inetCidrRouteMetric2_OID,
        inetCidrRouteMetric3_OID,
        inetCidrRouteMetric4_OID,
        inetCidrRouteMetric5_OID,
        inetCidrRouteStatus_OID,
    };

    public final static String all_oids[] =
    {
        inetCidrRouteIfIndex_OID,
        inetCidrRouteType_OID,
        inetCidrRouteProto_OID,
        inetCidrRouteAge_OID,
        inetCidrRouteNextHopAS_OID,
        inetCidrRouteMetric1_OID,
        inetCidrRouteMetric2_OID,
        inetCidrRouteMetric3_OID,
        inetCidrRouteMetric4_OID,
        inetCidrRouteMetric5_OID,
        inetCidrRouteStatus_OID,
    };


    protected Integer _inetCidrRouteIfIndex;
    protected java.util.HashMap _inetCidrRouteTypeMap = new java.util.HashMap(5);
    protected Integer _inetCidrRouteType;
    protected java.util.HashMap _inetCidrRouteProtoMap = new java.util.HashMap(17);
    protected Integer _inetCidrRouteProto;
    protected Long _inetCidrRouteAge;
    protected Long _inetCidrRouteNextHopAS;
    protected Integer _inetCidrRouteMetric1;
    protected Integer _inetCidrRouteMetric2;
    protected Integer _inetCidrRouteMetric3;
    protected Integer _inetCidrRouteMetric4;
    protected Integer _inetCidrRouteMetric5;
    protected java.util.HashMap _inetCidrRouteStatusMap = new java.util.HashMap(6);
    protected Integer _inetCidrRouteStatus;

    protected boolean _invalid = false;
    protected int _tmpErrorInd = -1;
    protected int _tmpErrorStat = 0;

/**
 * Constructor.
 *
 * @param con The context of the request
 */
public InetCidrRouteTablePdu(SnmpContextBasisFace con)
{
    super(con);
    _inetCidrRouteTypeMap.put(new Integer(2), "reject");
    _inetCidrRouteTypeMap.put(new Integer(1), "other");
    _inetCidrRouteTypeMap.put(new Integer(3), "local");
    _inetCidrRouteTypeMap.put(new Integer(5), "blackhole");
    _inetCidrRouteTypeMap.put(new Integer(4), "remote");

    _inetCidrRouteProtoMap.put(new Integer(3), "netmgmt");
    _inetCidrRouteProtoMap.put(new Integer(1), "other");
    _inetCidrRouteProtoMap.put(new Integer(9), "isIs");
    _inetCidrRouteProtoMap.put(new Integer(10), "esIs");
    _inetCidrRouteProtoMap.put(new Integer(7), "hello");
    _inetCidrRouteProtoMap.put(new Integer(8), "rip");
    _inetCidrRouteProtoMap.put(new Integer(14), "bgp");
    _inetCidrRouteProtoMap.put(new Integer(6), "ggp");
    _inetCidrRouteProtoMap.put(new Integer(4), "icmp");
    _inetCidrRouteProtoMap.put(new Integer(5), "egp");
    _inetCidrRouteProtoMap.put(new Integer(13), "ospf");
    _inetCidrRouteProtoMap.put(new Integer(11), "ciscoIgrp");
    _inetCidrRouteProtoMap.put(new Integer(2), "local");
    _inetCidrRouteProtoMap.put(new Integer(17), "dvmrp");
    _inetCidrRouteProtoMap.put(new Integer(16), "ciscoEigrp");
    _inetCidrRouteProtoMap.put(new Integer(12), "bbnSpfIgp");
    _inetCidrRouteProtoMap.put(new Integer(15), "idpr");

    _inetCidrRouteStatusMap.put(new Integer(1), "active");
    _inetCidrRouteStatusMap.put(new Integer(2), "notInService");
    _inetCidrRouteStatusMap.put(new Integer(5), "createAndWait");
    _inetCidrRouteStatusMap.put(new Integer(4), "createAndGo");
    _inetCidrRouteStatusMap.put(new Integer(3), "notReady");
    _inetCidrRouteStatusMap.put(new Integer(6), "destroy");

    _invalid = false;
    _tmpErrorInd = -1;
    _tmpErrorStat = 0;
}

/**
 * Constructor that will send the first request immediately.
 *
 * @param con The context of the request
 * @param o the Observer that will be notified when the answer is
 * received
 */
public InetCidrRouteTablePdu(SnmpContextBasisFace con, Observer o)
throws PduException, java.io.IOException
{
    this(con);
    addOids(null);
    if (o != null)
    {
        addObserver(o);
    }
    send();
}


/**
 * The method addOids is the basis for the GetNext functionality.
 *
 * If old is null, it initialises the varbinds from all_oids.
 * If old is not null, it copies the column OIDs from the
 * old InetCidrRouteTablePdu object.
 * so the request continues where the previous one left.
 *
 * Note, the scalars and the columns OIDs are handled differently. The
 * scalars are always copied from the original scal_oids, only the
 * column OIDs are copied from the old
 * InetCidrRouteTablePdu object.
 */
public void addOids(InetCidrRouteTablePdu old)
{
    if (old != null)
    {
        for (int i=0; i<NO_SCAL; i++)
        {
            addOid(scal_oids[i]);
        }
        for (int i=NO_SCAL; i<NO_OID; i++)
        {
            varbind var = (varbind) old.respVarbinds.elementAt(i);
            addOid(var.getOid());
        }
    }
    else
    {
        for (int i=0; i<NO_OID; i++)
        {
            addOid(all_oids[i]);
        }
    }
}


/**
 * This method sets the column index. By doing this, the request will
 * return (only) the row after row index.
 *
 * The index parameters only applies to the column OIDs.
 * The scalars are copied from the original scal_oids.
 */
public void addOids(int index)
{
    for (int i=0; i<NO_SCAL; i++)
    {
        addOid(scal_oids[i]);
    }
    for (int i=0; i<NO_COL; i++)
    {
        addOid(col_oids[i] + "." + index);
    }
}
/**
 * The value of the request is set. This will be called by
 * Pdu.fillin().
 *
 * I check if the variables are still in range.
 * I do this because I'm only interessed in a part of the MIB. If I
 * would not do this check, I'll get the whole MIB from the starting
 * point, instead of the variables in the table.
 *
 * @param n the index of the value
 * @param a_var the value
 * @see Pdu#new_value
 */
protected void new_value(int n, varbind res)
{
    if (getErrorStatus() == AsnObject.SNMP_ERR_NOERROR)
    {
        AsnObjectId oid = res.getOid();
        AsnObject value = res.getValue();

        if (oid.toString().startsWith(all_oids[n]))
        {
            try
            {
                switch (n)
                {
                    case 0:
                        setInetCidrRouteIfIndex(value);
                        break;
                    case 1:
                        setInetCidrRouteType(value);
                        break;
                    case 2:
                        setInetCidrRouteProto(value);
                        break;
                    case 3:
                        setInetCidrRouteAge(value);
                        break;
                    case 4:
                        setInetCidrRouteNextHopAS(value);
                        break;
                    case 5:
                        setInetCidrRouteMetric1(value);
                        break;
                    case 6:
                        setInetCidrRouteMetric2(value);
                        break;
                    case 7:
                        setInetCidrRouteMetric3(value);
                        break;
                    case 8:
                        setInetCidrRouteMetric4(value);
                        break;
                    case 9:
                        setInetCidrRouteMetric5(value);
                        break;
                    case 10:
                        setInetCidrRouteStatus(value);
                        break;
                    default:
                        _invalid = true;
                        setTmpErrorIndex(n);
                        _tmpErrorStat = SnmpConstants.SNMP_ERR_GENERR;
                }
            }
            catch (ClassCastException exc)
            {
                _invalid = true;
                setTmpErrorIndex(n);
                _tmpErrorStat = SnmpConstants.SNMP_ERR_GENERR;
            }
        }
        else
        {
            _invalid = true;
            setTmpErrorIndex(n);
            _tmpErrorStat = SnmpConstants.SNMP_ERR_NOSUCHNAME;
        }
    }

    if (n >= NO_OID-1)
    {
        if (_invalid == true)
        {
            setErrorStatus(_tmpErrorStat);
            setErrorIndex(_tmpErrorInd);
        }
    }
}


/**
inetCidrRouteIfIndex<br/>
TYPE InterfaceIndexOrZero ::= TEXTUAL-CONVENTION (
  Display-Hint: d
  Status: current
  Description: This textual convention is an extension of the
               InterfaceIndex convention.  The latter defines a greater
               than zero value used to identify an interface or interface
               sub-layer in the managed system.  This extension permits the
               additional value of zero.  the value zero is object-specific
               and must therefore be defined as part of the description of
               any object which uses this syntax.  Examples of the usage of
               zero might include situations where interface was unknown,
               or when none or all interfaces need to be referenced.
  Syntax: [UNIVERSAL 2] INTEGER (0..2147483647)
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (0..2147483647)
  Access: read-create
  Status: current
  Description: The ifIndex value which identifies the local interface
               through which the next hop of this route should be  
               reached.  A value of 0 is valid and represents the 
               scenario where no interface is specified.
)<br/>
*/
public void setInetCidrRouteIfIndex(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _inetCidrRouteIfIndex = new Integer(obj.getValue());
}
public Integer getInetCidrRouteIfIndex()
{
    return _inetCidrRouteIfIndex;
}


/**
inetCidrRouteType<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (1 | 2 | 3 | 4 | 5)
  Access: read-create
  Status: current
  Description: The type of route.  Note that local(3) refers to a
               route for which the next hop is the final destination;  
               remote(4)refers to a route for which the next hop is  
               not the final destination. 
               
               Routes which do not result in traffic forwarding or 
               rejection should not be displayed even if the  
               implementation keeps them stored internally. 
               
               reject(2) refers to a route which, if matched, discards  
               the message as unreachable and returns a notification  
               (e.g. ICMP error) to the message sender.  This is used  
               in some protocols as a means of correctly aggregating  
               routes. 
               
               blackhole(5) refers to a route which, if matched,  
               discards the message silently.
)<br/>
*/
public void setInetCidrRouteType(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _inetCidrRouteType = new Integer(obj.getValue());
}
public String getInetCidrRouteTypeStr()
{
    String ret = null;
    if (_inetCidrRouteType != null)
    {
        ret = (String) _inetCidrRouteTypeMap.get(_inetCidrRouteType);
    }
    return ret;
}
public Integer getInetCidrRouteType()
{
    return _inetCidrRouteType;
}


/**
inetCidrRouteProto<br/>
TYPE IANAipRouteProtocol ::= TEXTUAL-CONVENTION (
  Status: current
  Description: A mechanism for learning routes.  Inclusion of values for
               routing protocols is not intended to imply that those
               protocols need be supported.
  Syntax: [UNIVERSAL 2] INTEGER (1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11 | 12 | 13 | 14 | 15 | 16 | 17)
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11 | 12 | 13 | 14 | 15 | 16 | 17)
  Access: read-only
  Status: current
  Description: The routing mechanism via which this route was learned.
               Inclusion of values for gateway routing protocols is  
               not intended to imply that hosts should support those 
               protocols.
)<br/>
*/
public void setInetCidrRouteProto(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _inetCidrRouteProto = new Integer(obj.getValue());
}
public String getInetCidrRouteProtoStr()
{
    String ret = null;
    if (_inetCidrRouteProto != null)
    {
        ret = (String) _inetCidrRouteProtoMap.get(_inetCidrRouteProto);
    }
    return ret;
}
public Integer getInetCidrRouteProto()
{
    return _inetCidrRouteProto;
}


/**
inetCidrRouteAge<br/>
TYPE Gauge32 ::= [APPLICATION 2] INTEGER (0..4294967295)<br/>
OBJECT-TYPE (
  Syntax: [APPLICATION 2] INTEGER (0..4294967295)
  Access: read-only
  Status: current
  Description: The number of seconds since this route was last updated
               or otherwise determined to be correct.  Note that no  
               semantics of 'too old' can be implied except through  
               knowledge of the routing protocol by which the route  
               was learned.
)<br/>
*/
public void setInetCidrRouteAge(AsnObject new_value)
{
    AsnUnsInteger obj = (AsnUnsInteger) new_value;
    _inetCidrRouteAge = new Long(obj.getValue());
}
public Long getInetCidrRouteAge()
{
    return _inetCidrRouteAge;
}


/**
inetCidrRouteNextHopAS<br/>
TYPE InetAutonomousSystemNumber ::= TEXTUAL-CONVENTION (
  Display-Hint: d
  Status: current
  Description: Represents an autonomous system number that identifies an
               Autonomous System (AS).  An AS is a set of routers under a
               single technical administration, using an interior gateway
               protocol and common metrics to route packets within the AS,
               and using an exterior gateway protocol to route packets to
               other ASes'.  IANA maintains the AS number space and has
               delegated large parts to the regional registries.
               
               Autonomous system numbers are currently limited to 16 bits
               (0..65535).  There is, however, work in progress to enlarge the
               autonomous system number space to 32 bits.  Therefore, this
               textual convention uses an Unsigned32 value without a
               range restriction in order to support a larger autonomous
               system number space.
  Reference: RFC 1771, RFC 1930
  Syntax: [APPLICATION 2] INTEGER (0..4294967295)
)<br/>
OBJECT-TYPE (
  Syntax: [APPLICATION 2] INTEGER (0..4294967295)
  Access: read-create
  Status: current
  Description: The Autonomous System Number of the Next Hop.  The
               semantics of this object are determined by the routing- 
               protocol specified in the route's inetCidrRouteProto  
               value. When this object is unknown or not relevant its  
               value should be set to zero.
  Default Value: 0
)<br/>
*/
public void setInetCidrRouteNextHopAS(AsnObject new_value)
{
    AsnUnsInteger obj = (AsnUnsInteger) new_value;
    _inetCidrRouteNextHopAS = new Long(obj.getValue());
}
public Long getInetCidrRouteNextHopAS()
{
    return _inetCidrRouteNextHopAS;
}


/**
inetCidrRouteMetric1<br/>
TYPE Integer32 ::= [UNIVERSAL 2] INTEGER (-2147483648..2147483647)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (-2147483648..2147483647)
  Access: read-create
  Status: current
  Description: The primary routing metric for this route.  The
               semantics of this metric are determined by the routing- 
               protocol specified in the route's inetCidrRouteProto  
               value.  If this metric is not used, its value should be  
               set to -1.
  Default Value: -1
)<br/>
*/
public void setInetCidrRouteMetric1(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _inetCidrRouteMetric1 = new Integer(obj.getValue());
}
public Integer getInetCidrRouteMetric1()
{
    return _inetCidrRouteMetric1;
}


/**
inetCidrRouteMetric2<br/>
TYPE Integer32 ::= [UNIVERSAL 2] INTEGER (-2147483648..2147483647)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (-2147483648..2147483647)
  Access: read-create
  Status: current
  Description: An alternate routing metric for this route.  The
               semantics of this metric are determined by the routing- 
               protocol specified in the route's inetCidrRouteProto  
               value.  If this metric is not used, its value should be  
               set to -1.
  Default Value: -1
)<br/>
*/
public void setInetCidrRouteMetric2(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _inetCidrRouteMetric2 = new Integer(obj.getValue());
}
public Integer getInetCidrRouteMetric2()
{
    return _inetCidrRouteMetric2;
}


/**
inetCidrRouteMetric3<br/>
TYPE Integer32 ::= [UNIVERSAL 2] INTEGER (-2147483648..2147483647)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (-2147483648..2147483647)
  Access: read-create
  Status: current
  Description: An alternate routing metric for this route.  The
               semantics of this metric are determined by the routing- 
               protocol specified in the route's inetCidrRouteProto  
               value.  If this metric is not used, its value should be  
               set to -1.
  Default Value: -1
)<br/>
*/
public void setInetCidrRouteMetric3(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _inetCidrRouteMetric3 = new Integer(obj.getValue());
}
public Integer getInetCidrRouteMetric3()
{
    return _inetCidrRouteMetric3;
}


/**
inetCidrRouteMetric4<br/>
TYPE Integer32 ::= [UNIVERSAL 2] INTEGER (-2147483648..2147483647)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (-2147483648..2147483647)
  Access: read-create
  Status: current
  Description: An alternate routing metric for this route.  The
               semantics of this metric are determined by the routing- 
               protocol specified in the route's inetCidrRouteProto  
               value.  If this metric is not used, its value should be  
               set to -1.
  Default Value: -1
)<br/>
*/
public void setInetCidrRouteMetric4(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _inetCidrRouteMetric4 = new Integer(obj.getValue());
}
public Integer getInetCidrRouteMetric4()
{
    return _inetCidrRouteMetric4;
}


/**
inetCidrRouteMetric5<br/>
TYPE Integer32 ::= [UNIVERSAL 2] INTEGER (-2147483648..2147483647)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (-2147483648..2147483647)
  Access: read-create
  Status: current
  Description: An alternate routing metric for this route.  The
               semantics of this metric are determined by the routing- 
               protocol specified in the route's inetCidrRouteProto  
               value.  If this metric is not used, its value should be  
               set to -1.
  Default Value: -1
)<br/>
*/
public void setInetCidrRouteMetric5(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _inetCidrRouteMetric5 = new Integer(obj.getValue());
}
public Integer getInetCidrRouteMetric5()
{
    return _inetCidrRouteMetric5;
}


/**
inetCidrRouteStatus<br/>
TYPE RowStatus ::= TEXTUAL-CONVENTION (
  Status: current
  Description: The RowStatus textual convention is used to manage the
               creation and deletion of conceptual rows, and is used as the
               value of the SYNTAX clause for the status column of a
               conceptual row (as described in Section 7.7.1 of [2].)
               
               The status column has six defined values:
               
                    - `active', which indicates that the conceptual row is
                    available for use by the managed device;
               
                    - `notInService', which indicates that the conceptual
                    row exists in the agent, but is unavailable for use by
                    the managed device (see NOTE below); 'notInService' has
                    no implication regarding the internal consistency of
                    the row, availability of resources, or consistency with
                    the current state of the managed device;
               
                    - `notReady', which indicates that the conceptual row
                    exists in the agent, but is missing information
                    necessary in order to be available for use by the
                    managed device (i.e., one or more required columns in
                    the conceptual row have not been instanciated);
               
                    - `createAndGo', which is supplied by a management
                    station wishing to create a new instance of a
                    conceptual row and to have its status automatically set
                    to active, making it available for use by the managed
                    device;
               
                    - `createAndWait', which is supplied by a management
                    station wishing to create a new instance of a
                    conceptual row (but not make it available for use by
                    the managed device); and,
                    - `destroy', which is supplied by a management station
                    wishing to delete all of the instances associated with
                    an existing conceptual row.
               
               Whereas five of the six values (all except `notReady') may
               be specified in a management protocol set operation, only
               three values will be returned in response to a management
               protocol retrieval operation:  `notReady', `notInService' or
               `active'.  That is, when queried, an existing conceptual row
               has only three states:  it is either available for use by
               the managed device (the status column has value `active');
               it is not available for use by the managed device, though
               the agent has sufficient information to attempt to make it
               so (the status column has value `notInService'); or, it is
               not available for use by the managed device, and an attempt
               to make it so would fail because the agent has insufficient
               information (the state column has value `notReady').
               
                                        NOTE WELL
               
                    This textual convention may be used for a MIB table,
                    irrespective of whether the values of that table's
                    conceptual rows are able to be modified while it is
                    active, or whether its conceptual rows must be taken
                    out of service in order to be modified.  That is, it is
                    the responsibility of the DESCRIPTION clause of the
                    status column to specify whether the status column must
                    not be `active' in order for the value of some other
                    column of the same conceptual row to be modified.  If
                    such a specification is made, affected columns may be
                    changed by an SNMP set PDU if the RowStatus would not
                    be equal to `active' either immediately before or after
                    processing the PDU.  In other words, if the PDU also
                    contained a varbind that would change the RowStatus
                    value, the column in question may be changed if the
                    RowStatus was not equal to `active' as the PDU was
                    received, or if the varbind sets the status to a value
                    other than 'active'.
               
               Also note that whenever any elements of a row exist, the
               RowStatus column must also exist.
               
               To summarize the effect of having a conceptual row with a
               status column having a SYNTAX clause value of RowStatus,
               consider the following state diagram:
               
                                            STATE
                 +--------------+-----------+-------------+-------------
                 |      A       |     B     |      C      |      D
                 |              |status col.|status column|
                 |status column |    is     |      is     |status column
               ACTION    |does not exist|  notReady | notInService|  is active
               --------------+--------------+-----------+-------------+-------------
               set status    |noError    ->D|inconsist- |inconsistent-|inconsistent-
               column to     |       or     |   entValue|        Value|        Value
               createAndGo   |inconsistent- |           |             |
                 |         Value|           |             |
               --------------+--------------+-----------+-------------+-------------
               set status    |noError  see 1|inconsist- |inconsistent-|inconsistent-
               column to     |       or     |   entValue|        Value|        Value
               createAndWait |wrongValue    |           |             |
               --------------+--------------+-----------+-------------+-------------
               set status    |inconsistent- |inconsist- |noError      |noError
               column to     |         Value|   entValue|             |
               active        |              |           |             |
                 |              |     or    |             |
                 |              |           |             |
                 |              |see 2   ->D|see 8     ->D|          ->D
               --------------+--------------+-----------+-------------+-------------
               set status    |inconsistent- |inconsist- |noError      |noError   ->C
               column to     |         Value|   entValue|             |
               notInService  |              |           |             |
                 |              |     or    |             |      or
                 |              |           |             |
                 |              |see 3   ->C|          ->C|see 6
               --------------+--------------+-----------+-------------+-------------
               set status    |noError       |noError    |noError      |noError   ->A
               column to     |              |           |             |      or
               destroy       |           ->A|        ->A|          ->A|see 7
               --------------+--------------+-----------+-------------+-------------
               set any other |see 4         |noError    |noError      |see 5
               column to some|              |           |             |
               value         |              |      see 1|          ->C|          ->D
               --------------+--------------+-----------+-------------+-------------
               
               (1) goto B or C, depending on information available to the
               agent.
               
               (2) if other variable bindings included in the same PDU,
               provide values for all columns which are missing but
               required, and all columns have acceptable values, then
               return noError and goto D.
               
               (3) if other variable bindings included in the same PDU,
               provide legal values for all columns which are missing but
               required, then return noError and goto C.
               
               (4) at the discretion of the agent, the return value may be
               either:
               
                    inconsistentName:  because the agent does not choose to
                    create such an instance when the corresponding
                    RowStatus instance does not exist, or
               
                    inconsistentValue:  if the supplied value is
                    inconsistent with the state of some other MIB object's
                    value, or
               
                    noError: because the agent chooses to create the
                    instance.
               
               If noError is returned, then the instance of the status
               column must also be created, and the new state is B or C,
               depending on the information available to the agent.  If
               inconsistentName or inconsistentValue is returned, the row
               remains in state A.
               
               (5) depending on the MIB definition for the column/table,
               either noError or inconsistentValue may be returned.
               
               (6) the return value can indicate one of the following
               errors:
               
                    wrongValue: because the agent does not support
                    notInService (e.g., an agent which does not support
                    createAndWait), or
               
                    inconsistentValue: because the agent is unable to take
                    the row out of service at this time, perhaps because it
                    is in use and cannot be de-activated.
               
               (7) the return value can indicate the following error:
               
                    inconsistentValue: because the agent is unable to
                    remove the row at this time, perhaps because it is in
                    use and cannot be de-activated.
               
               (8) the transition to D can fail, e.g., if the values of the
               conceptual row are inconsistent, then the error code would
               be inconsistentValue.
               
               NOTE: Other processing of (this and other varbinds of) the
               set request may result in a response other than noError
               being returned, e.g., wrongValue, noCreation, etc.
               
                                 Conceptual Row Creation
               
               There are four potential interactions when creating a
               conceptual row:  selecting an instance-identifier which is
               not in use; creating the conceptual row; initializing any
               objects for which the agent does not supply a default; and,
               making the conceptual row available for use by the managed
               device.
               
               Interaction 1: Selecting an Instance-Identifier
               
               The algorithm used to select an instance-identifier varies
               for each conceptual row.  In some cases, the instance-
               identifier is semantically significant, e.g., the
               destination address of a route, and a management station
               selects the instance-identifier according to the semantics.
               
               In other cases, the instance-identifier is used solely to
               distinguish conceptual rows, and a management station
               without specific knowledge of the conceptual row might
               examine the instances present in order to determine an
               unused instance-identifier.  (This approach may be used, but
               it is often highly sub-optimal; however, it is also a
               questionable practice for a naive management station to
               attempt conceptual row creation.)
               
               Alternately, the MIB module which defines the conceptual row
               might provide one or more objects which provide assistance
               in determining an unused instance-identifier.  For example,
               if the conceptual row is indexed by an integer-value, then
               an object having an integer-valued SYNTAX clause might be
               defined for such a purpose, allowing a management station to
               issue a management protocol retrieval operation.  In order
               to avoid unnecessary collisions between competing management
               stations, `adjacent' retrievals of this object should be
               different.
               
               Finally, the management station could select a pseudo-random
               number to use as the index.  In the event that this index
               
               was already in use and an inconsistentValue was returned in
               response to the management protocol set operation, the
               management station should simply select a new pseudo-random
               number and retry the operation.
               
               A MIB designer should choose between the two latter
               algorithms based on the size of the table (and therefore the
               efficiency of each algorithm).  For tables in which a large
               number of entries are expected, it is recommended that a MIB
               object be defined that returns an acceptable index for
               creation.  For tables with small numbers of entries, it is
               recommended that the latter pseudo-random index mechanism be
               used.
               
               Interaction 2: Creating the Conceptual Row
               
               Once an unused instance-identifier has been selected, the
               management station determines if it wishes to create and
               activate the conceptual row in one transaction or in a
               negotiated set of interactions.
               
               Interaction 2a: Creating and Activating the Conceptual Row
               
               The management station must first determine the column
               requirements, i.e., it must determine those columns for
               which it must or must not provide values.  Depending on the
               complexity of the table and the management station's
               knowledge of the agent's capabilities, this determination
               can be made locally by the management station.  Alternately,
               the management station issues a management protocol get
               operation to examine all columns in the conceptual row that
               it wishes to create.  In response, for each column, there
               are three possible outcomes:
               
                    - a value is returned, indicating that some other
                    management station has already created this conceptual
                    row.  We return to interaction 1.
               
                    - the exception `noSuchInstance' is returned,
                    indicating that the agent implements the object-type
                    associated with this column, and that this column in at
                    least one conceptual row would be accessible in the MIB
                    view used by the retrieval were it to exist. For those
                    columns to which the agent provides read-create access,
                    the `noSuchInstance' exception tells the management
                    station that it should supply a value for this column
                    when the conceptual row is to be created.
               
                    - the exception `noSuchObject' is returned, indicating
                    that the agent does not implement the object-type
                    associated with this column or that there is no
                    conceptual row for which this column would be
                    accessible in the MIB view used by the retrieval.  As
                    such, the management station can not issue any
                    management protocol set operations to create an
                    instance of this column.
               
               Once the column requirements have been determined, a
               management protocol set operation is accordingly issued.
               This operation also sets the new instance of the status
               column to `createAndGo'.
               
               When the agent processes the set operation, it verifies that
               it has sufficient information to make the conceptual row
               available for use by the managed device.  The information
               available to the agent is provided by two sources:  the
               management protocol set operation which creates the
               conceptual row, and, implementation-specific defaults
               supplied by the agent (note that an agent must provide
               implementation-specific defaults for at least those objects
               which it implements as read-only).  If there is sufficient
               information available, then the conceptual row is created, a
               `noError' response is returned, the status column is set to
               `active', and no further interactions are necessary (i.e.,
               interactions 3 and 4 are skipped).  If there is insufficient
               information, then the conceptual row is not created, and the
               set operation fails with an error of `inconsistentValue'.
               On this error, the management station can issue a management
               protocol retrieval operation to determine if this was
               because it failed to specify a value for a required column,
               or, because the selected instance of the status column
               already existed.  In the latter case, we return to
               interaction 1.  In the former case, the management station
               can re-issue the set operation with the additional
               information, or begin interaction 2 again using
               `createAndWait' in order to negotiate creation of the
               conceptual row.
               
                                        NOTE WELL
               
                    Regardless of the method used to determine the column
                    requirements, it is possible that the management
                    station might deem a column necessary when, in fact,
                    the agent will not allow that particular columnar
                    instance to be created or written.  In this case, the
                    management protocol set operation will fail with an
                    error such as `noCreation' or `notWritable'.  In this
                    case, the management station decides whether it needs
                    to be able to set a value for that particular columnar
                    instance.  If not, the management station re-issues the
                    management protocol set operation, but without setting
                    a value for that particular columnar instance;
                    otherwise, the management station aborts the row
                    creation algorithm.
               
               Interaction 2b: Negotiating the Creation of the Conceptual
               Row
               
               The management station issues a management protocol set
               operation which sets the desired instance of the status
               column to `createAndWait'.  If the agent is unwilling to
               process a request of this sort, the set operation fails with
               an error of `wrongValue'.  (As a consequence, such an agent
               must be prepared to accept a single management protocol set
               operation, i.e., interaction 2a above, containing all of the
               columns indicated by its column requirements.)  Otherwise,
               the conceptual row is created, a `noError' response is
               returned, and the status column is immediately set to either
               `notInService' or `notReady', depending on whether it has
               sufficient information to (attempt to) make the conceptual
               row available for use by the managed device.  If there is
               sufficient information available, then the status column is
               set to `notInService'; otherwise, if there is insufficient
               information, then the status column is set to `notReady'.
               Regardless, we proceed to interaction 3.
               
               Interaction 3: Initializing non-defaulted Objects
               
               The management station must now determine the column
               requirements.  It issues a management protocol get operation
               to examine all columns in the created conceptual row.  In
               the response, for each column, there are three possible
               outcomes:
               
                    - a value is returned, indicating that the agent
                    implements the object-type associated with this column
                    and had sufficient information to provide a value.  For
                    those columns to which the agent provides read-create
                    access (and for which the agent allows their values to
                    be changed after their creation), a value return tells
                    the management station that it may issue additional
                    management protocol set operations, if it desires, in
                    order to change the value associated with this column.
               
                    - the exception `noSuchInstance' is returned,
                    indicating that the agent implements the object-type
                    associated with this column, and that this column in at
                    least one conceptual row would be accessible in the MIB
                    view used by the retrieval were it to exist. However,
                    the agent does not have sufficient information to
                    provide a value, and until a value is provided, the
                    conceptual row may not be made available for use by the
                    managed device.  For those columns to which the agent
                    provides read-create access, the `noSuchInstance'
                    exception tells the management station that it must
                    issue additional management protocol set operations, in
                    order to provide a value associated with this column.
               
                    - the exception `noSuchObject' is returned, indicating
                    that the agent does not implement the object-type
                    associated with this column or that there is no
                    conceptual row for which this column would be
                    accessible in the MIB view used by the retrieval.  As
                    such, the management station can not issue any
                    management protocol set operations to create an
                    instance of this column.
               
               If the value associated with the status column is
               `notReady', then the management station must first deal with
               all `noSuchInstance' columns, if any.  Having done so, the
               value of the status column becomes `notInService', and we
               proceed to interaction 4.
               
               Interaction 4: Making the Conceptual Row Available
               
               Once the management station is satisfied with the values
               associated with the columns of the conceptual row, it issues
               a management protocol set operation to set the status column
               to `active'.  If the agent has sufficient information to
               make the conceptual row available for use by the managed
               device, the management protocol set operation succeeds (a
               `noError' response is returned).  Otherwise, the management
               protocol set operation fails with an error of
               `inconsistentValue'.
               
                                        NOTE WELL
               
                    A conceptual row having a status column with value
                    `notInService' or `notReady' is unavailable to the
                    managed device.  As such, it is possible for the
                    managed device to create its own instances during the
                    time between the management protocol set operation
                    which sets the status column to `createAndWait' and the
                    management protocol set operation which sets the status
                    column to `active'.  In this case, when the management
                    protocol set operation is issued to set the status
                    column to `active', the values held in the agent
                    supersede those used by the managed device.
               
               If the management station is prevented from setting the
               status column to `active' (e.g., due to management station
               or network failure) the conceptual row will be left in the
               `notInService' or `notReady' state, consuming resources
               indefinitely.  The agent must detect conceptual rows that
               have been in either state for an abnormally long period of
               time and remove them.  It is the responsibility of the
               DESCRIPTION clause of the status column to indicate what an
               abnormally long period of time would be.  This period of
               time should be long enough to allow for human response time
               (including `think time') between the creation of the
               conceptual row and the setting of the status to `active'.
               In the absence of such information in the DESCRIPTION
               clause, it is suggested that this period be approximately 5
               minutes in length.  This removal action applies not only to
               newly-created rows, but also to previously active rows which
               are set to, and left in, the notInService state for a
               prolonged period exceeding that which is considered normal
               for such a conceptual row.
               
                                Conceptual Row Suspension
               
               When a conceptual row is `active', the management station
               may issue a management protocol set operation which sets the
               instance of the status column to `notInService'.  If the
               agent is unwilling to do so, the set operation fails with an
               error of `wrongValue' or `inconsistentValue'.  Otherwise,
               the conceptual row is taken out of service, and a `noError'
               response is returned.  It is the responsibility of the
               DESCRIPTION clause of the status column to indicate under
               what circumstances the status column should be taken out of
               service (e.g., in order for the value of some other column
               of the same conceptual row to be modified).
               
                                 Conceptual Row Deletion
               
               For deletion of conceptual rows, a management protocol set
               operation is issued which sets the instance of the status
               column to `destroy'.  This request may be made regardless of
               the current value of the status column (e.g., it is possible
               to delete conceptual rows which are either `notReady',
               `notInService' or `active'.)  If the operation succeeds,
               then all instances associated with the conceptual row are
               immediately removed.
  Syntax: [UNIVERSAL 2] INTEGER (1 | 2 | 3 | 4 | 5 | 6)
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (1 | 2 | 3 | 4 | 5 | 6)
  Access: read-create
  Status: current
  Description: The row status variable, used according to row
               installation and removal conventions. 
               
               A row entry cannot be modified when the status is 
               marked as active(1).
)<br/>
*/
public void setInetCidrRouteStatus(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _inetCidrRouteStatus = new Integer(obj.getValue());
}
public String getInetCidrRouteStatusStr()
{
    String ret = null;
    if (_inetCidrRouteStatus != null)
    {
        ret = (String) _inetCidrRouteStatusMap.get(_inetCidrRouteStatus);
    }
    return ret;
}
public Integer getInetCidrRouteStatus()
{
    return _inetCidrRouteStatus;
}


private java.net.InetAddress getInetAddress(AsnOctets obj)
{
    java.net.InetAddress iad = null;
    try
    {
        iad = java.net.InetAddress.getByAddress(obj.getBytes());
    }
    catch(java.net.UnknownHostException exc) { }
    return iad;
}


/**
 * Returns if this set of values is invalid.
 */
public boolean isInvalid()
{
    return _invalid;
}


/**
 * Sets _tmpErrorInd, but only once.
 */
private void setTmpErrorIndex(int errind)
{
    if (_tmpErrorInd == -1)
    {
        _tmpErrorInd = errind;
    }
}


public String toString()
{
    StringBuffer buffer = new StringBuffer(getClass().getName());
    buffer.append("[");
    buffer.append("inetCidrRouteIfIndex=").append(_inetCidrRouteIfIndex);
    buffer.append(", inetCidrRouteType=").append(getInetCidrRouteTypeStr());
    buffer.append(", inetCidrRouteProto=").append(getInetCidrRouteProtoStr());
    buffer.append(", inetCidrRouteAge=").append(_inetCidrRouteAge);
    buffer.append(", inetCidrRouteNextHopAS=").append(_inetCidrRouteNextHopAS);
    buffer.append(", inetCidrRouteMetric1=").append(_inetCidrRouteMetric1);
    buffer.append(", inetCidrRouteMetric2=").append(_inetCidrRouteMetric2);
    buffer.append(", inetCidrRouteMetric3=").append(_inetCidrRouteMetric3);
    buffer.append(", inetCidrRouteMetric4=").append(_inetCidrRouteMetric4);
    buffer.append(", inetCidrRouteMetric5=").append(_inetCidrRouteMetric5);
    buffer.append(", inetCidrRouteStatus=").append(getInetCidrRouteStatusStr());
    buffer.append(", invalid=").append(_invalid);
    buffer.append("]");
    return buffer.toString();
}


}

