// NAME
//      $RCSfile: KvmSocket.java,v $
// DESCRIPTION
//      [given below in javadoc format]
// DELTA
//      $Revision: 1.10 $
// CREATED
//      $Date: 2006/01/30 15:50:38 $
// COPYRIGHT
//      Westhawk Ltd
// TO DO
//

/*
 * Copyright (C) 2000 - 2006 by Westhawk Ltd
 * <a href="www.westhawk.co.uk">www.westhawk.co.uk</a>
 *
 * Permission to use, copy, modify, and distribute this software
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that
 * both the copyright notice and this permission notice appear in
 * supporting documentation.
 * This software is provided "as is" without express or implied
 * warranty.
 * author <a href="mailto:snmp@westhawk.co.uk">Tim Panton</a>
 */

package uk.co.westhawk.snmp.net;

import java.io.*;
import java.util.*;
import javax.microedition.io.*;

/**
 * This is a wrapper class around the KVM DatagramConnection.
 * This class is still under development.
 *
 * @author <a href="mailto:snmp@westhawk.co.uk">Tim Panton</a>
 * @version $Revision: 1.10 $ $Date: 2006/01/30 15:50:38 $
 */
public class KvmSocket implements ContextSocketFace 
{
    private String              dgurl;
    private DatagramConnection  soc=null;
    private boolean             haveWrittenPacket = false;
    private String              sendToHostAddr = null;
    private int                 sendToHostPort;


public KvmSocket()
{
}

public void create(int port, String bindAddr) throws IOException
{
    // bindAddr is ignored
    sendToHostPort = port;
    dgurl = "datagram://:"+sendToHostPort;
    try
    {
        soc = (DatagramConnection)Connector.open(dgurl);
    }
    catch (IllegalArgumentException exc)
    {
        String str = "IllegalArgument problem " + exc.getMessage();
        throw (new IOException(str));
    }
    catch (ConnectionNotFoundException exc)
    {
        String str = "ConnectionNotFound problem " + exc.getMessage();
        throw (new IOException(str));
    }
}

public void create(String host, int port, String bindAddr) throws IOException
{
    // bindAddr is ignored
    sendToHostPort = port;
    sendToHostAddr = host;
    dgurl = "datagram://"+sendToHostAddr+":"+sendToHostPort;
    try
    {
        soc = (DatagramConnection)Connector.open(dgurl);
    }
    catch (IllegalArgumentException exc)
    {
        String str = "IllegalArgument problem " + exc.getMessage();
        throw (new IOException(str));
    }
    catch (ConnectionNotFoundException exc)
    {
        String str = "ConnectionNotFound problem " + exc.getMessage();
        throw (new IOException(str));
    }
}

public String getSendToHostAddress()
{
    return sendToHostAddr;
}
public String getReceivedFromHostAddress()
{
    return sendToHostAddr;
}

public String getLocalSocketAddress()
{
    return null;
}

public String getRemoteSocketAddress()
{
    return null;
}

public StreamPortItem receive(int maxRecvSize) throws IOException
{
    StreamPortItem item = null;
    if (soc != null)
    {
        /* kvm fails if recv before send on client datagram connector*/
        while (!haveWrittenPacket) 
        {
            try {Thread.sleep(100);} catch (Exception x) {;}
        }

        byte [] data = new byte[maxRecvSize];
        Datagram p = soc.newDatagram(data, maxRecvSize);
        soc.receive(p);

        // I'm adding this based on some javadoc I've got.
        // I've got no idea what it returns
        String address = p.getAddress();

        ByteArrayInputStream in = null;
        in = new ByteArrayInputStream(p.getData(), 0, p.getLength());
        item = new StreamPortItem(p.getAddress(), -1, in);
        p = null;
    }
    return item;
}

public void send(byte[] packet) throws IOException
{
    if (soc != null)
    {
        haveWrittenPacket = true;
        Datagram pack = soc.newDatagram(packet, packet.length, dgurl);
        soc.send(pack);
    }
}

public void close()
{
    if (soc != null)
    {
        try
        {
            soc.close();
            soc = null;
        }
        catch (IOException exc)
        {
        }
    }
}

}
