// NAME
//      $RCSfile: InstalledSoftwarePdu.java,v $
// DESCRIPTION
//      [given below in javadoc format]
// DELTA
//      $Revision: 1.3 $
// CREATED
//      $Date: 2006/03/23 14:40:58 $
// COPYRIGHT
//      Westhawk Ltd
// TO DO
//

package uk.co.westhawk.examplev1;

import uk.co.westhawk.snmp.stack.*;
import uk.co.westhawk.snmp.pdu.*;
import java.util.*;


/**
 * The class InstalledSoftwarePdu.
 *
 * This file is auto generated by the StubBrowser utility, using Mibble.
 * See the uk/co/westhawk/stub/ directory.
 *
 * Make sure that you replace the package name and classname placeholders. 
 * Also, move this file to the correct package directory.
 * If these things are not done, this class will not compile correctly!!
 *
 * @version $Revision: 1.3 $ $Date: 2006/03/23 14:40:58 $
 */
public class InstalledSoftwarePdu extends GetNextPdu
{
    private static final String version_id =
        "@(#)$Id: InstalledSoftwarePdu.java,v 1.3 2006/03/23 14:40:58 birgit Exp $ Copyright Westhawk Ltd";

    public final static String hrSWInstalledName_OID = "1.3.6.1.2.1.25.6.3.1.2";
    public final static String hrSWInstalledType_OID = "1.3.6.1.2.1.25.6.3.1.4";
    public final static String hrSWInstalledDate_OID = "1.3.6.1.2.1.25.6.3.1.5";

    public final static int NO_SCAL = 0;
    public final static int NO_COL = 3;
    public final static int NO_OID = NO_SCAL + NO_COL;


    public final static String scal_oids[] =
    {
    };

    public final static String col_oids[] =
    {
        hrSWInstalledName_OID,
        hrSWInstalledType_OID,
        hrSWInstalledDate_OID,
    };

    public final static String all_oids[] =
    {
        hrSWInstalledName_OID,
        hrSWInstalledType_OID,
        hrSWInstalledDate_OID,
    };


    protected String _hrSWInstalledName;
    protected java.util.HashMap _hrSWInstalledTypeMap = new java.util.HashMap(4);
    protected Integer _hrSWInstalledType;
    protected java.util.Calendar _hrSWInstalledDate;

    protected boolean _invalid = false;
    protected int _tmpErrorInd = -1;
    protected int _tmpErrorStat = 0;

/**
 * Constructor.
 *
 * @param con The context of the request
 */
public InstalledSoftwarePdu(SnmpContextBasisFace con)
{
    super(con);
    _hrSWInstalledTypeMap.put(new Integer(3), "deviceDriver");
    _hrSWInstalledTypeMap.put(new Integer(1), "unknown");
    _hrSWInstalledTypeMap.put(new Integer(4), "application");
    _hrSWInstalledTypeMap.put(new Integer(2), "operatingSystem");

    _invalid = false;
    _tmpErrorInd = -1;
    _tmpErrorStat = 0;
}

/**
 * Constructor that will send the first request immediately.
 *
 * @param con The context of the request
 * @param o the Observer that will be notified when the answer is
 * received
 */
public InstalledSoftwarePdu(SnmpContextBasisFace con, Observer o)
throws PduException, java.io.IOException
{
    this(con);
    addOids(null);
    if (o != null)
    {
        addObserver(o);
    }
    send();
}


/**
 * The method addOids is the basis for the GetNext functionality.
 *
 * If old is null, it initialises the varbinds from all_oids.
 * If old is not null, it copies the column OIDs from the
 * old InstalledSoftwarePdu object.
 * so the request continues where the previous one left.
 *
 * Note, the scalars and the columns OIDs are handled differently. The
 * scalars are always copied from the original scal_oids, only the
 * column OIDs are copied from the old
 * InstalledSoftwarePdu object.
 */
public void addOids(InstalledSoftwarePdu old)
{
    if (old != null)
    {
        for (int i=0; i<NO_SCAL; i++)
        {
            addOid(scal_oids[i]);
        }
        for (int i=NO_SCAL; i<NO_OID; i++)
        {
            varbind var = (varbind) old.respVarbinds.elementAt(i);
            addOid(var.getOid());
        }
    }
    else
    {
        for (int i=0; i<NO_OID; i++)
        {
            addOid(all_oids[i]);
        }
    }
}


/**
 * This method sets the column index. By doing this, the request will
 * return (only) the row after row index.
 *
 * The index parameters only applies to the column OIDs.
 * The scalars are copied from the original scal_oids.
 */
public void addOids(int index)
{
    for (int i=0; i<NO_SCAL; i++)
    {
        addOid(scal_oids[i]);
    }
    for (int i=0; i<NO_COL; i++)
    {
        addOid(col_oids[i] + "." + index);
    }
}
/**
 * The value of the request is set. This will be called by
 * Pdu.fillin().
 *
 * I check if the variables are still in range.
 * I do this because I'm only interessed in a part of the MIB. If I
 * would not do this check, I'll get the whole MIB from the starting
 * point, instead of the variables in the table.
 *
 * @param n the index of the value
 * @param a_var the value
 * @see Pdu#new_value
 */
protected void new_value(int n, varbind res)
{
    if (getErrorStatus() == AsnObject.SNMP_ERR_NOERROR)
    {
        AsnObjectId oid = res.getOid();
        AsnObject value = res.getValue();

        if (oid.toString().startsWith(all_oids[n]))
        {
            try
            {
                switch (n)
                {
                    case 0:
                        setHrSWInstalledName(value);
                        break;
                    case 1:
                        setHrSWInstalledType(value);
                        break;
                    case 2:
                        setHrSWInstalledDate(value);
                        break;
                    default:
                        _invalid = true;
                        setTmpErrorIndex(n);
                        _tmpErrorStat = SnmpConstants.SNMP_ERR_GENERR;
                }
            }
            catch (ClassCastException exc)
            {
                _invalid = true;
                setTmpErrorIndex(n);
                _tmpErrorStat = SnmpConstants.SNMP_ERR_GENERR;
            }
        }
        else
        {
            _invalid = true;
            setTmpErrorIndex(n);
            _tmpErrorStat = SnmpConstants.SNMP_ERR_NOSUCHNAME;
        }
    }

    if (n >= NO_OID-1)
    {
        if (_invalid == true)
        {
            setErrorStatus(_tmpErrorStat);
            setErrorIndex(_tmpErrorInd);
        }
    }
}


/**
hrSWInstalledName<br/>
TYPE InternationalDisplayString ::= TEXTUAL-CONVENTION (
  Status: current
  Description: This data type is used to model textual information
               in some character set.  A network management station
               should use a local algorithm to determine which
               character set is in use and how it should be
               displayed.  Note that this character set may be
               encoded with more than one octet per symbol, but will
               most often be NVT ASCII. When a size clause is
               specified for an object of this type, the size refers
               to the length in octets, not the number of symbols.
  Syntax: [UNIVERSAL 4] OCTET STRING
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..64))
  Access: read-only
  Status: current
  Description: A textual description of this installed piece of
               software, including the manufacturer, revision, the
               name by which it is commonly known, and optionally,
               its serial number.
)<br/>
*/
public void setHrSWInstalledName(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _hrSWInstalledName = obj.toDisplayString();
}
public String getHrSWInstalledName()
{
    return _hrSWInstalledName;
}


/**
hrSWInstalledType<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (1 | 2 | 3 | 4)
  Access: read-only
  Status: current
  Description: The type of this software.
)<br/>
*/
public void setHrSWInstalledType(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _hrSWInstalledType = new Integer(obj.getValue());
}
public String getHrSWInstalledTypeStr()
{
    String ret = null;
    if (_hrSWInstalledType != null)
    {
        ret = (String) _hrSWInstalledTypeMap.get(_hrSWInstalledType);
    }
    return ret;
}
public Integer getHrSWInstalledType()
{
    return _hrSWInstalledType;
}


/**
hrSWInstalledDate<br/>
TYPE DateAndTime ::= TEXTUAL-CONVENTION (
  Display-Hint: 2d-1d-1d,1d:1d:1d.1d,1a1d:1d
  Status: current
  Description: A date-time specification.
               
               field  octets  contents                  range
               -----  ------  --------                  -----
                 1      1-2   year*                     0..65536
                 2       3    month                     1..12
                 3       4    day                       1..31
                 4       5    hour                      0..23
                 5       6    minutes                   0..59
                 6       7    seconds                   0..60
                              (use 60 for leap-second)
                 7       8    deci-seconds              0..9
                 8       9    direction from UTC        '+' / '-'
                 9      10    hours from UTC*           0..13
                10      11    minutes from UTC          0..59
               
               * Notes:
               - the value of year is in network-byte order
               - daylight saving time in New Zealand is +13
               
               For example, Tuesday May 26, 1992 at 1:30:15 PM EDT would be
               displayed as:
               
                                1992-5-26,13:30:15.0,-4:0
               
               Note that if only local time is known, then timezone
               information (fields 8-10) is not present.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (8 | 11))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (8 | 11))
  Access: read-only
  Status: current
  Description: The last-modification date of this application as it
               would appear in a directory listing.
               
               If this information is not known, then this variable
               shall have the value corresponding to January 1, year
               0000, 00:00:00.0, which is encoded as
               (hex)'00 00 01 01 00 00 00 00'.
)<br/>
*/
public void setHrSWInstalledDate(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _hrSWInstalledDate = obj.getCalendar();
}
public java.util.Calendar getHrSWInstalledDate()
{
    return _hrSWInstalledDate;
}


private java.net.InetAddress getInetAddress(AsnOctets obj)
{
    java.net.InetAddress iad = null;
    try
    {
        iad = java.net.InetAddress.getByAddress(obj.getBytes());
    }
    catch(java.net.UnknownHostException exc) { }
    return iad;
}


/**
 * Returns if this set of values is invalid.
 */
public boolean isInvalid()
{
    return _invalid;
}


/**
 * Sets _tmpErrorInd, but only once.
 */
private void setTmpErrorIndex(int errind)
{
    if (_tmpErrorInd == -1)
    {
        _tmpErrorInd = errind;
    }
}


public String toString()
{
    StringBuffer buffer = new StringBuffer(getClass().getName());
    buffer.append("[");
    buffer.append("hrSWInstalledName=").append(_hrSWInstalledName);
    buffer.append(", hrSWInstalledType=").append(getHrSWInstalledTypeStr());
    buffer.append(", hrSWInstalledDate=").append(AsnOctets.CALFORMAT.format(_hrSWInstalledDate.getTime()));
    buffer.append(", invalid=").append(_invalid);
    buffer.append("]");
    return buffer.toString();
}


}

