// NAME
//      $RCSfile: AsteriskChanTablePdu.java,v $
// DESCRIPTION
//      [given below in javadoc format]
// DELTA
//      $Revision: 1.1 $
// CREATED
//      $Date: 2006/03/23 13:44:57 $
// COPYRIGHT
//      Westhawk Ltd
// TO DO
//

package uk.co.westhawk.examplev2c;

import uk.co.westhawk.snmp.stack.*;
import uk.co.westhawk.snmp.pdu.*;
import java.util.*;


/**
 * The class AsteriskChanTablePdu.
 *
 * This file is auto generated by the StubBrowser utility, using Mibble.
 * See the uk/co/westhawk/stub/ directory.
 *
 * Make sure that you replace the package name and classname placeholders. 
 * Also, move this file to the correct package directory.
 * If these things are not done, this class will not compile correctly!!
 *
 * @version $Revision: 1.1 $ $Date: 2006/03/23 13:44:57 $
 */
public class AsteriskChanTablePdu extends GetNextPdu
{
    private static final String version_id =
        "@(#)$Id: AsteriskChanTablePdu.java,v 1.1 2006/03/23 13:44:57 birgit Exp $ Copyright Westhawk Ltd";

    public final static String astNumChannels_OID = "1.3.6.1.4.1.22736.1.5.1";
    public final static String astChanIndex_OID = "1.3.6.1.4.1.22736.1.5.2.1.1";
    public final static String astChanName_OID = "1.3.6.1.4.1.22736.1.5.2.1.2";
    public final static String astChanLanguage_OID = "1.3.6.1.4.1.22736.1.5.2.1.3";
    public final static String astChanType_OID = "1.3.6.1.4.1.22736.1.5.2.1.4";
    public final static String astChanMusicClass_OID = "1.3.6.1.4.1.22736.1.5.2.1.5";
    public final static String astChanBridge_OID = "1.3.6.1.4.1.22736.1.5.2.1.6";
    public final static String astChanMasq_OID = "1.3.6.1.4.1.22736.1.5.2.1.7";
    public final static String astChanMasqr_OID = "1.3.6.1.4.1.22736.1.5.2.1.8";
    public final static String astChanWhenHangup_OID = "1.3.6.1.4.1.22736.1.5.2.1.9";
    public final static String astChanApp_OID = "1.3.6.1.4.1.22736.1.5.2.1.10";
    public final static String astChanData_OID = "1.3.6.1.4.1.22736.1.5.2.1.11";
    public final static String astChanContext_OID = "1.3.6.1.4.1.22736.1.5.2.1.12";
    public final static String astChanMacroContext_OID = "1.3.6.1.4.1.22736.1.5.2.1.13";
    public final static String astChanMacroExten_OID = "1.3.6.1.4.1.22736.1.5.2.1.14";
    public final static String astChanMacroPri_OID = "1.3.6.1.4.1.22736.1.5.2.1.15";
    public final static String astChanExten_OID = "1.3.6.1.4.1.22736.1.5.2.1.16";
    public final static String astChanPri_OID = "1.3.6.1.4.1.22736.1.5.2.1.17";
    public final static String astChanAccountCode_OID = "1.3.6.1.4.1.22736.1.5.2.1.18";
    public final static String astChanForwardTo_OID = "1.3.6.1.4.1.22736.1.5.2.1.19";
    public final static String astChanUniqueId_OID = "1.3.6.1.4.1.22736.1.5.2.1.20";
    public final static String astChanCallGroup_OID = "1.3.6.1.4.1.22736.1.5.2.1.21";
    public final static String astChanPickupGroup_OID = "1.3.6.1.4.1.22736.1.5.2.1.22";
    public final static String astChanState_OID = "1.3.6.1.4.1.22736.1.5.2.1.23";
    public final static String astChanMuted_OID = "1.3.6.1.4.1.22736.1.5.2.1.24";
    public final static String astChanRings_OID = "1.3.6.1.4.1.22736.1.5.2.1.25";
    public final static String astChanCidDNID_OID = "1.3.6.1.4.1.22736.1.5.2.1.26";
    public final static String astChanCidNum_OID = "1.3.6.1.4.1.22736.1.5.2.1.27";
    public final static String astChanCidName_OID = "1.3.6.1.4.1.22736.1.5.2.1.28";
    public final static String astCanCidANI_OID = "1.3.6.1.4.1.22736.1.5.2.1.29";
    public final static String astChanCidRDNIS_OID = "1.3.6.1.4.1.22736.1.5.2.1.30";
    public final static String astChanCidPresentation_OID = "1.3.6.1.4.1.22736.1.5.2.1.31";
    public final static String astChanCidANI2_OID = "1.3.6.1.4.1.22736.1.5.2.1.32";
    public final static String astChanCidTON_OID = "1.3.6.1.4.1.22736.1.5.2.1.33";
    public final static String astChanCidTNS_OID = "1.3.6.1.4.1.22736.1.5.2.1.34";
    public final static String astChanAMAFlags_OID = "1.3.6.1.4.1.22736.1.5.2.1.35";
    public final static String astChanADSI_OID = "1.3.6.1.4.1.22736.1.5.2.1.36";
    public final static String astChanToneZone_OID = "1.3.6.1.4.1.22736.1.5.2.1.37";
    public final static String astChanHangupCause_OID = "1.3.6.1.4.1.22736.1.5.2.1.38";
    public final static String astChanVariables_OID = "1.3.6.1.4.1.22736.1.5.2.1.39";
    public final static String astChanFlags_OID = "1.3.6.1.4.1.22736.1.5.2.1.40";
    public final static String astChanTransferCap_OID = "1.3.6.1.4.1.22736.1.5.2.1.41";

    public final static int NO_SCAL = 1;
    public final static int NO_COL = 41;
    public final static int NO_OID = NO_SCAL + NO_COL;


    public final static String scal_oids[] =
    {
        astNumChannels_OID,
    };

    public final static String col_oids[] =
    {
        astChanIndex_OID,
        astChanName_OID,
        astChanLanguage_OID,
        astChanType_OID,
        astChanMusicClass_OID,
        astChanBridge_OID,
        astChanMasq_OID,
        astChanMasqr_OID,
        astChanWhenHangup_OID,
        astChanApp_OID,
        astChanData_OID,
        astChanContext_OID,
        astChanMacroContext_OID,
        astChanMacroExten_OID,
        astChanMacroPri_OID,
        astChanExten_OID,
        astChanPri_OID,
        astChanAccountCode_OID,
        astChanForwardTo_OID,
        astChanUniqueId_OID,
        astChanCallGroup_OID,
        astChanPickupGroup_OID,
        astChanState_OID,
        astChanMuted_OID,
        astChanRings_OID,
        astChanCidDNID_OID,
        astChanCidNum_OID,
        astChanCidName_OID,
        astCanCidANI_OID,
        astChanCidRDNIS_OID,
        astChanCidPresentation_OID,
        astChanCidANI2_OID,
        astChanCidTON_OID,
        astChanCidTNS_OID,
        astChanAMAFlags_OID,
        astChanADSI_OID,
        astChanToneZone_OID,
        astChanHangupCause_OID,
        astChanVariables_OID,
        astChanFlags_OID,
        astChanTransferCap_OID,
    };

    public final static String all_oids[] =
    {
        astNumChannels_OID,
        astChanIndex_OID,
        astChanName_OID,
        astChanLanguage_OID,
        astChanType_OID,
        astChanMusicClass_OID,
        astChanBridge_OID,
        astChanMasq_OID,
        astChanMasqr_OID,
        astChanWhenHangup_OID,
        astChanApp_OID,
        astChanData_OID,
        astChanContext_OID,
        astChanMacroContext_OID,
        astChanMacroExten_OID,
        astChanMacroPri_OID,
        astChanExten_OID,
        astChanPri_OID,
        astChanAccountCode_OID,
        astChanForwardTo_OID,
        astChanUniqueId_OID,
        astChanCallGroup_OID,
        astChanPickupGroup_OID,
        astChanState_OID,
        astChanMuted_OID,
        astChanRings_OID,
        astChanCidDNID_OID,
        astChanCidNum_OID,
        astChanCidName_OID,
        astCanCidANI_OID,
        astChanCidRDNIS_OID,
        astChanCidPresentation_OID,
        astChanCidANI2_OID,
        astChanCidTON_OID,
        astChanCidTNS_OID,
        astChanAMAFlags_OID,
        astChanADSI_OID,
        astChanToneZone_OID,
        astChanHangupCause_OID,
        astChanVariables_OID,
        astChanFlags_OID,
        astChanTransferCap_OID,
    };


    protected Integer _astNumChannels;
    protected Integer _astChanIndex;
    protected String _astChanName;
    protected String _astChanLanguage;
    protected String _astChanType;
    protected String _astChanMusicClass;
    protected String _astChanBridge;
    protected String _astChanMasq;
    protected String _astChanMasqr;
    protected Long _astChanWhenHangup;
    protected String _astChanApp;
    protected String _astChanData;
    protected String _astChanContext;
    protected String _astChanMacroContext;
    protected String _astChanMacroExten;
    protected Integer _astChanMacroPri;
    protected String _astChanExten;
    protected Integer _astChanPri;
    protected String _astChanAccountCode;
    protected String _astChanForwardTo;
    protected String _astChanUniqueId;
    protected Long _astChanCallGroup;
    protected Long _astChanPickupGroup;
    protected java.util.HashMap _astChanStateMap = new java.util.HashMap(10);
    protected Integer _astChanState;
    protected java.util.HashMap _astChanMutedMap = new java.util.HashMap(2);
    protected Integer _astChanMuted;
    protected Integer _astChanRings;
    protected String _astChanCidDNID;
    protected String _astChanCidNum;
    protected String _astChanCidName;
    protected String _astCanCidANI;
    protected String _astChanCidRDNIS;
    protected String _astChanCidPresentation;
    protected Integer _astChanCidANI2;
    protected Integer _astChanCidTON;
    protected Integer _astChanCidTNS;
    protected java.util.HashMap _astChanAMAFlagsMap = new java.util.HashMap(4);
    protected Integer _astChanAMAFlags;
    protected java.util.HashMap _astChanADSIMap = new java.util.HashMap(4);
    protected Integer _astChanADSI;
    protected String _astChanToneZone;
    protected java.util.HashMap _astChanHangupCauseMap = new java.util.HashMap(8);
    protected Integer _astChanHangupCause;
    protected String _astChanVariables;
    protected java.util.HashMap _astChanFlagsMap = new java.util.HashMap(10);
    protected byte[] _astChanFlags;
    protected java.util.HashMap _astChanTransferCapMap = new java.util.HashMap(6);
    protected Integer _astChanTransferCap;

    protected boolean _invalid = false;
    protected int _tmpErrorInd = -1;
    protected int _tmpErrorStat = 0;

/**
 * Constructor.
 *
 * @param con The context of the request
 */
public AsteriskChanTablePdu(SnmpContextBasisFace con)
{
    super(con);
    _astChanStateMap.put(new Integer(3), "stateDialing");
    _astChanStateMap.put(new Integer(2), "stateOffHook");
    _astChanStateMap.put(new Integer(9), "statePreRing");
    _astChanStateMap.put(new Integer(8), "stateDialingOffHook");
    _astChanStateMap.put(new Integer(7), "stateBusy");
    _astChanStateMap.put(new Integer(4), "stateRing");
    _astChanStateMap.put(new Integer(0), "stateDown");
    _astChanStateMap.put(new Integer(1), "stateReserved");
    _astChanStateMap.put(new Integer(6), "stateUp");
    _astChanStateMap.put(new Integer(5), "stateRinging");

    _astChanMutedMap.put(new Integer(1), "true");
    _astChanMutedMap.put(new Integer(2), "false");

    _astChanAMAFlagsMap.put(new Integer(2), "Billing");
    _astChanAMAFlagsMap.put(new Integer(3), "Documentation");
    _astChanAMAFlagsMap.put(new Integer(0), "Default");
    _astChanAMAFlagsMap.put(new Integer(1), "Omit");

    _astChanADSIMap.put(new Integer(0), "Unknown");
    _astChanADSIMap.put(new Integer(3), "OffHookOnly");
    _astChanADSIMap.put(new Integer(1), "Available");
    _astChanADSIMap.put(new Integer(2), "Unavailable");

    _astChanHangupCauseMap.put(new Integer(38), "Failure");
    _astChanHangupCauseMap.put(new Integer(66), "NoSuchDriver");
    _astChanHangupCauseMap.put(new Integer(0), "NotDefined");
    _astChanHangupCauseMap.put(new Integer(17), "Busy");
    _astChanHangupCauseMap.put(new Integer(34), "Congestion");
    _astChanHangupCauseMap.put(new Integer(19), "NoAnswer");
    _astChanHangupCauseMap.put(new Integer(3), "Unregistered");
    _astChanHangupCauseMap.put(new Integer(16), "Normal");

    _astChanFlagsMap.put(new Integer(5), "Exception");
    _astChanFlagsMap.put(new Integer(4), "Zombie");
    _astChanFlagsMap.put(new Integer(1), "DeferDTMF");
    _astChanFlagsMap.put(new Integer(6), "MusicOnHold");
    _astChanFlagsMap.put(new Integer(3), "Blocking");
    _astChanFlagsMap.put(new Integer(9), "AutoIncrementingLoop");
    _astChanFlagsMap.put(new Integer(7), "Spying");
    _astChanFlagsMap.put(new Integer(2), "WriteInterrupt");
    _astChanFlagsMap.put(new Integer(0), "WantsJitter");
    _astChanFlagsMap.put(new Integer(8), "NativeBridge");

    _astChanTransferCapMap.put(new Integer(24), "Video");
    _astChanTransferCapMap.put(new Integer(9), "RestrictedDigital");
    _astChanTransferCapMap.put(new Integer(8), "Digital");
    _astChanTransferCapMap.put(new Integer(16), "ThreeKAudio");
    _astChanTransferCapMap.put(new Integer(17), "DigitalWithTones");
    _astChanTransferCapMap.put(new Integer(0), "Speech");

    _invalid = false;
    _tmpErrorInd = -1;
    _tmpErrorStat = 0;
}

/**
 * Constructor that will send the first request immediately.
 *
 * @param con The context of the request
 * @param o the Observer that will be notified when the answer is
 * received
 */
public AsteriskChanTablePdu(SnmpContextBasisFace con, Observer o)
throws PduException, java.io.IOException
{
    this(con);
    addOids(null);
    if (o != null)
    {
        addObserver(o);
    }
    send();
}


/**
 * The method addOids is the basis for the GetNext functionality.
 *
 * If old is null, it initialises the varbinds from all_oids.
 * If old is not null, it copies the column OIDs from the
 * old AsteriskChanTablePdu object.
 * so the request continues where the previous one left.
 *
 * Note, the scalars and the columns OIDs are handled differently. The
 * scalars are always copied from the original scal_oids, only the
 * column OIDs are copied from the old
 * AsteriskChanTablePdu object.
 */
public void addOids(AsteriskChanTablePdu old)
{
    if (old != null)
    {
        for (int i=0; i<NO_SCAL; i++)
        {
            addOid(scal_oids[i]);
        }
        for (int i=NO_SCAL; i<NO_OID; i++)
        {
            varbind var = (varbind) old.respVarbinds.elementAt(i);
            addOid(var.getOid());
        }
    }
    else
    {
        for (int i=0; i<NO_OID; i++)
        {
            addOid(all_oids[i]);
        }
    }
}


/**
 * This method sets the column index. By doing this, the request will
 * return (only) the row after row index.
 *
 * The index parameters only applies to the column OIDs.
 * The scalars are copied from the original scal_oids.
 */
public void addOids(int index)
{
    for (int i=0; i<NO_SCAL; i++)
    {
        addOid(scal_oids[i]);
    }
    for (int i=0; i<NO_COL; i++)
    {
        addOid(col_oids[i] + "." + index);
    }
}
/**
 * The value of the request is set. This will be called by
 * Pdu.fillin().
 *
 * I check if the variables are still in range.
 * I do this because I'm only interessed in a part of the MIB. If I
 * would not do this check, I'll get the whole MIB from the starting
 * point, instead of the variables in the table.
 *
 * @param n the index of the value
 * @param a_var the value
 * @see Pdu#new_value
 */
protected void new_value(int n, varbind res)
{
    if (getErrorStatus() == AsnObject.SNMP_ERR_NOERROR)
    {
        AsnObjectId oid = res.getOid();
        AsnObject value = res.getValue();

        if (oid.toString().startsWith(all_oids[n]))
        {
            try
            {
                switch (n)
                {
                    case 0:
                        setAstNumChannels(value);
                        break;
                    case 1:
                        setAstChanIndex(value);
                        break;
                    case 2:
                        setAstChanName(value);
                        break;
                    case 3:
                        setAstChanLanguage(value);
                        break;
                    case 4:
                        setAstChanType(value);
                        break;
                    case 5:
                        setAstChanMusicClass(value);
                        break;
                    case 6:
                        setAstChanBridge(value);
                        break;
                    case 7:
                        setAstChanMasq(value);
                        break;
                    case 8:
                        setAstChanMasqr(value);
                        break;
                    case 9:
                        setAstChanWhenHangup(value);
                        break;
                    case 10:
                        setAstChanApp(value);
                        break;
                    case 11:
                        setAstChanData(value);
                        break;
                    case 12:
                        setAstChanContext(value);
                        break;
                    case 13:
                        setAstChanMacroContext(value);
                        break;
                    case 14:
                        setAstChanMacroExten(value);
                        break;
                    case 15:
                        setAstChanMacroPri(value);
                        break;
                    case 16:
                        setAstChanExten(value);
                        break;
                    case 17:
                        setAstChanPri(value);
                        break;
                    case 18:
                        setAstChanAccountCode(value);
                        break;
                    case 19:
                        setAstChanForwardTo(value);
                        break;
                    case 20:
                        setAstChanUniqueId(value);
                        break;
                    case 21:
                        setAstChanCallGroup(value);
                        break;
                    case 22:
                        setAstChanPickupGroup(value);
                        break;
                    case 23:
                        setAstChanState(value);
                        break;
                    case 24:
                        setAstChanMuted(value);
                        break;
                    case 25:
                        setAstChanRings(value);
                        break;
                    case 26:
                        setAstChanCidDNID(value);
                        break;
                    case 27:
                        setAstChanCidNum(value);
                        break;
                    case 28:
                        setAstChanCidName(value);
                        break;
                    case 29:
                        setAstCanCidANI(value);
                        break;
                    case 30:
                        setAstChanCidRDNIS(value);
                        break;
                    case 31:
                        setAstChanCidPresentation(value);
                        break;
                    case 32:
                        setAstChanCidANI2(value);
                        break;
                    case 33:
                        setAstChanCidTON(value);
                        break;
                    case 34:
                        setAstChanCidTNS(value);
                        break;
                    case 35:
                        setAstChanAMAFlags(value);
                        break;
                    case 36:
                        setAstChanADSI(value);
                        break;
                    case 37:
                        setAstChanToneZone(value);
                        break;
                    case 38:
                        setAstChanHangupCause(value);
                        break;
                    case 39:
                        setAstChanVariables(value);
                        break;
                    case 40:
                        setAstChanFlags(value);
                        break;
                    case 41:
                        setAstChanTransferCap(value);
                        break;
                    default:
                        _invalid = true;
                        setTmpErrorIndex(n);
                        _tmpErrorStat = SnmpConstants.SNMP_ERR_GENERR;
                }
            }
            catch (ClassCastException exc)
            {
                _invalid = true;
                setTmpErrorIndex(n);
                _tmpErrorStat = SnmpConstants.SNMP_ERR_GENERR;
            }
        }
        else
        {
            _invalid = true;
            setTmpErrorIndex(n);
            _tmpErrorStat = SnmpConstants.SNMP_ERR_NOSUCHNAME;
        }
    }

    if (n >= NO_OID-1)
    {
        if (_invalid == true)
        {
            setErrorStatus(_tmpErrorStat);
            setErrorIndex(_tmpErrorInd);
        }
    }
}


/**
astNumChannels<br/>
TYPE Integer32 ::= [UNIVERSAL 2] INTEGER (-2147483648..2147483647)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (-2147483648..2147483647)
  Access: read-only
  Status: current
  Description: Current number of active channels.
)<br/>
*/
public void setAstNumChannels(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astNumChannels = new Integer(obj.getValue());
}
public Integer getAstNumChannels()
{
    return _astNumChannels;
}


/**
astChanIndex<br/>
TYPE Integer32 ::= [UNIVERSAL 2] INTEGER (-2147483648..2147483647)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (-2147483648..2147483647)
  Access: read-only
  Status: current
  Description: Index into the channel table.
)<br/>
*/
public void setAstChanIndex(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astChanIndex = new Integer(obj.getValue());
}
public Integer getAstChanIndex()
{
    return _astChanIndex;
}


/**
astChanName<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Name of the currentl channel.
)<br/>
*/
public void setAstChanName(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanName = obj.toDisplayString();
}
public String getAstChanName()
{
    return _astChanName;
}


/**
astChanLanguage<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Which language the current channel is configured to
               use -- used mainly for prompts.
)<br/>
*/
public void setAstChanLanguage(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanLanguage = obj.toDisplayString();
}
public String getAstChanLanguage()
{
    return _astChanLanguage;
}


/**
astChanType<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Underlying technology for the current channel.
)<br/>
*/
public void setAstChanType(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanType = obj.toDisplayString();
}
public String getAstChanType()
{
    return _astChanType;
}


/**
astChanMusicClass<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Music class to be used for Music on Hold for this
               channel.
)<br/>
*/
public void setAstChanMusicClass(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanMusicClass = obj.toDisplayString();
}
public String getAstChanMusicClass()
{
    return _astChanMusicClass;
}


/**
astChanBridge<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Which channel this channel is currently bridged (in a
               conversation) with.
)<br/>
*/
public void setAstChanBridge(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanBridge = obj.toDisplayString();
}
public String getAstChanBridge()
{
    return _astChanBridge;
}


/**
astChanMasq<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Channel masquerading for us.
)<br/>
*/
public void setAstChanMasq(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanMasq = obj.toDisplayString();
}
public String getAstChanMasq()
{
    return _astChanMasq;
}


/**
astChanMasqr<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Channel we are masquerading for.
)<br/>
*/
public void setAstChanMasqr(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanMasqr = obj.toDisplayString();
}
public String getAstChanMasqr()
{
    return _astChanMasqr;
}


/**
astChanWhenHangup<br/>
TYPE TimeTicks ::= [APPLICATION 3] INTEGER (0..4294967295)<br/>
OBJECT-TYPE (
  Syntax: [APPLICATION 3] INTEGER (0..4294967295)
  Access: read-only
  Status: current
  Description: How long until this channel will be hung up.
)<br/>
*/
public void setAstChanWhenHangup(AsnObject new_value)
{
    AsnUnsInteger obj = (AsnUnsInteger) new_value;
    _astChanWhenHangup = new Long(obj.getValue());
}
public Long getAstChanWhenHangup()
{
    return _astChanWhenHangup;
}


/**
astChanApp<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Current application for the channel.
)<br/>
*/
public void setAstChanApp(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanApp = obj.toDisplayString();
}
public String getAstChanApp()
{
    return _astChanApp;
}


/**
astChanData<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Arguments passed to the current application.
)<br/>
*/
public void setAstChanData(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanData = obj.toDisplayString();
}
public String getAstChanData()
{
    return _astChanData;
}


/**
astChanContext<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Current extension context.
)<br/>
*/
public void setAstChanContext(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanContext = obj.toDisplayString();
}
public String getAstChanContext()
{
    return _astChanContext;
}


/**
astChanMacroContext<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Current macro context.
)<br/>
*/
public void setAstChanMacroContext(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanMacroContext = obj.toDisplayString();
}
public String getAstChanMacroContext()
{
    return _astChanMacroContext;
}


/**
astChanMacroExten<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Current macro extension.
)<br/>
*/
public void setAstChanMacroExten(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanMacroExten = obj.toDisplayString();
}
public String getAstChanMacroExten()
{
    return _astChanMacroExten;
}


/**
astChanMacroPri<br/>
TYPE Integer32 ::= [UNIVERSAL 2] INTEGER (-2147483648..2147483647)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (-2147483648..2147483647)
  Access: read-only
  Status: current
  Description: Current macro priority.
)<br/>
*/
public void setAstChanMacroPri(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astChanMacroPri = new Integer(obj.getValue());
}
public Integer getAstChanMacroPri()
{
    return _astChanMacroPri;
}


/**
astChanExten<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Current extension.
)<br/>
*/
public void setAstChanExten(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanExten = obj.toDisplayString();
}
public String getAstChanExten()
{
    return _astChanExten;
}


/**
astChanPri<br/>
TYPE Integer32 ::= [UNIVERSAL 2] INTEGER (-2147483648..2147483647)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (-2147483648..2147483647)
  Access: read-only
  Status: current
  Description: Current priority.
)<br/>
*/
public void setAstChanPri(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astChanPri = new Integer(obj.getValue());
}
public Integer getAstChanPri()
{
    return _astChanPri;
}


/**
astChanAccountCode<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Account Code for billing.
)<br/>
*/
public void setAstChanAccountCode(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanAccountCode = obj.toDisplayString();
}
public String getAstChanAccountCode()
{
    return _astChanAccountCode;
}


/**
astChanForwardTo<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Where to forward to if asked to dial on this
               interface.
)<br/>
*/
public void setAstChanForwardTo(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanForwardTo = obj.toDisplayString();
}
public String getAstChanForwardTo()
{
    return _astChanForwardTo;
}


/**
astChanUniqueId<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Unique Channel Identifier.
)<br/>
*/
public void setAstChanUniqueId(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanUniqueId = obj.toDisplayString();
}
public String getAstChanUniqueId()
{
    return _astChanUniqueId;
}


/**
astChanCallGroup<br/>
TYPE Unsigned32 ::= [APPLICATION 2] INTEGER (0..4294967295)<br/>
OBJECT-TYPE (
  Syntax: [APPLICATION 2] INTEGER (0..4294967295)
  Access: read-only
  Status: current
  Description: Call Group.
)<br/>
*/
public void setAstChanCallGroup(AsnObject new_value)
{
    AsnUnsInteger obj = (AsnUnsInteger) new_value;
    _astChanCallGroup = new Long(obj.getValue());
}
public Long getAstChanCallGroup()
{
    return _astChanCallGroup;
}


/**
astChanPickupGroup<br/>
TYPE Unsigned32 ::= [APPLICATION 2] INTEGER (0..4294967295)<br/>
OBJECT-TYPE (
  Syntax: [APPLICATION 2] INTEGER (0..4294967295)
  Access: read-only
  Status: current
  Description: Pickup Group.
)<br/>
*/
public void setAstChanPickupGroup(AsnObject new_value)
{
    AsnUnsInteger obj = (AsnUnsInteger) new_value;
    _astChanPickupGroup = new Long(obj.getValue());
}
public Long getAstChanPickupGroup()
{
    return _astChanPickupGroup;
}


/**
astChanState<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9)
  Access: read-only
  Status: current
  Description: Channel state.
)<br/>
*/
public void setAstChanState(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astChanState = new Integer(obj.getValue());
}
public String getAstChanStateStr()
{
    String ret = null;
    if (_astChanState != null)
    {
        ret = (String) _astChanStateMap.get(_astChanState);
    }
    return ret;
}
public Integer getAstChanState()
{
    return _astChanState;
}


/**
astChanMuted<br/>
TYPE TruthValue ::= TEXTUAL-CONVENTION (
  Status: current
  Description: Represents a boolean value.
  Syntax: [UNIVERSAL 2] INTEGER (1 | 2)
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (1 | 2)
  Access: read-only
  Status: current
  Description: Transmission of voice data has been muted.
)<br/>
*/
public void setAstChanMuted(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astChanMuted = new Integer(obj.getValue());
}
public String getAstChanMutedStr()
{
    String ret = null;
    if (_astChanMuted != null)
    {
        ret = (String) _astChanMutedMap.get(_astChanMuted);
    }
    return ret;
}
public Integer getAstChanMuted()
{
    return _astChanMuted;
}


/**
astChanRings<br/>
TYPE Integer32 ::= [UNIVERSAL 2] INTEGER (-2147483648..2147483647)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (-2147483648..2147483647)
  Access: read-only
  Status: current
  Description: Number of rings so far.
)<br/>
*/
public void setAstChanRings(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astChanRings = new Integer(obj.getValue());
}
public Integer getAstChanRings()
{
    return _astChanRings;
}


/**
astChanCidDNID<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Dialled Number ID.
)<br/>
*/
public void setAstChanCidDNID(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanCidDNID = obj.toDisplayString();
}
public String getAstChanCidDNID()
{
    return _astChanCidDNID;
}


/**
astChanCidNum<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Caller Number.
)<br/>
*/
public void setAstChanCidNum(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanCidNum = obj.toDisplayString();
}
public String getAstChanCidNum()
{
    return _astChanCidNum;
}


/**
astChanCidName<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Caller Name.
)<br/>
*/
public void setAstChanCidName(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanCidName = obj.toDisplayString();
}
public String getAstChanCidName()
{
    return _astChanCidName;
}


/**
astCanCidANI<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: ANI
)<br/>
*/
public void setAstCanCidANI(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astCanCidANI = obj.toDisplayString();
}
public String getAstCanCidANI()
{
    return _astCanCidANI;
}


/**
astChanCidRDNIS<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Redirected Dialled Number Service.
)<br/>
*/
public void setAstChanCidRDNIS(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanCidRDNIS = obj.toDisplayString();
}
public String getAstChanCidRDNIS()
{
    return _astChanCidRDNIS;
}


/**
astChanCidPresentation<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Number Presentation/Screening.
)<br/>
*/
public void setAstChanCidPresentation(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanCidPresentation = obj.toDisplayString();
}
public String getAstChanCidPresentation()
{
    return _astChanCidPresentation;
}


/**
astChanCidANI2<br/>
TYPE Integer32 ::= [UNIVERSAL 2] INTEGER (-2147483648..2147483647)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (-2147483648..2147483647)
  Access: read-only
  Status: current
  Description: ANI 2 (info digit).
)<br/>
*/
public void setAstChanCidANI2(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astChanCidANI2 = new Integer(obj.getValue());
}
public Integer getAstChanCidANI2()
{
    return _astChanCidANI2;
}


/**
astChanCidTON<br/>
TYPE Integer32 ::= [UNIVERSAL 2] INTEGER (-2147483648..2147483647)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (-2147483648..2147483647)
  Access: read-only
  Status: current
  Description: Type of Number.
)<br/>
*/
public void setAstChanCidTON(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astChanCidTON = new Integer(obj.getValue());
}
public Integer getAstChanCidTON()
{
    return _astChanCidTON;
}


/**
astChanCidTNS<br/>
TYPE Integer32 ::= [UNIVERSAL 2] INTEGER (-2147483648..2147483647)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (-2147483648..2147483647)
  Access: read-only
  Status: current
  Description: Transit Network Select.
)<br/>
*/
public void setAstChanCidTNS(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astChanCidTNS = new Integer(obj.getValue());
}
public Integer getAstChanCidTNS()
{
    return _astChanCidTNS;
}


/**
astChanAMAFlags<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (0 | 1 | 2 | 3)
  Access: read-only
  Status: current
  Description: AMA Flags.
)<br/>
*/
public void setAstChanAMAFlags(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astChanAMAFlags = new Integer(obj.getValue());
}
public String getAstChanAMAFlagsStr()
{
    String ret = null;
    if (_astChanAMAFlags != null)
    {
        ret = (String) _astChanAMAFlagsMap.get(_astChanAMAFlags);
    }
    return ret;
}
public Integer getAstChanAMAFlags()
{
    return _astChanAMAFlags;
}


/**
astChanADSI<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (0 | 1 | 2 | 3)
  Access: read-only
  Status: current
  Description: Whether or not ADSI is detected on CPE.
)<br/>
*/
public void setAstChanADSI(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astChanADSI = new Integer(obj.getValue());
}
public String getAstChanADSIStr()
{
    String ret = null;
    if (_astChanADSI != null)
    {
        ret = (String) _astChanADSIMap.get(_astChanADSI);
    }
    return ret;
}
public Integer getAstChanADSI()
{
    return _astChanADSI;
}


/**
astChanToneZone<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Indication zone to use for channel.
)<br/>
*/
public void setAstChanToneZone(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanToneZone = obj.toDisplayString();
}
public String getAstChanToneZone()
{
    return _astChanToneZone;
}


/**
astChanHangupCause<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (0 | 3 | 16 | 17 | 19 | 34 | 38 | 66)
  Access: read-only
  Status: current
  Description: Why is the channel hung up.
)<br/>
*/
public void setAstChanHangupCause(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astChanHangupCause = new Integer(obj.getValue());
}
public String getAstChanHangupCauseStr()
{
    String ret = null;
    if (_astChanHangupCause != null)
    {
        ret = (String) _astChanHangupCauseMap.get(_astChanHangupCause);
    }
    return ret;
}
public Integer getAstChanHangupCause()
{
    return _astChanHangupCause;
}


/**
astChanVariables<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Channel Variables defined for this channel.
)<br/>
*/
public void setAstChanVariables(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanVariables = obj.toDisplayString();
}
public String getAstChanVariables()
{
    return _astChanVariables;
}


/**
astChanFlags<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 3] BITS (0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9)
  Access: read-only
  Status: current
  Description: Flags set on this channel.
)<br/>
*/
public void setAstChanFlags(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanFlags = obj.getBytes();
}
public String getAstChanFlagsStr()
{
    String ret = null;
    if (_astChanFlags != null)
    {
        StringBuffer buffer = new StringBuffer("[");
        int len = _astChanFlags.length;
        int pos = 0;
        boolean first = true;
        for (int i=0; i<len; i++)
        {
           byte b = _astChanFlags[i];
           // check the left hand bit 8 times whilst shifting left
           // if b is negative, this means the left hand bit is set
           for (int j=0; j<8; j++)
           {
               if (b < 0)
               {
                  if (first == false)
                  {
                      buffer.append(", ");
                  }
                  buffer.append(_astChanFlagsMap.get(new Integer(pos)));
                  first = false;
               }
               b = (byte) (b << 1);
               pos++;
           }
        }
        buffer.append("]");
        ret = buffer.toString();
    }
    return ret;
}
public byte[] getAstChanFlags()
{
    return _astChanFlags;
}


/**
astChanTransferCap<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (0 | 8 | 9 | 16 | 17 | 24)
  Access: read-only
  Status: current
  Description: Transfer Capabilities for this channel.
)<br/>
*/
public void setAstChanTransferCap(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astChanTransferCap = new Integer(obj.getValue());
}
public String getAstChanTransferCapStr()
{
    String ret = null;
    if (_astChanTransferCap != null)
    {
        ret = (String) _astChanTransferCapMap.get(_astChanTransferCap);
    }
    return ret;
}
public Integer getAstChanTransferCap()
{
    return _astChanTransferCap;
}


private java.net.InetAddress getInetAddress(AsnOctets obj)
{
    java.net.InetAddress iad = null;
    try
    {
        iad = java.net.InetAddress.getByAddress(obj.getBytes());
    }
    catch(java.net.UnknownHostException exc) { }
    return iad;
}


/**
 * Returns if this set of values is invalid.
 */
public boolean isInvalid()
{
    return _invalid;
}


/**
 * Sets _tmpErrorInd, but only once.
 */
private void setTmpErrorIndex(int errind)
{
    if (_tmpErrorInd == -1)
    {
        _tmpErrorInd = errind;
    }
}


public String toString()
{
    StringBuffer buffer = new StringBuffer(getClass().getName());
    buffer.append("[");
    buffer.append("astNumChannels=").append(_astNumChannels);
    buffer.append(", astChanIndex=").append(_astChanIndex);
    buffer.append(", astChanName=").append(_astChanName);
    buffer.append(", astChanLanguage=").append(_astChanLanguage);
    buffer.append(", astChanType=").append(_astChanType);
    buffer.append(", astChanMusicClass=").append(_astChanMusicClass);
    buffer.append(", astChanBridge=").append(_astChanBridge);
    buffer.append(", astChanMasq=").append(_astChanMasq);
    buffer.append(", astChanMasqr=").append(_astChanMasqr);
    buffer.append(", astChanWhenHangup=").append(_astChanWhenHangup);
    buffer.append(", astChanApp=").append(_astChanApp);
    buffer.append(", astChanData=").append(_astChanData);
    buffer.append(", astChanContext=").append(_astChanContext);
    buffer.append(", astChanMacroContext=").append(_astChanMacroContext);
    buffer.append(", astChanMacroExten=").append(_astChanMacroExten);
    buffer.append(", astChanMacroPri=").append(_astChanMacroPri);
    buffer.append(", astChanExten=").append(_astChanExten);
    buffer.append(", astChanPri=").append(_astChanPri);
    buffer.append(", astChanAccountCode=").append(_astChanAccountCode);
    buffer.append(", astChanForwardTo=").append(_astChanForwardTo);
    buffer.append(", astChanUniqueId=").append(_astChanUniqueId);
    buffer.append(", astChanCallGroup=").append(_astChanCallGroup);
    buffer.append(", astChanPickupGroup=").append(_astChanPickupGroup);
    buffer.append(", astChanState=").append(getAstChanStateStr());
    buffer.append(", astChanMuted=").append(getAstChanMutedStr());
    buffer.append(", astChanRings=").append(_astChanRings);
    buffer.append(", astChanCidDNID=").append(_astChanCidDNID);
    buffer.append(", astChanCidNum=").append(_astChanCidNum);
    buffer.append(", astChanCidName=").append(_astChanCidName);
    buffer.append(", astCanCidANI=").append(_astCanCidANI);
    buffer.append(", astChanCidRDNIS=").append(_astChanCidRDNIS);
    buffer.append(", astChanCidPresentation=").append(_astChanCidPresentation);
    buffer.append(", astChanCidANI2=").append(_astChanCidANI2);
    buffer.append(", astChanCidTON=").append(_astChanCidTON);
    buffer.append(", astChanCidTNS=").append(_astChanCidTNS);
    buffer.append(", astChanAMAFlags=").append(getAstChanAMAFlagsStr());
    buffer.append(", astChanADSI=").append(getAstChanADSIStr());
    buffer.append(", astChanToneZone=").append(_astChanToneZone);
    buffer.append(", astChanHangupCause=").append(getAstChanHangupCauseStr());
    buffer.append(", astChanVariables=").append(_astChanVariables);
    buffer.append(", astChanFlags=").append(getAstChanFlagsStr());
    buffer.append(", astChanTransferCap=").append(getAstChanTransferCapStr());
    buffer.append(", invalid=").append(_invalid);
    buffer.append("]");
    return buffer.toString();
}


}

