// NAME
//      $RCSfile: ListeningContextFace.java,v $
// DESCRIPTION
//      [given below in javadoc format]
// DELTA
//      $Revision: 3.5 $
// CREATED
//      $Date: 2006/02/09 14:30:19 $
// COPYRIGHT
//      Westhawk Ltd
// TO DO
//

/*
 * Copyright (C) 2005 - 2006 by Westhawk Ltd
 * <a href="www.westhawk.co.uk">www.westhawk.co.uk</a>
 *
 * Permission to use, copy, modify, and distribute this software
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that
 * both the copyright notice and this permission notice appear in
 * supporting documentation.
 * This software is provided "as is" without express or implied
 * warranty.
 * author <a href="mailto:snmp@westhawk.co.uk">Tim Panton</a>
 */

package uk.co.westhawk.snmp.stack;
import uk.co.westhawk.snmp.event.*;

/**
 * This interface contains the SNMP listening context methods.
 *
 * @since 4_14
 * @author <a href="mailto:snmp@westhawk.co.uk">Birgit Arkesteijn</a>
 * @version $Revision: 3.5 $ $Date: 2006/02/09 14:30:19 $
 */
public interface ListeningContextFace 
{
    static final String     version_id =
        "@(#)$Id: ListeningContextFace.java,v 3.5 2006/02/09 14:30:19 birgit Exp $ Copyright Westhawk Ltd";

    /**
     * The default port number where we listen for traps (162).
     */
    public final static int DEFAULT_TRAP_PORT = 162;


/**
 * Returns the port number.
 *
 * @return The port no
 */
public int getPort();

/**
 * Returns the local address the server will bind to
 * When the address is null, the socket accepts connections on
 * any/all local addresses.
 *
 * @return The bind address
 */
public String getBindAddress();

/**
 * Returns the type of socket.
 *
 * @see SnmpContextBasisFace#STANDARD_SOCKET
 * @see SnmpContextBasisFace#TCP_SOCKET
 * @see SnmpContextBasisFace#NETSCAPE_SOCKET
 * @see SnmpContextBasisFace#KVM_SOCKET
 * @return The type of socket 
 */
public String getTypeSocket();

/**
 * Returns the maximum number of bytes this context will read from the
 * socket. By default this will be set to <code>MSS</code> (i.e. 1300).
 *
 * @see SnmpContextBasisFace#MSS
 * @see #setMaxRecvSize(int)
 * @see AbstractSnmpContext#setMaxRecvSize(int)
 * @return The number 
 */
public int getMaxRecvSize();

/**
 * Sets the maximum number of bytes this context will read from the
 * socket. By default this will be set to <code>MSS</code> (i.e. 1300).
 *
 * @see SnmpContextBasisFace#MSS
 * @see AbstractSnmpContext#getMaxRecvSize()
 * @param no The new size 
 */
public void setMaxRecvSize(int no);

/**
 * Removes the resouces held by this context. 
 * This method will stop the thread listening for packets. 
 */
public void destroy();

/**
 * Adds the specified PDU listener to receive the undecoded PDUs.
 * When a PDU is received the PDU received event is fired to all 
 * listeners, until one of them consumes it.
 *
 * <p>
 * All the SnmpContext objects use this method to listen for PDUs. When
 * a SnmpContext object decodes the PDU succesfully, it will consume
 * it.
 * </p>
 *
 * <p>
 * Only when a listener is added will this context create a listening socket.
 * </p>
 *
 * @param l The listener object
 * @exception java.io.IOException Thrown when creating a listening
 * socket fails
 *
 * @see RawPduReceivedSupport#fireRawPduReceived
 * @see AbstractSnmpContext#addTrapListener
 * @see AbstractSnmpContext#addRequestPduListener
 * @see #addUnhandledRawPduListener(RawPduListener)
 */
public void addRawPduListener(RawPduListener l)
throws java.io.IOException;

/**
 * Removes the specified PDU listener. When there are no more listeners,
 * calls destroy().
 *
 * @param l The listener object
 */
public void removeRawPduListener(RawPduListener l);

/**
 * Adds the specified PDU listener to receive the undecoded PDUs when
 * it was not handled (i.e. not consumed) by any of the PDU listeners in
 * addRawPduListener().
 *
 * <p>
 * Only when a listener is added will this context create a listening socket.
 * </p>
 *
 * @param l The listener object
 * @exception java.io.IOException Thrown when creating a listening
 * socket fails
 *
 * @see #addRawPduListener(RawPduListener)
 */
public void addUnhandledRawPduListener(RawPduListener listener)
throws java.io.IOException;

/**
 * Removes the specified unhandled PDU listener. When there are no more 
 * listeners, calls destroy().
 *
 * @param l The listener object
 */
public void removeUnhandledRawPduListener(RawPduListener listener);

}
