/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko.printing;

import com.teamdev.jxbrowser.gecko.WebBrowser;
import com.teamdev.jxbrowser.gecko.events.impl.nsIWebProgressAdapter;
import com.teamdev.jxbrowser.gecko.printing.PrintEngineInitException;
import com.teamdev.jxbrowser.gecko.printing.PrintProgressListener;
import com.teamdev.jxbrowser.gecko.printing.PrintSettings;
import com.teamdev.jxbrowser.gecko.printing.PrintSettingsConvertor;
import com.teamdev.jxbrowser.gecko.printing.WebBrowserPrinting;
import com.teamdev.jxbrowser.gecko.printing.a;
import com.teamdev.jxbrowser.gecko.xpcom.ProxyObjectManager;
import com.teamdev.jxbrowser.gecko.xpcom.XPCOM;
import com.teamdev.jxbrowser.gecko.xpcom.XPCOMMessageLoop;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.print.PrintService;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIDocShell;
import org.mozilla.interfaces.nsIInterfaceRequestor;
import org.mozilla.interfaces.nsIObserver;
import org.mozilla.interfaces.nsIObserverService;
import org.mozilla.interfaces.nsIPrintSettings;
import org.mozilla.interfaces.nsIPrintSettingsService;
import org.mozilla.interfaces.nsIPrintingPromptService;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.interfaces.nsIWebBrowserPrint;
import org.mozilla.interfaces.nsIWebNavigation;
import org.mozilla.interfaces.nsIWebProgress;
import org.mozilla.interfaces.nsIWebProgressListener;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBrowserPrintingImpl
implements WebBrowserPrinting {
    private static final String b = "@mozilla.org/gfx/printsettings-service;1";
    private static final String c = "@mozilla.org/embedcomp/printingprompt-service;1";
    private static Logger d = LoggerFactory.getLogger(WebBrowserPrintingImpl.class);
    private final AtomicReference<nsIPrintSettings> e = new AtomicReference<Object>(null);
    private final AtomicReference<PrintSettings> f = new AtomicReference<Object>(null);
    private final ProxyObjectManager g = ProxyObjectManager.getInstance();
    private final nsIWebBrowser h;
    private nsIPrintingPromptService i;
    private nsIPrintSettingsService j;
    private nsIWebBrowserPrint k;
    private final AtomicInteger l = new AtomicInteger(1);
    private final AtomicBoolean m = new AtomicBoolean(false);
    final nsIWebProgressListener a = new a(this);

    public WebBrowserPrintingImpl(WebBrowser webBrowser) {
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIPrintSettingsService nsIPrintSettingsService2 = (nsIPrintSettingsService)Mozilla.getInstance().getServiceManager().getServiceByContractID(WebBrowserPrintingImpl.b, "{841387c8-72e6-484b-9296-bf6eea80d58a}");
                WebBrowserPrintingImpl.this.e.set(nsIPrintSettingsService2.getGlobalPrintSettings());
                WebBrowserPrintingImpl.this.f.set(PrintSettingsConvertor.a((nsIPrintSettings)WebBrowserPrintingImpl.this.e.get()));
            }
        });
        this.h = webBrowser.getNsIWebBrowser();
        this.i = this.g.proxyForService(c, nsIPrintingPromptService.class);
        this.j = this.g.proxyForService(b, nsIPrintSettingsService.class);
        this.j.initPrintSettingsFromPrefs(this.e.get(), false, 0xFFFFFFFFL);
        this.a();
    }

    private void a() {
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                nsIDOMWindow nsIDOMWindow2 = WebBrowserPrintingImpl.this.h.getContentDOMWindow();
                nsIInterfaceRequestor nsIInterfaceRequestor2 = (nsIInterfaceRequestor)nsIDOMWindow2.queryInterface("{033a1470-8b2a-11d3-af88-00a024ffc08c}");
                WebBrowserPrintingImpl.this.k = (nsIWebBrowserPrint)nsIInterfaceRequestor2.getInterface("{9a7ca4b0-fbba-11d4-a869-00105a183419}");
                WebBrowserPrintingImpl.this.initPrintSettingsFromDefaultPrinter();
            }
        });
    }

    @Override
    public void initPrintSettingsFromDefaultPrinter() {
        if (this.getAvailablePrintersNames().size() > 0) {
            this.j.initPrintSettingsFromPrinter(this.getDefaultPrinterName(), this.e.get());
            this.e.get().setPrintSilent(true);
        } else {
            this.j.initPrintSettingsFromPrefs(this.e.get(), false, 0xFFFFFFFFL);
            this.e.get().setPrintSilent(true);
            this.e.get().setShowPrintProgress(false);
        }
    }

    @Override
    public void initPrintSettingsFromPrinter(String string) {
        this.j.initPrintSettingsFromPrinter(string, this.e.get());
        this.j.savePrintSettingsToPrefs(this.e.get(), true, 0xFFFFFFFFL);
        Mozilla.getInstance().notifyProfile();
    }

    @Override
    public void initPrintSettings(final PrintSettings printSettings) {
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                WebBrowserPrintingImpl.this.f.set(printSettings);
                PrintSettingsConvertor.a((nsIPrintSettings)WebBrowserPrintingImpl.this.e.get(), (PrintSettings)WebBrowserPrintingImpl.this.f.get());
            }
        });
    }

    @Override
    public String getDefaultPrinterName() {
        return PrinterJob.getPrinterJob().getPrintService().getName();
    }

    @Override
    public PrintSettings getCurrentPrintSettings() {
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                WebBrowserPrintingImpl.this.f.set(PrintSettingsConvertor.a((nsIPrintSettings)WebBrowserPrintingImpl.this.e.get()));
            }
        });
        return this.f.get();
    }

    @Override
    public List<String> getAvailablePrintersNames() {
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PrintService printService : printServiceArray) {
            arrayList.add(printService.getName());
        }
        return arrayList;
    }

    @Override
    public int getPrintPreviewPageNumbers() {
        if (!this.isPrintPreviewMode()) {
            this.setPrintPreviewMode(true);
            this.setPrintPreviewMode(false);
        }
        return this.l.get();
    }

    @Override
    public boolean isPrintPreviewMode() {
        return this.m.get();
    }

    @Override
    public void print(final PrintProgressListener printProgressListener) {
        nsIWebProgressAdapter nsIWebProgressAdapter2 = new nsIWebProgressAdapter(){

            public void onProgressChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, int n2, int n3, int n4, int n5) {
                if (null != printProgressListener) {
                    printProgressListener.progressChanged(n4, n5);
                }
            }

            public void onStateChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l2, long l3) {
                boolean bl;
                boolean bl2 = bl = (l2 & 0x10L) == 16L;
                if (bl && null != printProgressListener) {
                    XPCOMMessageLoop.getInstance().exit();
                    printProgressListener.printingFinished();
                }
            }
        };
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        XPCOM.invokeAndWait(new Runnable((nsIWebProgressListener)nsIWebProgressAdapter2, atomicReference){
            final /* synthetic */ nsIWebProgressListener b;
            final /* synthetic */ AtomicReference c;
            {
                this.b = nsIWebProgressListener3;
                this.c = atomicReference;
            }

            public void run() {
                nsIWebNavigation nsIWebNavigation2 = (nsIWebNavigation)WebBrowserPrintingImpl.this.h.queryInterface("{f5d9e7b0-d930-11d3-b057-00a024ffc08c}");
                nsIWebNavigation2.stop(3L);
                nsIInterfaceRequestor nsIInterfaceRequestor2 = (nsIInterfaceRequestor)WebBrowserPrintingImpl.this.h.queryInterface("{033a1470-8b2a-11d3-af88-00a024ffc08c}");
                nsIDocShell nsIDocShell2 = (nsIDocShell)nsIInterfaceRequestor2.getInterface("{8adfb831-1053-4a19-884d-bcdad7277b4b}");
                boolean bl = nsIDocShell2.getAllowJavascript();
                nsIDocShell2.setAllowJavascript(!bl);
                PrintSettingsConvertor.a((nsIPrintSettings)WebBrowserPrintingImpl.this.e.get(), (PrintSettings)WebBrowserPrintingImpl.this.f.get());
                if (null != printProgressListener) {
                    printProgressListener.printingStarted((PrintSettings)WebBrowserPrintingImpl.this.f.get());
                }
                ((nsIPrintSettings)WebBrowserPrintingImpl.this.e.get()).setupSilentPrinting();
                ((nsIPrintSettings)WebBrowserPrintingImpl.this.e.get()).setShowPrintProgress(false);
                while (WebBrowserPrintingImpl.this.k.getDoingPrint() && !WebBrowserPrintingImpl.this.k.getDoingPrintPreview()) {
                    XPCOMMessageLoop.getInstance().run();
                }
                try {
                    WebBrowserPrintingImpl.this.k.print((nsIPrintSettings)WebBrowserPrintingImpl.this.e.get(), this.b);
                }
                catch (XPCOMException xPCOMException) {
                    if (null != printProgressListener) {
                        printProgressListener.printingFinished();
                    }
                    this.c.set(xPCOMException);
                }
                nsIDocShell2.setAllowJavascript(bl);
            }
        });
        if (null != atomicReference.get()) {
            throw new PrintEngineInitException(atomicReference.get());
        }
    }

    @Override
    public void printPreviewNavigate(final short s2, final int n2) {
        if (this.isPrintPreviewMode()) {
            XPCOM.invokeLater(new Runnable(){

                public void run() {
                    WebBrowserPrintingImpl.this.k.printPreviewNavigate(s2, n2);
                }
            });
        }
    }

    @Override
    public void setPrintPreviewMode(boolean bl) {
        if (bl && this.m.get()) {
            return;
        }
        nsIWebBrowserPrint nsIWebBrowserPrint2 = this.g.proxyForObject((nsISupports)this.k, nsIWebBrowserPrint.class, true);
        if (bl) {
            XPCOM.invokeAndWait(new Runnable(){

                public void run() {
                    PrintSettingsConvertor.a((nsIPrintSettings)WebBrowserPrintingImpl.this.e.get(), (PrintSettings)WebBrowserPrintingImpl.this.f.get());
                }
            });
            try {
                nsIWebBrowserPrint2.printPreview(this.e.get(), this.h.getContentDOMWindow(), this.a);
            }
            catch (XPCOMException xPCOMException) {
                if (xPCOMException.getMessage().contains("0x8048000e")) {
                    d.error("There must be at least one printer available to show Print Preview");
                }
                throw new RuntimeException(xPCOMException);
            }
            while (!this.m.get()) {
                XPCOM.lock();
            }
            this.l.set(this.k.getPrintPreviewNumPages());
        } else if (this.m.get()) {
            nsIWebBrowserPrint2.exitPrintPreview();
            this.m.set(false);
        }
    }

    @Override
    public void updatePrintPreview() {
        this.setPrintPreviewMode(false);
        this.setPrintPreviewMode(true);
    }

    @Override
    public void showPageSetupDialog() {
        final nsIObserver nsIObserver2 = new nsIObserver(){

            public void observe(nsISupports nsISupports2, String string, String string2) {
            }

            public nsISupports queryInterface(String string) {
                return Mozilla.queryInterface((nsISupports)this, string);
            }
        };
        XPCOM.invokeLater(new Runnable(){

            public void run() {
                nsIObserverService nsIObserverService2 = WebBrowserPrintingImpl.this.g.proxyForService("@mozilla.org/observer-service;1", nsIObserverService.class);
                nsIObserverService2.addObserver(nsIObserver2, "Ok", true);
                try {
                    WebBrowserPrintingImpl.this.i.showPageSetup(WebBrowserPrintingImpl.this.h.getContentDOMWindow(), (nsIPrintSettings)WebBrowserPrintingImpl.this.e.get(), nsIObserver2);
                }
                catch (XPCOMException xPCOMException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    @Deprecated
    public void showPrinterProperties(String string) {
        throw new RuntimeException("The showPrinterProperties not available since JxBrowser 1.0. Use Win/Mac/Tux pack or AWT functionality instead");
    }

    static /* synthetic */ AtomicBoolean e(WebBrowserPrintingImpl webBrowserPrintingImpl) {
        return webBrowserPrintingImpl.m;
    }
}

