/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko.xpcom;

import com.teamdev.jxbrowser.gecko.xpcom.MozillaCallback;
import com.teamdev.jxbrowser.gecko.xpcom.MozillaRunnable;
import com.teamdev.jxbrowser.gecko.xpcom.MozillaToolkit;
import com.teamdev.jxbrowser.gecko.xpcom.MozillaToolkitFactory;
import com.teamdev.jxbrowser.gecko.xpcom.ProxyObjectManager;
import com.teamdev.jxbrowser.gecko.xpcom.XPCOMMessageLoop;
import com.teamdev.jxbrowser.gecko.xpcom.XPCOMThread;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import org.mozilla.interfaces.nsIAppShell;
import org.mozilla.interfaces.nsIComponentManager;
import org.mozilla.interfaces.nsIRunnable;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.IAppFileLocProvider;
import org.mozilla.xpcom.Mozilla;

public class AppShellXPCOMThread
implements XPCOMThread {
    private final Semaphore a;
    private final Thread b;
    private final AtomicBoolean c;
    private final MozillaRunnable d;
    private final nsIRunnable e;
    private final Lock f = new ReentrantLock();

    protected AppShellXPCOMThread(final IAppFileLocProvider iAppFileLocProvider, final String string) {
        this.c = new AtomicBoolean(false);
        this.a = new Semaphore(0, true);
        this.b = new Thread("XPCOMMessageLoop"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                MozillaToolkit mozillaToolkit = new MozillaToolkitFactory().create();
                try {
                    mozillaToolkit.initialize(iAppFileLocProvider, string);
                }
                finally {
                    AppShellXPCOMThread.this.c.set(true);
                    AppShellXPCOMThread.this.unlock();
                }
                AppShellXPCOMThread.this.a();
                mozillaToolkit.terminate();
            }
        };
        this.b.setDaemon(true);
        this.b.start();
        while (!this.isAlive()) {
            this.lock();
        }
        this.d = new MozillaRunnable();
        this.e = ProxyObjectManager.getInstance().proxyForObject((nsISupports)this.d, nsIRunnable.class, true);
    }

    private void a() {
        nsIComponentManager nsIComponentManager2 = Mozilla.getInstance().getComponentManager();
        nsIAppShell nsIAppShell2 = (nsIAppShell)nsIComponentManager2.createInstance("{2d96b3df-c051-11d1-a827-0040959a28c9}", null, "{501403e9-a091-4780-ba55-cfd1e21287a1}");
        nsIAppShell2.run();
    }

    public boolean isMozillaThread() {
        return Thread.currentThread().getId() == this.b.getId();
    }

    public void lock() {
        if (this.isMozillaThread()) {
            throw new IllegalStateException("lock must be called only outside XPCOM message loop thread");
        }
        this.a.acquireUninterruptibly(1);
    }

    public void unlock() {
        if (!this.isMozillaThread()) {
            throw new IllegalStateException("unlock must be called only in XPCOM message loop thread");
        }
        this.a.release(1);
    }

    public boolean isAlive() {
        return this.c.get();
    }

    public void terminate() {
        int n2;
        if (this.isMozillaThread()) {
            throw new IllegalStateException("terminate cannot be called inside XPCOM message loop thread");
        }
        for (int i2 = n2 = XPCOMMessageLoop.getInstance().getNestingLevel(); i2 > -1; --i2) {
            XPCOMMessageLoop.getInstance().exit();
        }
        try {
            this.b.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public String getName() {
        return this.b.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(Runnable runnable) {
        block5: {
            if (!this.isMozillaThread()) {
                this.f.lock();
                try {
                    this.d.setTask(runnable);
                    this.e.run();
                    if (this.d.hasError()) {
                        Exception exception = this.d.getError();
                        this.d.clearError();
                        throw new RuntimeException(exception);
                    }
                    break block5;
                }
                finally {
                    this.f.unlock();
                }
            }
            runnable.run();
        }
    }

    public void invokeLater(Runnable runnable) {
        if (!this.isMozillaThread()) {
            MozillaCallback mozillaCallback = new MozillaCallback(runnable);
            ProxyObjectManager proxyObjectManager = ProxyObjectManager.getInstance();
            nsIRunnable nsIRunnable2 = proxyObjectManager.proxyForObject((nsISupports)mozillaCallback, nsIRunnable.class, false);
            nsIRunnable2.run();
        } else {
            runnable.run();
        }
    }

    public void invokeAtAWTAndWait(final Runnable runnable) {
        if (!this.isMozillaThread()) {
            throw new IllegalStateException("This method must be called only from XPC Message loop thread!");
        }
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    atomicBoolean.set(true);
                    XPCOMMessageLoop.getInstance().exit();
                }
            }
        });
        while (!atomicBoolean.get()) {
            XPCOMMessageLoop.getInstance().run();
        }
    }
}

