/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko.xpcom;

import java.lang.reflect.Field;
import java.util.Locale;
import org.mozilla.interfaces.nsIComponentManager;
import org.mozilla.interfaces.nsIInterfaceRequestor;
import org.mozilla.interfaces.nsIServiceManager;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPCOMManager {
    private static XPCOMManager a;
    private final nsIServiceManager b;
    private final nsIComponentManager c;

    public static XPCOMManager getInstance() {
        return a == null ? (a = new XPCOMManager()) : a;
    }

    private XPCOMManager() {
        Mozilla mozilla = Mozilla.getInstance();
        this.b = mozilla.getServiceManager();
        this.c = mozilla.getComponentManager();
    }

    public <T extends nsISupports> T getService(String string, Class<T> clazz) {
        try {
            nsISupports nsISupports2 = this.b.getServiceByContractID(string, Mozilla.getInterfaceIID(clazz));
            return (T)((nsISupports)clazz.cast(nsISupports2));
        }
        catch (XPCOMException xPCOMException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(clazz.getName());
            stringBuilder.append(" not implemented by ");
            stringBuilder.append(string);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }

    public <T extends nsISupports> T queryInterface(nsISupports nsISupports2, Class<T> clazz) {
        nsISupports nsISupports3;
        try {
            nsISupports3 = nsISupports2.queryInterface(Mozilla.getInterfaceIID(clazz));
        }
        catch (XPCOMException xPCOMException) {
            throw new ClassCastException(nsISupports2 + " not extends " + clazz.getName());
        }
        return (T)((nsISupports)clazz.cast(nsISupports3));
    }

    public <T extends nsISupports> boolean isInstanceOf(nsISupports nsISupports2, Class<T> clazz) {
        try {
            this.queryInterface(nsISupports2, clazz);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public <T extends nsISupports> T getInterface(nsIInterfaceRequestor nsIInterfaceRequestor2, Class<T> clazz) {
        nsISupports nsISupports2 = nsIInterfaceRequestor2.getInterface(Mozilla.getInterfaceIID(clazz));
        return (T)((nsISupports)clazz.cast(nsISupports2));
    }

    public <T extends nsISupports> T getService(String string, String string2) {
        return (T)this.b.getService(string, string2);
    }

    public <T extends nsISupports> T newComponent(String string, Class<T> clazz) {
        nsISupports nsISupports2 = this.c.createInstanceByContractID(string, null, Mozilla.getInterfaceIID(clazz));
        return (T)((nsISupports)clazz.cast(nsISupports2));
    }

    public static String guessIID(Class<? extends nsISupports> clazz) {
        try {
            String string = clazz.getName();
            String string2 = clazz.getSimpleName();
            String string3 = string.startsWith("org.mozilla.interfaces.ns") ? String.format("NS_%s_IID", string2.substring(2).toUpperCase(Locale.US)) : String.format("%s_IID", string2.toUpperCase(Locale.US));
            Field field = clazz.getDeclaredField(string3);
            return (String)field.get(clazz);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static String guessCID(Class<? extends nsISupports> clazz) {
        try {
            String string = clazz.getSimpleName();
            String string2 = String.format("%s_CID", string.toUpperCase(Locale.US));
            Field field = clazz.getDeclaredField(string2);
            return (String)field.get(clazz);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

