/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.xpcom;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.mozilla.interfaces.nsIComponentManager;
import org.mozilla.interfaces.nsIComponentRegistrar;
import org.mozilla.interfaces.nsILocalFile;
import org.mozilla.interfaces.nsIServiceManager;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.IAppFileLocProvider;
import org.mozilla.xpcom.IGRE;
import org.mozilla.xpcom.IJavaXPCOMUtils;
import org.mozilla.xpcom.IMozilla;
import org.mozilla.xpcom.IXPCOM;
import org.mozilla.xpcom.IXPCOMError;
import org.mozilla.xpcom.ProfileLock;
import org.mozilla.xpcom.XPCOMException;
import org.mozilla.xpcom.XPCOMInitializationException;

public class Mozilla
implements IGRE,
IJavaXPCOMUtils,
IMozilla,
IXPCOM,
IXPCOMError {
    private static Mozilla a = new Mozilla();
    private IGRE b = null;
    private IXPCOM c = null;
    private IMozilla d = null;
    private IJavaXPCOMUtils e = null;

    public static Mozilla getInstance() {
        return a;
    }

    private Mozilla() {
    }

    public static File getGREPath() {
        File file = new File(System.getProperty("GRE_HOME"));
        if (file.exists() && file.isDirectory()) {
            return file;
        }
        throw new RuntimeException("GRE_HOME doesn't exist");
    }

    public void initialize(File file) throws XPCOMInitializationException {
        try {
            Class<?> clazz = Class.forName("org.mozilla.xpcom.internal.MozillaImpl");
            this.d = (IMozilla)clazz.newInstance();
            Class<?> clazz2 = Class.forName("org.mozilla.xpcom.internal.GREImpl");
            this.b = (IGRE)clazz2.newInstance();
            Class<?> clazz3 = Class.forName("org.mozilla.xpcom.internal.XPCOMImpl");
            this.c = (IXPCOM)clazz3.newInstance();
            Class<?> clazz4 = Class.forName("org.mozilla.xpcom.internal.JavaXPCOMMethods");
            this.e = (IJavaXPCOMUtils)clazz4.newInstance();
        }
        catch (Exception exception) {
            throw new XPCOMInitializationException("Could not load org.mozilla.xpcom.internal.* classes", exception);
        }
        this.d.initialize(Mozilla.getGREPath());
    }

    public void initEmbedding(File file, File file2, IAppFileLocProvider iAppFileLocProvider) throws XPCOMException {
        try {
            this.b.initEmbedding(file, file2, iAppFileLocProvider);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public void termEmbedding() {
        try {
            try {
                this.b.termEmbedding();
            }
            catch (NullPointerException nullPointerException) {
                throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
            }
            this.d = null;
            this.b = null;
            this.c = null;
        }
        catch (Exception exception) {
            this.d = null;
            this.b = null;
            this.c = null;
            this.e = null;
            throw new RuntimeException(exception);
        }
    }

    public ProfileLock lockProfileDirectory(File file) throws XPCOMException {
        try {
            return this.b.lockProfileDirectory(file);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public void notifyProfile() {
        try {
            this.b.notifyProfile();
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public nsIServiceManager initXPCOM(File file, IAppFileLocProvider iAppFileLocProvider) throws XPCOMException {
        try {
            return this.c.initXPCOM(file, iAppFileLocProvider);
        }
        catch (XPCOMException xPCOMException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", xPCOMException);
        }
    }

    public void shutdownXPCOM(nsIServiceManager nsIServiceManager2) throws XPCOMException {
        try {
            this.c.shutdownXPCOM(nsIServiceManager2);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
        catch (Exception exception) {
            this.d = null;
            this.b = null;
            this.c = null;
            this.e = null;
            throw new RuntimeException(exception);
        }
    }

    public nsIServiceManager getServiceManager() throws XPCOMException {
        try {
            return this.c.getServiceManager();
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public nsIComponentManager getComponentManager() throws XPCOMException {
        try {
            return this.c.getComponentManager();
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public nsIComponentRegistrar getComponentRegistrar() throws XPCOMException {
        try {
            return this.c.getComponentRegistrar();
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public nsILocalFile newLocalFile(String string, boolean bl) throws XPCOMException {
        try {
            return this.c.newLocalFile(string, bl);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public static nsISupports queryInterface(nsISupports nsISupports2, String string) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(nsISupports2.getClass());
        while (!arrayList.isEmpty()) {
            Object object;
            Class clazz = (Class)arrayList.remove(0);
            String string2 = clazz.getName();
            if (string2.startsWith("java.") || string2.startsWith("javax.")) continue;
            if (clazz.isInterface() && string2.startsWith("org.mozilla") && (object = Mozilla.getInterfaceIID(clazz)) != null && string.equals(object)) {
                return nsISupports2;
            }
            object = clazz.getInterfaces();
            Collections.addAll(arrayList, object);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) continue;
            arrayList.add(clazz2);
        }
        return null;
    }

    public static String getInterfaceIID(Class clazz) {
        String string;
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = clazz.getName();
        int n2 = string3.lastIndexOf(".");
        String string4 = string2 = n2 <= 0 ? string3 : string3.substring(n2 + 1);
        if (string2.startsWith("ns")) {
            stringBuilder.append("NS_");
            stringBuilder.append(string2.substring(2).toUpperCase(Locale.US));
        } else {
            stringBuilder.append(string2.toUpperCase(Locale.US));
        }
        stringBuilder.append("_IID");
        try {
            Field field = clazz.getDeclaredField(stringBuilder.toString());
            string = (String)field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            string = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("ERROR: Could not get field " + stringBuilder.toString());
            string = null;
        }
        return string;
    }

    public long getNativeHandleFromAWT(Object object) {
        try {
            return this.d.getNativeHandleFromAWT(object);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public long wrapJavaObject(Object object, String string) {
        try {
            return this.e.wrapJavaObject(object, string);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public Object wrapXPCOMObject(long l2, String string) {
        try {
            return this.e.wrapXPCOMObject(l2, string);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }
}

