/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.util;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class ImageUtils {
    private ImageUtils() {
    }

    public static BufferedImage createBufferedImage(Image object) {
        if (object == null) {
            throw new RuntimeException("image == null for createBufferedImage");
        }
        if (object instanceof BufferedImage) {
            return (BufferedImage)object;
        }
        object = new PixelGrabber((Image)object, 0, 0, -1, -1, false);
        try {
            ((PixelGrabber)object).grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Pixel grabber was interrupted during examining the image.");
        }
        if ((((PixelGrabber)object).getStatus() & 0x80) != 0) {
            throw new RuntimeException("Pixel grabber was interrupted during examining the image.");
        }
        ColorModel colorModel = ((PixelGrabber)object).getColorModel();
        int n2 = ((PixelGrabber)object).getWidth();
        int n3 = ((PixelGrabber)object).getHeight();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n2, n3);
        writableRaster.setDataElements(0, 0, n2, n3, ((PixelGrabber)object).getPixels());
        return new BufferedImage(colorModel, writableRaster, false, new Hashtable());
    }

    public static Dimension getScaledSize(Dimension dimension, Dimension dimension2) {
        if (dimension.width <= dimension2.width && dimension.height <= dimension2.height) {
            return dimension;
        }
        double d2 = (double)dimension2.width / (double)dimension.width;
        double d3 = (double)dimension2.height / (double)dimension.height;
        if (d2 < d3) {
            return new Dimension(dimension2.width, (int)Math.round(d2 * (double)dimension.height));
        }
        return new Dimension((int)Math.round(d3 * (double)dimension.width), dimension2.height);
    }
}

