/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.mozilla;

import com.teamdev.jxbrowser.AbstractBrowser;
import com.teamdev.jxbrowser.BrowserFunction;
import com.teamdev.jxbrowser.BrowserType;
import com.teamdev.jxbrowser.Configurable;
import com.teamdev.jxbrowser.ContextMenuHandler;
import com.teamdev.jxbrowser.dom.DOMFactory;
import com.teamdev.jxbrowser.events.DisposeEvent;
import com.teamdev.jxbrowser.gecko.MozillaHttpObserver;
import com.teamdev.jxbrowser.gecko.WebBrowser;
import com.teamdev.jxbrowser.gecko.WindowCreator;
import com.teamdev.jxbrowser.gecko.events.HttpObserver;
import com.teamdev.jxbrowser.gecko.xpcom.ProxyObjectManager;
import com.teamdev.jxbrowser.gecko.xpcom.XPCOMManager;
import com.teamdev.jxbrowser.mozilla.MozillaConfigurable;
import com.teamdev.jxbrowser.mozilla.MozillaContextMenu;
import com.teamdev.jxbrowser.mozilla.MozillaEvents;
import com.teamdev.jxbrowser.mozilla.MozillaHistory;
import com.teamdev.jxbrowser.mozilla.MozillaHttpSecurity;
import com.teamdev.jxbrowser.mozilla.MozillaJavaScriptJavaBridge;
import com.teamdev.jxbrowser.mozilla.MozillaNewWindowManager;
import com.teamdev.jxbrowser.mozilla.MozillaOfflineHandler;
import com.teamdev.jxbrowser.mozilla.MozillaPrinting;
import com.teamdev.jxbrowser.mozilla.MozillaPrintingFactory;
import com.teamdev.jxbrowser.mozilla.MozillaPromptWatcher;
import com.teamdev.jxbrowser.mozilla.dom.MozillaDOMFactory;
import com.teamdev.jxbrowser.print.PrintListener;
import com.teamdev.jxbrowser.script.JavaScriptException;
import com.teamdev.jxbrowser.security.HttpSecurityHandler;
import java.awt.Component;
import java.awt.Image;
import java.util.List;
import org.mozilla.interfaces.nsIDOMWindowInternal;
import org.mozilla.interfaces.nsIPrefBranch;
import org.mozilla.interfaces.nsIPrefService;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebBrowser;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MozillaBrowser
extends AbstractBrowser<WebBrowser> {
    private static MozillaOfflineHandler a;
    private final WebBrowser b;
    private final DOMFactory c;
    private final MozillaHistory d;
    private final MozillaPrinting e;
    private final Configurable f;
    private final MozillaEvents g;
    private final MozillaHttpSecurity h;
    private final MozillaContextMenu i;
    private final MozillaJavaScriptJavaBridge j;

    MozillaBrowser(WebBrowser webBrowser) {
        this.b = webBrowser;
        this.i = new MozillaContextMenu(this);
        this.f = new MozillaConfigurable(this);
        this.h = new MozillaHttpSecurity(this);
        this.e = new MozillaPrintingFactory().create(this);
        this.d = new MozillaHistory(this);
        this.g = new MozillaEvents(this);
        this.b.setWindowCreator((WindowCreator)MozillaNewWindowManager.getInstance());
        this.c = new MozillaDOMFactory(this);
        this.j = new MozillaJavaScriptJavaBridge();
        if (a == null) {
            a = new MozillaOfflineHandler();
        }
        MozillaNewWindowManager.getInstance().register(this);
        MozillaPromptWatcher.getInstance().register(this);
    }

    @Override
    public void dispose() {
        if (!this.isDisposed()) {
            nsIWebBrowser nsIWebBrowser2 = this.b.getNsIWebBrowser();
            MozillaHttpObserver.getInstance().removeHttpObserver(nsIWebBrowser2);
            MozillaNewWindowManager.getInstance().unregister(this);
            MozillaPromptWatcher.getInstance().unregister(this);
            this.b.dispose();
            this.notifyListeners(new DisposeEvent(this));
        }
    }

    @Override
    public Configurable getConfigurable() {
        return this.f;
    }

    @Override
    public void setUserAgent(String string) {
        MozillaBrowser mozillaBrowser = ProxyObjectManager.getInstance();
        XPCOMManager xPCOMManager = XPCOMManager.getInstance();
        xPCOMManager = (nsIPrefService)mozillaBrowser.proxyForObject(xPCOMManager.getService("@mozilla.org/preferences-service;1", nsIPrefService.class), nsIPrefService.class, true);
        mozillaBrowser = (nsIPrefBranch)mozillaBrowser.proxyForObject((nsISupports)xPCOMManager.getBranch("general.useragent."), nsIPrefBranch.class, true);
        if (string == null || string.length() == 0) {
            int n2 = mozillaBrowser.getPrefType("override");
            if (n2 != 0) {
                mozillaBrowser.clearUserPref("override");
            }
            return;
        }
        mozillaBrowser.setCharPref("override", string);
    }

    @Override
    public String executeScript(String string) {
        String string2 = null;
        try {
            string2 = this.b.evaluateScript(string);
        }
        catch (Exception exception) {
            throw new JavaScriptException(exception.getMessage());
        }
        return string2;
    }

    @Override
    public Component getComponent() {
        return this.b.getComponent();
    }

    @Override
    public String getContent() {
        return this.b.getDocumentContent("text/html");
    }

    @Override
    public Document getDocument() {
        return this.c.createDocument(this.b.getDocument());
    }

    @Override
    public String getStatusMessage() {
        return this.g.getStatusMessage();
    }

    @Override
    public void setContextMenuHandler(ContextMenuHandler contextMenuHandler) {
        this.i.setContextMenuHandler(contextMenuHandler);
    }

    @Override
    public ContextMenuHandler getContextMenuHandler() {
        return this.i.getContextMenuHandler();
    }

    @Override
    public String getTitle() {
        return this.b.getTitle();
    }

    @Override
    public BrowserType getType() {
        return BrowserType.Mozilla;
    }

    @Override
    public void goBack() {
        this.d.a();
    }

    @Override
    public void goForward() {
        this.d.b();
    }

    @Override
    public boolean isDisposed() {
        return this.b.isDisposed();
    }

    @Override
    public boolean isNavigationFinished() {
        return this.g.isNavigationFinished();
    }

    @Override
    public void navigate(String string) {
        this.g.setNavigationFinished(false);
        this.b.navigate(string);
    }

    @Override
    public void navigate(String string, String string2) {
        this.g.setNavigationFinished(false);
        this.b.navigate(string, string2);
    }

    public void navigate(String string, String string2, long l2) {
        this.g.setNavigationFinished(false);
        this.b.navigate(string, string2, l2);
    }

    @Override
    public void refresh() {
        this.b.refresh();
    }

    @Override
    public void setContent(String string) {
        this.g.setNavigationFinished(false);
        this.setContent(string, null);
    }

    @Override
    public void setContent(String string, String string2) {
        this.b.setContentWithContext(string, "text/html", string2);
    }

    @Override
    public void stop() {
        this.b.stop();
    }

    @Override
    public Image toImage(boolean bl2) {
        return this.b.toImage();
    }

    @Override
    public HttpSecurityHandler getHttpSecurityHandler() {
        return this.h.getHandler();
    }

    @Override
    public void setHttpSecurityHandler(HttpSecurityHandler httpSecurityHandler) {
        this.h.setHandler(httpSecurityHandler);
    }

    @Override
    public String getCurrentLocation() {
        return this.b.getLocationURL();
    }

    @Override
    public boolean canGoBack() {
        return this.d.canGoBack();
    }

    @Override
    public boolean canGoForward() {
        return this.d.canGoForward();
    }

    @Override
    public List<String> getAllHistory() {
        return this.d.getAllHistory();
    }

    @Override
    public int getCurrentIndex() {
        return this.d.getCurrentIndex();
    }

    @Override
    public WebBrowser getPeer() {
        return this.b;
    }

    public void setHttpObserver(HttpObserver httpObserver) {
        MozillaBrowser mozillaBrowser = mozillaBrowser.b.getNsIWebBrowser();
        MozillaHttpObserver.getInstance().addHttpObserver((nsIWebBrowser)mozillaBrowser, httpObserver);
    }

    public boolean isMimeTypeSupported(String string) {
        XPCOMManager xPCOMManager = XPCOMManager.getInstance();
        MozillaBrowser mozillaBrowser = mozillaBrowser.b.getNsIWebBrowser().getContentDOMWindow();
        mozillaBrowser = (nsIDOMWindowInternal)xPCOMManager.queryInterface((nsISupports)mozillaBrowser, nsIDOMWindowInternal.class);
        mozillaBrowser = mozillaBrowser.getNavigator();
        mozillaBrowser = mozillaBrowser.getMimeTypes();
        long l2 = mozillaBrowser.getLength();
        int n2 = 0;
        while ((long)n2 < l2) {
            Object object = mozillaBrowser.item(n2);
            if ((object = object.getType()).equals(string)) {
                return true;
            }
            ++n2;
        }
        return string.startsWith("text/");
    }

    @Override
    public boolean isReady() {
        return this.isNavigationFinished();
    }

    @Override
    public void registerFunction(String string, BrowserFunction browserFunction) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("window." + string + " = function " + string + "() {\n" + "    netscape.security.PrivilegeManager.enablePrivilege(\"UniversalXPConnect\");\n" + "    var javaScriptJavaBridge = Components.classes['@mozilla.org/JavaScriptJavaBridge;1'].createInstance(Components.interfaces.nsIJavaScriptJavaBridge);\n" + "    var args = Components.classes[\"@mozilla.org/array;1\"].createInstance(Components.interfaces.nsIMutableArray);\n" + "    for (var i = 0; i < arguments.length; i++) {\n" + "        var variant = Components.classes[\"@mozilla.org/variant;1\"].createInstance(Components.interfaces.nsIWritableVariant);\n" + "        variant.setFromVariant(arguments[i]);\n" + "        args.appendElement(variant, false);\n" + "    }\n" + "    return javaScriptJavaBridge.callJavaFunction(\"" + string + "\", args);\n" + "}");
        this.executeScript(stringBuilder.toString());
        this.j.registerFunction(string, browserFunction);
    }

    @Override
    public void print() {
        this.print(null);
    }

    @Override
    public void print(PrintListener printListener) {
        if (this.e != null) {
            this.e.print(printListener);
        }
    }
}

