/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.mozilla;

import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.WebPolicyDelegate;
import com.teamdev.jxbrowser.events.DisposeEvent;
import com.teamdev.jxbrowser.events.NavigationEvent;
import com.teamdev.jxbrowser.events.NavigationFinishedEvent;
import com.teamdev.jxbrowser.events.NavigationListener;
import com.teamdev.jxbrowser.events.NavigationStatusCode;
import com.teamdev.jxbrowser.events.NavigationType;
import com.teamdev.jxbrowser.events.ProgressChangedEvent;
import com.teamdev.jxbrowser.events.ProgressListener;
import com.teamdev.jxbrowser.events.StatusChangedEvent;
import com.teamdev.jxbrowser.events.StatusListener;
import com.teamdev.jxbrowser.events.TitleChangedEvent;
import com.teamdev.jxbrowser.events.TitleListener;
import com.teamdev.jxbrowser.gecko.events.DisposeListener;
import com.teamdev.jxbrowser.gecko.events.LocationEvent;
import com.teamdev.jxbrowser.gecko.events.ProgressEvent;
import com.teamdev.jxbrowser.gecko.events.RequestListener;
import com.teamdev.jxbrowser.gecko.events.SecurityEvent;
import com.teamdev.jxbrowser.gecko.events.StateEvent;
import com.teamdev.jxbrowser.gecko.events.StatusChangeEvent;
import com.teamdev.jxbrowser.gecko.events.StatusChangeListener;
import com.teamdev.jxbrowser.gecko.events.StatusEvent;
import com.teamdev.jxbrowser.gecko.events.TitleChangeEvent;
import com.teamdev.jxbrowser.gecko.events.TitleChangeListener;
import com.teamdev.jxbrowser.mozilla.MozillaBrowser;
import java.util.Iterator;
import org.mozilla.interfaces.nsIHttpChannel;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsIStreamListener;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIURIContentListener;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MozillaEvents {
    private static final Logger a = LoggerFactory.getLogger(MozillaEvents.class);
    private String b;
    private MozillaBrowser c;
    private boolean d;

    MozillaEvents(MozillaBrowser mozillaBrowser) {
        this.c = mozillaBrowser;
        this.c.getPeer().addRequestListener((RequestListener)new DefaultRequestListener(this));
        this.c.getPeer().addStatusChangeListener((StatusChangeListener)new DefaultStatusListener(this));
        this.c.getPeer().addTitleChangeListener((TitleChangeListener)new DefaultTitleListener(this));
        this.c.getPeer().addDisposeListener((DisposeListener)new DefaultDisposeListener(this));
        this.c.getPeer().getNsIWebBrowser().setParentURIContentListener((nsIURIContentListener)new BeforeURLLoadedAdaptor(this));
    }

    public boolean isNavigationFinished() {
        return this.d;
    }

    public void setNavigationFinished(boolean bl2) {
        this.d = bl2;
    }

    public String getStatusMessage() {
        return this.b;
    }

    private static NavigationStatusCode a(StateEvent object) {
        try {
            object = (nsIRequest)object.getRequest();
            object = (nsIHttpChannel)object.queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
            if (object == null) {
                return NavigationStatusCode.UNKNOWN;
            }
            if (object.getRequestSucceeded()) {
                return NavigationStatusCode.OK;
            }
            long l2 = object.getResponseStatus();
            object = object.getResponseStatusText();
            return new NavigationStatusCode(l2, (String)object);
        }
        catch (XPCOMException xPCOMException) {
            a.debug("Response Status was not available because method called before the response has been received.");
            return NavigationStatusCode.UNKNOWN;
        }
    }

    private class DefaultDisposeListener
    implements DisposeListener {
        private /* synthetic */ MozillaEvents a;

        private DefaultDisposeListener(MozillaEvents mozillaEvents) {
            this.a = mozillaEvents;
        }

        public void disposed() {
            DisposeEvent disposeEvent = new DisposeEvent(((DefaultDisposeListener)((Object)iterator)).a.c);
            Iterator<com.teamdev.jxbrowser.events.DisposeListener> iterator = ((DefaultDisposeListener)((Object)iterator)).a.c.getDisposeListeners();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                com.teamdev.jxbrowser.events.DisposeListener disposeListener = iterator.next();
                disposeListener.browserDisposed(disposeEvent);
            }
        }
    }

    private class BeforeURLLoadedAdaptor
    implements nsIURIContentListener {
        private /* synthetic */ MozillaEvents a;

        private BeforeURLLoadedAdaptor(MozillaEvents mozillaEvents) {
            this.a = mozillaEvents;
        }

        public boolean onStartURIOpen(nsIURI object) {
            WebPolicyDelegate webPolicyDelegate = this.a.c.getServices().getWebPolicyDelegate();
            boolean bl2 = webPolicyDelegate.allowNavigation((NavigationEvent)(object = new NavigationEvent(this.a.c, object.getSpec())));
            if (!bl2) {
                this.a.setNavigationFinished(true);
            }
            return !bl2;
        }

        public boolean isPreferred(String string, String[] object) {
            NavigationEvent navigationEvent;
            object = this.a.c.getServices().getWebPolicyDelegate();
            boolean bl2 = object.allowMimeType(string, navigationEvent = new NavigationEvent(this.a.c, null));
            if (!bl2) {
                this.a.setNavigationFinished(true);
            }
            return bl2;
        }

        public boolean canHandleContent(String string, boolean bl2, String[] stringArray) {
            return true;
        }

        public boolean doContent(String string, boolean bl2, nsIRequest nsIRequest2, nsIStreamListener[] nsIStreamListenerArray) {
            throw new XPCOMException(2147500033L);
        }

        public nsISupports getLoadCookie() {
            throw new XPCOMException(2147500033L);
        }

        public void setLoadCookie(nsISupports nsISupports2) {
            throw new XPCOMException(2147500033L);
        }

        public nsIURIContentListener getParentContentListener() {
            throw new XPCOMException(2147500033L);
        }

        public void setParentContentListener(nsIURIContentListener nsIURIContentListener2) {
            throw new XPCOMException(2147500033L);
        }

        public nsISupports queryInterface(String string) {
            return Mozilla.queryInterface((nsISupports)this, (String)string);
        }
    }

    private class DefaultStatusListener
    implements StatusChangeListener {
        private /* synthetic */ MozillaEvents a;

        private DefaultStatusListener(MozillaEvents mozillaEvents) {
            this.a = mozillaEvents;
        }

        public void statusChanged(StatusChangeEvent object) {
            Object object2 = ((DefaultStatusListener)((Object)iterator)).a.c.getStatusMessage();
            if ((object = object.getStatus()).equals(object2) && ((String)object2).equals("Done")) {
                return;
            }
            v0.b = (String)object;
            object = new StatusChangedEvent(((DefaultStatusListener)((Object)iterator)).a.c, ((DefaultStatusListener)((Object)iterator)).a.getStatusMessage());
            Iterator<StatusListener> iterator = ((DefaultStatusListener)((Object)iterator)).a.c.getStatusListeners();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object2.statusChanged((StatusChangedEvent)object);
            }
        }
    }

    private class DefaultRequestListener
    implements RequestListener {
        private /* synthetic */ MozillaEvents a;

        private DefaultRequestListener(MozillaEvents mozillaEvents) {
            this.a = mozillaEvents;
        }

        public void locationChanged(LocationEvent object) {
            if (this.a.c.isNavigationFinished()) {
                object = object.getLocation();
                this.a((String)object, NavigationType.NAVIGATE);
                this.a(NavigationStatusCode.OK, (String)object);
            }
        }

        public void stateChanged(StateEvent object) {
            Object object2;
            Object object3;
            if (object.isRedirecting()) {
                object3 = object.getRequestUrlName();
                ((DefaultRequestListener)((Object)iterator)).a((String)object3, NavigationType.REDIRECT);
            }
            if (object.isLoadingStarted()) {
                object3 = object.getRequestUrlName();
                ((DefaultRequestListener)((Object)iterator)).a((String)object3, NavigationType.NAVIGATE);
            }
            if (object.isLoadingCompleted()) {
                object3 = object.getRequestUrlName();
                object2 = MozillaEvents.a(object);
                ((DefaultRequestListener)((Object)iterator)).a((NavigationStatusCode)object2, (String)object3);
            }
            if (object.isStoped()) {
                object3 = new StatusChangedEvent(((DefaultRequestListener)((Object)iterator)).a.c, "");
                object2 = ((DefaultRequestListener)((Object)iterator)).a.c.getStatusListeners();
                Iterator<StatusListener> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (StatusListener)iterator.next();
                    object.statusChanged((StatusChangedEvent)object3);
                }
            }
        }

        private void a(NavigationStatusCode object, String object2) {
            ((DefaultRequestListener)((Object)iterator)).a.setNavigationFinished(true);
            object = new NavigationFinishedEvent((Browser)((DefaultRequestListener)((Object)iterator)).a.c, (NavigationStatusCode)object, (String)object2);
            Iterator<NavigationListener> iterator = ((DefaultRequestListener)((Object)iterator)).a.c.getNavigationListeners();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object2.navigationFinished((NavigationFinishedEvent)object);
            }
        }

        private void a(String object, NavigationType object2) {
            ((DefaultRequestListener)((Object)iterator)).a.setNavigationFinished(false);
            object = new NavigationEvent(((DefaultRequestListener)((Object)iterator)).a.c, (String)object, null, (NavigationType)((Object)object2));
            Iterator<NavigationListener> iterator = ((DefaultRequestListener)((Object)iterator)).a.c.getNavigationListeners();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object2.navigationStarted((NavigationEvent)object);
            }
        }

        public void progressChanged(ProgressEvent object) {
            long l2 = object.getCurTotalProgress();
            long l3 = object.getMaxTotalProgress();
            if (l3 == -1L) {
                return;
            }
            if (l2 > l3) {
                l2 = l3;
            }
            object = new ProgressChangedEvent(((DefaultRequestListener)((Object)iterator)).a.c, l2, l3);
            Iterator<ProgressListener> iterator = ((DefaultRequestListener)((Object)iterator)).a.c.getProgressListeners();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ProgressListener progressListener = iterator.next();
                progressListener.progressChanged((ProgressChangedEvent)object);
            }
        }

        public void statusChanged(StatusEvent object) {
            object = new StatusChangedEvent(((DefaultRequestListener)((Object)iterator)).a.c, object.getMessage());
            Iterator<StatusListener> iterator = ((DefaultRequestListener)((Object)iterator)).a.c.getStatusListeners();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                StatusListener statusListener = iterator.next();
                statusListener.statusChanged((StatusChangedEvent)object);
            }
        }

        public void securityChanged(SecurityEvent securityEvent) {
        }
    }

    private class DefaultTitleListener
    implements TitleChangeListener {
        private /* synthetic */ MozillaEvents a;

        private DefaultTitleListener(MozillaEvents mozillaEvents) {
            this.a = mozillaEvents;
        }

        public void titleChanged(TitleChangeEvent object) {
            object = new TitleChangedEvent(((DefaultTitleListener)((Object)iterator)).a.c, object.getTitle());
            Iterator<TitleListener> iterator = ((DefaultTitleListener)((Object)iterator)).a.c.getTitleListeners();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                TitleListener titleListener = iterator.next();
                titleListener.titleChanged((TitleChangedEvent)object);
            }
        }
    }
}

