/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.safari;

import com.teamdev.jxbrowser.AbstractBrowser;
import com.teamdev.jxbrowser.BrowserFunction;
import com.teamdev.jxbrowser.BrowserType;
import com.teamdev.jxbrowser.Configurable;
import com.teamdev.jxbrowser.ContextMenuHandler;
import com.teamdev.jxbrowser.dom.DOMFactory;
import com.teamdev.jxbrowser.events.DisposeEvent;
import com.teamdev.jxbrowser.safari.BrowserFunctionProxy;
import com.teamdev.jxbrowser.safari.SafariConfigurable;
import com.teamdev.jxbrowser.safari.SafariEvents;
import com.teamdev.jxbrowser.safari.SafariNewWindowManager;
import com.teamdev.jxbrowser.safari.SafariPromptService;
import com.teamdev.jxbrowser.safari.dom.SafariDOMFactory;
import com.teamdev.jxbrowser.security.HttpSecurityHandler;
import com.teamdev.jxbrowser.webkit.Safari;
import com.teamdev.jxbrowser.webkit.SafariBrowserFunction;
import java.awt.Component;
import java.awt.Image;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SafariBrowser
extends AbstractBrowser<Safari> {
    private Safari a;
    private SafariEvents b;
    private SafariConfigurable c;
    private DOMFactory d;
    private HttpSecurityHandler e;

    SafariBrowser() {
        this(new Safari());
    }

    SafariBrowser(Safari safari) {
        this.a = safari;
        this.b = new SafariEvents(this);
        this.d = new SafariDOMFactory(this);
        this.c = new SafariConfigurable(this);
        SafariNewWindowManager.register(this);
        new SafariPromptService(this);
    }

    @Override
    public final Component getComponent() {
        return this.a.getComponent();
    }

    @Override
    public final String getContent() {
        return this.a.getHTML();
    }

    @Override
    public final Document getDocument() {
        Document document = this.a.getDocument();
        return this.d.createDocument(document);
    }

    @Override
    public final BrowserType getType() {
        return BrowserType.Safari;
    }

    @Override
    public final void setContent(String string) {
        this.b.setNavigationFinished(false);
        this.setContent(string, null);
    }

    @Override
    public final void setContent(String string, String string2) {
        this.a.setHTML(string, string2);
    }

    @Override
    public final Image toImage(boolean bl2) {
        return this.a.toImage();
    }

    @Override
    public final void goBack() {
        this.a.goBack();
    }

    @Override
    public final void goForward() {
        this.a.goForward();
    }

    @Override
    public final boolean isNavigationFinished() {
        return this.b.isNavigationFinished();
    }

    @Override
    public final void navigate(String string) {
        this.a.navigate(string);
    }

    @Override
    public final void navigate(String string, String string2) {
        this.navigate(string, string2, 0);
    }

    public final void navigate(String string, String object, int n2) {
        if (string == null) {
            throw new NullPointerException("The location parameter cannot be null.");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (object != null) {
            object = new StringTokenizer((String)object, "&");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                int n3 = string2.indexOf("=");
                if (n3 == -1) {
                    throw new IllegalArgumentException("The postData parameter has wrong format.");
                }
                String string3 = string2.substring(0, n3);
                string2 = string2.substring(n3 + 1);
                hashMap.put(string3, string2);
            }
        }
        this.a.navigate(string, hashMap, n2);
    }

    @Override
    public final void refresh() {
        this.a.reload();
    }

    @Override
    public final void stop() {
        this.a.stop();
    }

    @Override
    public final boolean canGoBack() {
        return this.a.canGoBack();
    }

    @Override
    public final boolean canGoForward() {
        return this.a.canGoForward();
    }

    @Override
    public final List<String> getAllHistory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getCurrentIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getCurrentLocation() {
        return this.a.getLocationURL();
    }

    @Override
    public final HttpSecurityHandler getHttpSecurityHandler() {
        return this.e;
    }

    @Override
    public final void setHttpSecurityHandler(HttpSecurityHandler httpSecurityHandler) {
        this.e = httpSecurityHandler;
    }

    @Override
    public final String executeScript(String string) {
        return this.a.executeScript(string);
    }

    @Override
    public final ContextMenuHandler getContextMenuHandler() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getStatusMessage() {
        return this.b.getStatusMessage();
    }

    @Override
    public final String getTitle() {
        return this.b.getTitle();
    }

    @Override
    public final void setContextMenuHandler(ContextMenuHandler contextMenuHandler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void dispose() {
        if (!this.isDisposed()) {
            this.a.dispose();
            this.notifyListeners(new DisposeEvent(this));
        }
    }

    @Override
    public final boolean isDisposed() {
        return this.a.isDisposed();
    }

    @Override
    public final Configurable getConfigurable() {
        return this.c;
    }

    @Override
    public final void setUserAgent(String string) {
        this.a.setUserAgent(string);
    }

    @Override
    public final Safari getPeer() {
        return this.a;
    }

    @Override
    public final boolean isReady() {
        return this.a.isReady();
    }

    @Override
    public final void registerFunction(String string, BrowserFunction browserFunction) {
        this.a.registerFunction(string, (SafariBrowserFunction)new BrowserFunctionProxy(browserFunction));
    }
}

