/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.safari;

import com.teamdev.jxbrowser.Configurable;
import com.teamdev.jxbrowser.Feature;
import com.teamdev.jxbrowser.safari.SafariBrowser;
import com.teamdev.jxbrowser.webkit.webkit.WebPreferences;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SafariConfigurable
implements Configurable {
    private SafariBrowser a;
    private WebPreferences b;
    private final Map<Feature, FeatureStateChanger> c;

    SafariConfigurable(SafariBrowser safariBrowser) {
        this.a = safariBrowser;
        this.b = safariBrowser.getPeer().getPreferences();
        this.c = new HashMap<Feature, FeatureStateChanger>();
        this.c.put(Feature.DOWNLOAD_IMAGES, new ImagesStateChanger(this));
        this.c.put(Feature.JAVASCRIPT, new JavascriptStateChanger(this));
        this.c.put(Feature.PLUGINS, new PluginsStateChanger(this));
        new JavaPluginStateChanger(this).change(false);
    }

    @Override
    public void disableFeature(Feature feature) {
        this.a(feature, false);
    }

    @Override
    public void enableFeature(Feature feature) {
        this.a(feature, true);
    }

    @Override
    public Map<Feature, Boolean> getFeatures() {
        HashMap<Feature, Boolean> hashMap = new HashMap<Feature, Boolean>();
        hashMap.put(Feature.DOWNLOAD_IMAGES, this.b.canLoadsImagesAutomatically());
        hashMap.put(Feature.JAVASCRIPT, this.b.isJavaScriptEnabled());
        hashMap.put(Feature.PLUGINS, this.b.arePlugInsEnabled() && this.b.isJavaEnabled());
        return hashMap;
    }

    @Override
    public void setFeatures(Map<Feature, Boolean> map) {
        for (Feature feature : map.keySet()) {
            this.a(feature, map.get((Object)feature));
        }
    }

    private void a(Feature feature, boolean bl2) {
        if (this.c.containsKey((Object)feature)) {
            this.c.get((Object)feature).change(bl2);
        }
    }

    private class JavaPluginStateChanger
    implements FeatureStateChanger {
        private /* synthetic */ SafariConfigurable a;

        private JavaPluginStateChanger(SafariConfigurable safariConfigurable) {
            this.a = safariConfigurable;
        }

        public void change(boolean bl2) {
            this.a.b.setJavaEnabled(bl2);
            this.a.a.getPeer().setPreferences(this.a.b);
        }
    }

    private class PluginsStateChanger
    implements FeatureStateChanger {
        private /* synthetic */ SafariConfigurable a;

        private PluginsStateChanger(SafariConfigurable safariConfigurable) {
            this.a = safariConfigurable;
        }

        public void change(boolean bl2) {
            this.a.b.setPlugInsEnabled(bl2);
            this.a.b.setJavaEnabled(false);
            this.a.a.getPeer().setPreferences(this.a.b);
        }
    }

    private class JavascriptStateChanger
    implements FeatureStateChanger {
        private /* synthetic */ SafariConfigurable a;

        private JavascriptStateChanger(SafariConfigurable safariConfigurable) {
            this.a = safariConfigurable;
        }

        public void change(boolean bl2) {
            this.a.b.setJavaScriptEnabled(bl2);
            this.a.a.getPeer().setPreferences(this.a.b);
        }
    }

    private class ImagesStateChanger
    implements FeatureStateChanger {
        private /* synthetic */ SafariConfigurable a;

        private ImagesStateChanger(SafariConfigurable safariConfigurable) {
            this.a = safariConfigurable;
        }

        public void change(boolean bl2) {
            this.a.b.setLoadsImagesAutomatically(bl2);
            this.a.a.getPeer().setPreferences(this.a.b);
        }
    }

    private static interface FeatureStateChanger {
        public void change(boolean var1);
    }
}

