/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.WinFunctionCache;
import com.jniwrapper.win32.gdi.EnumFamCallBack;
import com.jniwrapper.win32.gdi.WindowDC;

public class Gdi32
extends WinFunctionCache {
    static final String FUNCTION_GET_STOCK_OBJECT = "GetStockObject";
    static final String FUNCTION_ENUM_FONT_FAMILIES = "EnumFontFamilies";
    private static Gdi32 _instance;

    public Gdi32() {
        super("gdi32");
    }

    public static Gdi32 getInstance() {
        if (_instance == null) {
            _instance = new Gdi32();
        }
        return _instance;
    }

    public static Handle getStockObject(int objectType) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_GET_STOCK_OBJECT);
        Int brType = new Int((long)objectType);
        Handle handle = new Handle();
        long errorCode = function.invoke((Parameter)handle, (Parameter)brType);
        if (handle.getValue() == 0L) {
            throw new LastErrorException(errorCode, "Failed to get stock object", true);
        }
        return handle;
    }

    public static Function get(String functionName) {
        return Gdi32.getInstance().getFunction(functionName);
    }

    public static void enumFontFamilies() {
        WindowDC dc = new WindowDC(0L);
        Int32 lparam = new Int32();
        EnumFamCallBack callBack = new EnumFamCallBack();
        Function f = Gdi32.getInstance().getFunction(FUNCTION_ENUM_FONT_FAMILIES);
        f.invoke(null, (Parameter)dc, (Parameter)new UInt32(0L), (Parameter)new Pointer((Parameter)callBack), (Parameter)lparam);
    }

    public static void main(String[] args) {
        Gdi32.enumFontFamilies();
    }
}

