/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.hook;

import com.jniwrapper.AnsiString;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Library;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.hook.CBTHook;
import com.jniwrapper.win32.hook.EventsFilter;
import com.jniwrapper.win32.hook.HookEventListener;
import com.jniwrapper.win32.hook.HookEventObject;
import com.jniwrapper.win32.hook.LowLevelKeyboardHook;
import com.jniwrapper.win32.hook.LowLevelMouseHook;
import com.jniwrapper.win32.hook.data.HooksData;
import com.jniwrapper.win32.system.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Hook {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$hook$Hook == null ? (class$com$jniwrapper$win32$hook$Hook = Hook.class$("com.jniwrapper.win32.hook.Hook")) : class$com$jniwrapper$win32$hook$Hook));
    private static final String FUNCTION_InstallHook = "InstallHook";
    private static final String FUNCTION_UninstallHook = "UninstallHook";
    private static Library _library;
    protected final List _listeners = new LinkedList();
    private Thread _eventsThread = null;
    private HookEventLoop _eventLoop = null;
    private Descriptor _descriptor;
    private boolean _installed = false;
    private final HooksData _hooksData = new HooksData();
    private boolean _synchronous = false;
    public static final Hook JOURNALRECORD;
    public static final Hook KEYBOARD;
    public static final Hook KEYBOARD_LL;
    public static final Hook GETMESSAGE;
    public static final Hook CALLWNDPROC;
    public static final CBTHook CBT;
    public static final Hook SYSMSGFILTER;
    public static final Hook MOUSE;
    public static final Hook MOUSE_LL;
    public static final Hook SHELL;
    public static final Hook FOREGROUNDIDLE;
    public static final Hook CALLWNDPROCRET;
    static /* synthetic */ Class class$com$jniwrapper$win32$hook$Hook;

    Hook(Descriptor descriptor) {
        this._descriptor = descriptor;
    }

    public Descriptor getDescriptor() {
        return this._descriptor;
    }

    public boolean isInstalled() {
        return this._installed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(HookEventListener listener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(HookEventListener listener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.remove(listener);
        }
    }

    public void install() {
        if (this.isInstalled()) {
            throw new IllegalStateException("Hook is already instaled.");
        }
        this._eventLoop = new HookEventLoop();
        this._eventsThread = new Thread(this._eventLoop);
        this._eventsThread.start();
        while (!this._eventLoop._messageThreadAlive) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void uninstall() {
        if (!this.isInstalled()) {
            throw new IllegalStateException("Hook is not installed.");
        }
        this._eventLoop.uninstall();
        try {
            this._eventsThread.join();
            this._eventsThread = null;
        }
        catch (InterruptedException e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    private static Library getLibrary() {
        if (_library == null) {
            _library = new Library(Library.NATIVE_CODE);
        }
        return _library;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(HookEventObject event) {
        LinkedList listeners;
        List list = this._listeners;
        synchronized (list) {
            listeners = new LinkedList(this._listeners);
        }
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            HookEventListener listener = (HookEventListener)i.next();
            listener.onHookEvent(event);
        }
    }

    public boolean isSynchronous() {
        if (this.isInstalled()) {
            this._synchronous = this._hooksData.getSynchronous(this);
            return this._synchronous;
        }
        return this._synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this._synchronous = synchronous;
        if (this.isInstalled()) {
            this._hooksData.setSynchronous(this, synchronous);
        }
    }

    public void setFilter(EventsFilter filter) {
        if (!this.isInstalled()) {
            throw new IllegalStateException("Hook is not installed yet");
        }
        this._hooksData.setHookFilter(this.getDescriptor(), filter);
    }

    public EventsFilter getFilter() {
        return this._hooksData.getHookFilter(this.getDescriptor());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        JOURNALRECORD = new Hook(Descriptor.JOURNALRECORD);
        KEYBOARD = new Hook(Descriptor.KEYBOARD);
        KEYBOARD_LL = new LowLevelKeyboardHook();
        GETMESSAGE = new Hook(Descriptor.GETMESSAGE);
        CALLWNDPROC = new Hook(Descriptor.CALLWNDPROC);
        CBT = new CBTHook();
        SYSMSGFILTER = new Hook(Descriptor.SYSMSGFILTER);
        MOUSE = new Hook(Descriptor.MOUSE);
        MOUSE_LL = new LowLevelMouseHook();
        SHELL = new Hook(Descriptor.SHELL);
        FOREGROUNDIDLE = new Hook(Descriptor.FOREGROUNDIDLE);
        CALLWNDPROCRET = new Hook(Descriptor.CALLWNDPROCRET);
    }

    private class HookEventLoop
    implements Runnable {
        private EventObject _eventObject;
        private EventObject _eventFeedback;
        private boolean _messageThreadAlive = false;

        private HookEventLoop() {
        }

        private void installHook() {
            Function install = Hook.getLibrary().getFunction(Hook.FUNCTION_InstallHook);
            install.setCallingConvention((byte)1);
            Pointer hookDataPtr = new Pointer((Parameter)Hook.this._hooksData);
            install.invoke((Parameter)hookDataPtr, (Parameter)new Int((long)Hook.this._descriptor.getValue()), (Parameter)new AnsiString(Hook.this._descriptor.getName()));
            Hook.this._hooksData.setSynchronous(Hook.this, Hook.this._synchronous);
            Hook.this._installed = true;
        }

        public void run() {
            this._eventObject = new EventObject(Hook.this._descriptor.getName());
            this._eventObject.reset();
            this._eventFeedback = new EventObject(Hook.this._descriptor.getName() + ".feedback");
            this._eventFeedback.reset();
            this.installHook();
            this._messageThreadAlive = true;
            while (this._messageThreadAlive) {
                this._eventObject.waitFor();
                if (!this._messageThreadAlive) continue;
                HookEventObject event = Hook.this._hooksData.readEvent(Hook.this._descriptor);
                Hook.this.notifyListeners(event);
                this._eventObject.reset();
                this._eventFeedback.notifyEvent();
            }
            Function uninstall = Hook.getLibrary().getFunction(Hook.FUNCTION_UninstallHook);
            uninstall.setCallingConvention((byte)1);
            uninstall.invoke(null, (Parameter)new UInt((long)Hook.this._descriptor.getValue()));
            this._eventObject.reset();
            this._eventObject.close();
            this._eventFeedback.close();
            Hook.this._installed = false;
        }

        private void uninstall() {
            this._messageThreadAlive = false;
            this._eventObject.notifyEvent();
        }
    }

    public static class Descriptor
    extends EnumItem {
        public static final Descriptor JOURNALRECORD = new Descriptor(0, "JOURNALRECORD", true);
        public static final Descriptor JOURNALPLAYBACK = new Descriptor(1, "JOURNALPLAYBACK", true);
        public static final Descriptor KEYBOARD = new Descriptor(2, "KEYBOARD");
        public static final Descriptor GETMESSAGE = new Descriptor(3, "GETMESSAGE");
        public static final Descriptor CALLWNDPROC = new Descriptor(4, "CALLWNDPROC");
        public static final Descriptor CBT = new Descriptor(5, "CBT");
        public static final Descriptor SYSMSGFILTER = new Descriptor(6, "SYSMSGFILTER", true);
        public static final Descriptor MOUSE = new Descriptor(7, "MOUSE");
        public static final Descriptor HARDWARE = new Descriptor(8, "HARDWARE");
        public static final Descriptor DEBUG = new Descriptor(9, "DEBUG");
        public static final Descriptor SHELL = new Descriptor(10, "SHELL");
        public static final Descriptor FOREGROUNDIDLE = new Descriptor(11, "FOREGROUNDIDLE");
        public static final Descriptor CALLWNDPROCRET = new Descriptor(12, "CALLWNDPROCRET");
        public static final Descriptor KEYBOARD_LL = new Descriptor(13, "KEYBOARD_LL", true);
        public static final Descriptor MOUSE_LL = new Descriptor(14, "MOUSE_LL", true);
        private static final String NAME_PREFIX = "JNIWrapperHook.";
        private boolean _globalOnly;
        private String _name = null;

        private Descriptor(int value, String name) {
            this(value, name, false);
        }

        private Descriptor(int value, String name, boolean globalOnly) {
            super(value);
            this._globalOnly = globalOnly;
            this._name = NAME_PREFIX + name;
        }

        public boolean isGlobalOnly() {
            return this._globalOnly;
        }

        public String getName() {
            return this._name;
        }
    }
}

